/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.eviction;

import java.util.concurrent.RejectedExecutionException;
import org.cache2k.CacheClosedException;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.api.NeedsClose;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.EvictionMetrics;
import org.cache2k.operation.Scheduler;
import org.cache2k.operation.TimeReference;

public class IdleScan
implements NeedsClose {
    private static final long IDLE = -1L;
    private final long roundTicks;
    private final Scheduler scheduler;
    private final TimeReference clock;
    private final Eviction eviction;
    private long lastWakeupTicks;
    private long roundStartTicks = -1L;
    private long roundStartScans;
    private long scansPerRound;
    private long wakeupIntervalMillis;
    private long evictedCount = 0L;
    private long lastScanCount = 0L;
    private long roundStartCount = 0L;
    private long roundCompleteCount = 0L;
    private long roundAbortCount = 0L;
    static final int PRECISION_SIZE_THRESHOLD = 100;
    static final int REGULAR_WAKEUPS_PER_ROUND = 100;
    static final int MAX_SCAN_PER_WAKEUP = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdleScan(TimeReference clock, Scheduler scheduler, Eviction eviction, long roundTicks) {
        this.scheduler = scheduler;
        this.clock = clock;
        this.eviction = eviction;
        this.roundTicks = roundTicks;
        IdleScan idleScan = this;
        synchronized (idleScan) {
            this.scheduleIdleWakeup(eviction.getMetrics());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idleWakeup() {
        IdleScan idleScan = this;
        synchronized (idleScan) {
            boolean empty;
            long now = this.clock.ticks();
            EvictionMetrics metrics = this.eviction.getMetrics();
            long size = metrics.getSize();
            long scansSinceLastWakeup = metrics.getScanCount() - this.lastScanCount;
            boolean enoughScanActivity = scansSinceLastWakeup >= size;
            boolean bl = empty = size == 0L;
            if (empty || enoughScanActivity) {
                this.scheduleIdleWakeup(metrics);
                return;
            }
            this.startNewScanRound(now, metrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanWakeup() {
        int extraScan;
        IdleScan idleScan = this;
        synchronized (idleScan) {
            long now;
            this.lastWakeupTicks = now = this.clock.ticks();
            EvictionMetrics metrics = this.eviction.getMetrics();
            long expectedScans = this.scansPerRound * (now - this.roundStartTicks) / this.roundTicks + this.roundStartScans - metrics.getIdleNonEvictDrainCount();
            long remainingScans = this.roundStartScans + this.scansPerRound - expectedScans;
            extraScan = (int)(expectedScans - metrics.getScanCount());
            if ((long)extraScan < -remainingScans || metrics.getSize() == 0L) {
                this.scheduleIdleWakeup(metrics);
                return;
            }
            if (extraScan <= 0) {
                this.scheduleNextWakeup(this.wakeupIntervalMillis);
                return;
            }
            if (now >= this.roundStartTicks + this.roundTicks) {
                this.startNewScanRound(now, metrics);
            } else {
                this.scheduleNextWakeup(this.wakeupIntervalMillis);
            }
        }
        try {
            long count = this.eviction.evictIdleEntries(extraScan);
            IdleScan idleScan2 = this;
            synchronized (idleScan2) {
                this.evictedCount += count;
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
    }

    static long calculateWakeupIntervalTicks(long roundTicks, long scansPerRound) {
        if (scansPerRound <= 100L) {
            return roundTicks / scansPerRound;
        }
        long ticksThroughput = roundTicks / 100L;
        long ticksLimited = roundTicks / (scansPerRound / 50L);
        return Math.min(ticksThroughput, ticksLimited);
    }

    private void startNewScanRound(long now, EvictionMetrics metrics) {
        long size;
        if (this.roundStartTicks != -1L) {
            ++this.roundCompleteCount;
        }
        this.scansPerRound = size = metrics.getSize();
        ++this.roundStartCount;
        this.lastWakeupTicks = this.roundStartTicks = now;
        this.roundStartScans = this.eviction.startNewIdleScanRound();
        long rawWakeupIntervalMillis = this.clock.ticksToMillisCeiling(IdleScan.calculateWakeupIntervalTicks(this.roundTicks, this.scansPerRound));
        this.wakeupIntervalMillis = Math.max(1L, rawWakeupIntervalMillis);
        this.scheduleNextWakeup(this.wakeupIntervalMillis);
    }

    private void scheduleIdleWakeup(EvictionMetrics metrics) {
        if (this.roundStartTicks != -1L) {
            ++this.roundAbortCount;
        }
        this.roundStartTicks = -1L;
        this.lastScanCount = metrics.getScanCount();
        IdleScan.scheduleIgnoreException(this.scheduler, this::idleWakeup, this.clock.ticksToMillisCeiling(this.roundTicks));
    }

    private void scheduleNextWakeup(long delayMillis) {
        IdleScan.scheduleIgnoreException(this.scheduler, this::scanWakeup, delayMillis);
    }

    private static void scheduleIgnoreException(Scheduler scheduler, Runnable runnable, long delayMillis) {
        try {
            scheduler.schedule(runnable, delayMillis);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close(InternalCacheCloseContext closeContext) {
        closeContext.closeCustomization(this.scheduler, "scheduler for idle processing");
    }

    private int getIdleScanPercent() {
        return (int)((this.lastWakeupTicks - this.roundStartTicks) * 100L / this.roundTicks);
    }

    public synchronized String toString() {
        return "idleScanRoundStarted=" + this.roundStartCount + ", idleScanRoundCompleted=" + this.roundCompleteCount + ", idleScanRoundAbort=" + this.roundAbortCount + ", idleEvicted=" + this.evictedCount + ", idleScanPercent=" + (this.roundStartTicks == -1L ? "IDLE" : Integer.valueOf(this.getIdleScanPercent()));
    }
}

