/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

public class IntegrityState {
    private final StringBuilder builder = new StringBuilder();
    private boolean failure = false;
    private String groupPrefix = "";
    private int bitNr = 0;

    protected IntegrityState check(String check, String note, boolean f) {
        if (check == null || check.length() == 0) {
            check = "test#" + this.bitNr;
        }
        if (!f) {
            if (this.builder.length() > 0) {
                this.builder.append(", ");
            }
            this.builder.append(this.groupPrefix).append(check);
            if (note != null) {
                this.builder.append('(').append(note).append(')');
            }
            this.failure = true;
        }
        ++this.bitNr;
        return this;
    }

    public IntegrityState group(String group) {
        this.groupPrefix = group == null || group.isEmpty() ? "" : group + ":";
        return this;
    }

    public IntegrityState check(String check, boolean f) {
        this.check(check, null, f);
        return this;
    }

    public IntegrityState checkEquals(String check, int v1, int v2) {
        if (v1 == v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + "==" + v2, false);
        }
        return this;
    }

    public IntegrityState checkEquals(String check, long v1, long v2) {
        if (v1 == v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + "==" + v2, false);
        }
        return this;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public String getFailingChecks() {
        return this.builder.toString();
    }
}

