/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

public class IntegerTo16BitFloatingPoint {
    private static final int FRACTION_BITS = 10;

    public static int compress(int v) {
        if (v <= 0) {
            if (v == 0) {
                return 0;
            }
            throw new IllegalArgumentException("weight must be positive");
        }
        int exp = 22 - Integer.numberOfLeadingZeros(v);
        if (exp < 0) {
            return v;
        }
        return exp << 10 | v >> exp;
    }

    public static int expand(int v) {
        int exp = v >> 10;
        return (v & 0x3FF) << exp;
    }
}

