/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.Executor;
import org.cache2k.Cache;
import org.cache2k.CacheClosedException;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CustomizationException;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExpiryPolicyException;
import org.cache2k.core.HeapCache;
import org.cache2k.core.ResiliencePolicyException;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.timing.Timing;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.event.CacheEventListenerException;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoaderException;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.CacheWriterException;

public abstract class EntryAction<K, V, R>
extends Entry.PiggyBack
implements Runnable,
AsyncCacheLoader.Context<K, V>,
AsyncCacheLoader.Callback<V>,
Progress<K, V, R> {
    public static final Entry NON_FRESH_DUMMY = new Entry();
    static final CompletedCallback NOOP_CALLBACK = ea -> {};
    final InternalCache<K, V> internalCache;
    final HeapCache<K, V> heapCache;
    K key;
    Semantic<K, V, R> operation;
    volatile Entry<K, V> heapEntry;
    ExaminationEntry<K, V> heapOrLoadedEntry;
    Object newValueOrException;
    long mutationStartTime;
    long lastRefreshTime;
    long loadStartedTime;
    long loadCompletedTime;
    boolean remove;
    boolean expiredImmediately;
    long expiry = 0L;
    boolean entryLocked = false;
    boolean heapDataValid = false;
    boolean heapMiss = false;
    boolean wantData = false;
    boolean heapHit = false;
    boolean countMiss = false;
    boolean doNotCountAccess = false;
    boolean loadAndRestart = false;
    boolean valueLoadedOrRevived = false;
    boolean valueDefinitelyLoaded = false;
    boolean loaderWasCalled = false;
    boolean refresh = false;
    boolean successfulLoad = false;
    boolean suppressException = false;
    Thread syncThread;
    CompletedCallback<K, V, R> completedCallback;
    private EntryAction<K, V, ?> nextAction = null;
    private int semanticCallback = 0;
    private volatile boolean completed;
    private boolean bulkMode;
    private volatile RuntimeException exceptionToPropagate;
    private volatile boolean resultAvailable;
    private volatile Object result;

    public void enqueueToExecute(EntryAction v) {
        EntryAction<K, V, ?> next;
        EntryAction<K, V, ?> target = this;
        while ((next = target.nextAction) != null) {
            target = next;
        }
        target.nextAction = v;
    }

    public EntryAction(HeapCache<K, V> heapCache, InternalCache<K, V> internalCache, Semantic<K, V, R> op, K k, Entry<K, V> e, CompletedCallback<K, V, R> cb) {
        super(null);
        this.heapCache = heapCache;
        this.internalCache = internalCache;
        this.operation = op;
        this.key = k;
        this.heapEntry = e != null ? e : NON_FRESH_DUMMY;
        if (cb == null) {
            this.syncThread = Thread.currentThread();
        } else {
            this.completedCallback = cb;
        }
    }

    public EntryAction(HeapCache<K, V> heapCache, InternalCache<K, V> userCache, Semantic<K, V, R> op, K k, Entry<K, V> e) {
        this(heapCache, userCache, op, k, e, null);
    }

    public Executor getExecutor() {
        return this.executor();
    }

    protected abstract Executor executor();

    protected AdvancedCacheLoader<K, V> loader() {
        return this.heapCache.loader;
    }

    protected AsyncCacheLoader<K, V> asyncLoader() {
        return null;
    }

    protected CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    protected CacheWriter<K, V> writer() {
        return null;
    }

    protected boolean mightHaveListeners() {
        return false;
    }

    protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
        return null;
    }

    protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
        return null;
    }

    protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
        return null;
    }

    protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
        return null;
    }

    protected abstract Timing<K, V> timing();

    public void setBulkMode(boolean v) {
        this.bulkMode = v;
    }

    public boolean isBulkMode() {
        return this.bulkMode;
    }

    public K getKey() {
        return this.key;
    }

    public long getStartTime() {
        return this.getMutationStartTime();
    }

    public boolean isRefreshAhead() {
        return this.refresh;
    }

    @Override
    public long getMutationStartTime() {
        if (this.mutationStartTime > 0L) {
            return this.mutationStartTime;
        }
        this.mutationStartTime = this.ticks();
        return this.mutationStartTime;
    }

    public CacheEntry<K, V> getCurrentEntry() {
        if (this.completed) {
            throw new IllegalStateException("Entry in context only valid while processing");
        }
        return this.heapEntry.isValidOrExpiredAndNoException() ? this.heapEntry : null;
    }

    @Override
    public boolean isLoaderPresent() {
        return this.internalCache.isLoaderPresent();
    }

    @Override
    public boolean wasLoaded() {
        return this.successfulLoad;
    }

    @Override
    public boolean isDataFresh() {
        this.doNotCountAccess = true;
        return this.hasFreshData();
    }

    protected boolean hasFreshData() {
        long nrt = this.heapEntry.getNextRefreshTime();
        if (nrt >= 16L) {
            return true;
        }
        if (Entry.needsTimeCheck(nrt)) {
            return this.getMutationStartTime() < -nrt;
        }
        return false;
    }

    @Override
    public boolean isExpiryTimeReachedOrInRefreshProbation() {
        this.doNotCountAccess = true;
        long nrt = this.heapEntry.getNextRefreshTime();
        if (nrt == 6L) {
            return true;
        }
        if (nrt >= 0L && nrt < 16L) {
            return false;
        }
        return Math.abs(nrt) <= this.getMutationStartTime();
    }

    @Override
    public boolean isDataRefreshing() {
        this.doNotCountAccess = true;
        long nrt = this.heapEntry.getNextRefreshTime();
        return nrt == 6L || nrt == 5L;
    }

    @Override
    public boolean isDataFreshOrMiss() {
        if (this.hasFreshData()) {
            return true;
        }
        this.countMiss = true;
        return false;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (CacheClosedException cacheClosedException) {
        }
        catch (Throwable t) {
            this.heapCache.getLog().warn("Exception during entry processing", t);
            ++this.heapCache.internalExceptionCnt;
            throw t;
        }
    }

    public void start() {
        int callbackCount = this.semanticCallback;
        this.operation.start(this.key, this);
    }

    @Override
    public void wantData() {
        ++this.semanticCallback;
        this.wantData = true;
        if (this.heapEntry == NON_FRESH_DUMMY) {
            this.retrieveDataFromHeap();
        } else {
            if (this.completedCallback != NOOP_CALLBACK) {
                this.heapHit = true;
            }
            this.skipHeapAccessEntryPresent();
        }
    }

    public void retrieveDataFromHeap() {
        Entry<K, V> e = this.heapEntry;
        if (e == NON_FRESH_DUMMY && (e = this.heapCache.lookupEntry(this.key)) == null) {
            this.heapMiss();
            return;
        }
        this.heapHit(e);
    }

    private long ticks() {
        return this.heapCache.getClock().ticks();
    }

    public void heapMiss() {
        this.heapMiss = true;
        this.heapOrLoadedEntry = this.heapEntry;
        this.examine();
    }

    public void heapHit(Entry<K, V> e) {
        this.heapHit = true;
        this.heapEntry = e;
        this.heapOrLoadedEntry = this.heapEntry;
        this.examine();
    }

    public void skipHeapAccessEntryPresent() {
        this.heapOrLoadedEntry = this.heapEntry;
        this.examine();
    }

    public void examine() {
        int callbackCount = this.semanticCallback;
        this.mutationStartTime = 0L;
        this.operation.examine(this.key, this, this.heapOrLoadedEntry);
    }

    @Override
    public void noMutation() {
        ++this.semanticCallback;
        if (this.successfulLoad) {
            this.updateDidNotTriggerDifferentMutationStoreLoadedValue();
            return;
        }
        this.abort();
    }

    @Override
    public void wantMutation() {
        ++this.semanticCallback;
        if (!this.entryLocked) {
            if (this.lockForNoHit(3)) {
                return;
            }
            if (this.wantData) {
                this.reexamineAfterLock();
                return;
            }
        } else {
            this.heapEntry.nextProcessingStep(3);
        }
        this.checkExpiryBeforeMutation();
    }

    public void reexamineAfterLock() {
        this.countMiss = false;
        this.heapOrLoadedEntry = this.heapEntry;
        this.mutationStartTime = 0L;
        this.examine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExpiryBeforeMutation() {
        if (this.entryExpiredListeners() == null) {
            this.noExpiryListenersPresent();
            return;
        }
        long nrt = this.heapEntry.getNextRefreshTime();
        if (nrt >= 0L) {
            this.continueWithMutation();
            return;
        }
        long millis = this.getMutationStartTime();
        if (millis >= -nrt) {
            boolean justExpired = false;
            Entry<K, V> entry = this.heapEntry;
            synchronized (entry) {
                justExpired = true;
                this.heapEntry.setNextRefreshTime(this.timing().stopStartTimer(0L, this.heapEntry));
                this.heapDataValid = false;
            }
            if (justExpired) {
                this.existingEntryExpiredBeforeMutationSendExpiryEvents();
                return;
            }
        }
        this.continueWithMutation();
    }

    public void existingEntryExpiredBeforeMutationSendExpiryEvents() {
        CacheEntry<K, V> entryCopy = this.heapCache.returnCacheEntry(this.heapEntry);
        this.sendExpiryEvents(entryCopy);
        this.metrics().expiredKept();
        this.continueWithMutation();
    }

    public void noExpiryListenersPresent() {
        this.continueWithMutation();
    }

    public void continueWithMutation() {
        int callbackCount = this.semanticCallback;
        this.operation.mutate(this.key, this, this.heapOrLoadedEntry);
    }

    @Override
    public void loadAndRestart() {
        this.loadAndRestart = true;
        this.load();
    }

    @Override
    public void refresh() {
        this.refresh = true;
        this.load();
    }

    private boolean needsLoadTimes() {
        return this.heapCache.isUpdateTimeNeeded() || !this.metrics().isDisabled();
    }

    @Override
    public void load() {
        Object v;
        long nrt;
        long t0;
        ++this.semanticCallback;
        if (!this.isLoaderPresent()) {
            this.mutationAbort((RuntimeException)new CacheException("load requested but no loader defined"));
            return;
        }
        this.heapEntry.nextProcessingStep(4);
        Entry<K, V> e = this.heapEntry;
        this.valueLoadedOrRevived = true;
        long l = t0 = this.needsLoadTimes() ? (this.lastRefreshTime = (this.loadStartedTime = this.getMutationStartTime())) : 0L;
        if (e.getNextRefreshTime() == 6L && (nrt = e.getRefreshProbationNextRefreshTime()) > t0) {
            this.reviveRefreshedEntry(nrt);
            return;
        }
        this.valueDefinitelyLoaded = true;
        this.loaderWasCalled = true;
        AsyncCacheLoader<K, V> asyncLoader = this.asyncLoader();
        if (asyncLoader != null) {
            this.heapEntry.nextProcessingStep(17);
            try {
                asyncLoader.load(this.key, (AsyncCacheLoader.Context)this, (AsyncCacheLoader.Callback)this);
            }
            catch (Throwable ouch) {
                this.onLoadFailure(ouch);
                return;
            }
            this.asyncExecutionStartedWaitIfSynchronousCall();
            return;
        }
        AdvancedCacheLoader<K, V> loader = this.loader();
        try {
            v = e.isVirgin() ? loader.load(this.key, t0, null) : loader.load(this.key, t0, e);
        }
        catch (Throwable ouch) {
            this.onLoadFailureIntern(ouch);
            return;
        }
        this.onLoadSuccessIntern(v);
    }

    public void reviveRefreshedEntry(long nrt) {
        this.metrics().refreshedHit();
        Entry<K, V> e = this.heapEntry;
        this.newValueOrException = e.getValueOrException();
        this.lastRefreshTime = e.getModificationTime();
        this.expiry = nrt;
        this.expiryCalculated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockForNoHit(int ps) {
        if (this.entryLocked) {
            this.heapEntry.nextProcessingStep(ps);
            return false;
        }
        Entry<K, V> e = this.heapEntry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntryNoHitRecord(this.key);
        }
        while (true) {
            Entry<K, V> entry = e;
            synchronized (entry) {
                if (this.bulkMode && e.isProcessing()) {
                    throw new AbortWhenProcessingException();
                }
                if (this.tryEnqueueOperationInCurrentlyProcessing(e)) {
                    return true;
                }
                if (this.waitForConcurrentProcessingOrStop(ps, e)) {
                    return false;
                }
            }
            e = this.heapCache.lookupOrNewEntryNoHitRecord(this.key);
        }
    }

    private boolean tryEnqueueOperationInCurrentlyProcessing(Entry e) {
        EntryAction runningAction;
        if (e.isProcessing() && this.completedCallback != null && (runningAction = e.getEntryAction()) != null) {
            runningAction.enqueueToExecute(this);
            return true;
        }
        return false;
    }

    private boolean waitForConcurrentProcessingOrStop(int ps, Entry e) {
        e.waitForProcessing();
        if (!e.isGone()) {
            e.startProcessing(ps, this);
            this.entryLocked = true;
            this.heapDataValid = e.isDataAvailableOrProbation();
            this.heapEntry = e;
            return true;
        }
        return false;
    }

    public void onLoadSuccess(V v) {
        this.checkEntryStateOnLoadCallback();
        try {
            this.onLoadSuccessIntern(v);
        }
        catch (CacheClosedException cacheClosedException) {
        }
        catch (Throwable internal) {
            this.heapCache.logAndCountInternalException("onLoadFailure async callback", internal);
            throw internal;
        }
    }

    public void onLoadFailure(Throwable t) {
        this.checkEntryStateOnLoadCallback();
        try {
            this.onLoadFailureIntern(t);
        }
        catch (CacheClosedException cacheClosedException) {
        }
        catch (Throwable internal) {
            this.heapCache.logAndCountInternalException("onLoadFailure async callback", internal);
            throw internal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEntryStateOnLoadCallback() {
        Entry<K, V> entry = this.heapEntry;
        synchronized (entry) {
            if (!this.heapEntry.checkAndSwitchProcessingState(17, 5) || this.completed) {
                throw new IllegalStateException("async callback on wrong entry state. duplicate callback?");
            }
        }
    }

    private void onLoadSuccessIntern(V v) {
        this.newValueOrException = v;
        this.loadCompleted();
    }

    private void onLoadFailureIntern(Throwable t) {
        this.newValueOrException = new ExceptionWrapper(this.key, t, this.loadStartedTime, this.heapEntry, this.getExceptionPropagator());
        this.loadCompleted();
    }

    public void loadCompleted() {
        this.heapEntry.nextProcessingStep(5);
        this.entryLocked = true;
        if (this.needsLoadTimes()) {
            this.loadCompletedTime = this.ticks();
        }
        this.mutationCalculateExpiry();
    }

    @Override
    public void result(R r) {
        this.resultAvailable = true;
        this.result = r;
    }

    @Override
    public void resultOrWrapper(Object r) {
        this.resultAvailable = true;
        this.result = r;
    }

    @Override
    public void entryResult(ExaminationEntry<K, V> e) {
        this.resultAvailable = true;
        this.result = this.heapCache.returnEntry(e);
    }

    @Override
    public void put(V value) {
        ++this.semanticCallback;
        this.heapEntry.nextProcessingStep(3);
        this.newValueOrException = value;
        this.lastRefreshTime = !this.heapCache.isUpdateTimeNeeded() ? 0L : this.getMutationStartTime();
        this.mutationCalculateExpiry();
    }

    @Override
    public void remove() {
        ++this.semanticCallback;
        this.heapEntry.nextProcessingStep(3);
        this.remove = true;
        this.mutationMayCallWriter();
    }

    @Override
    public void expire(long expiryTime) {
        ++this.semanticCallback;
        this.heapEntry.nextProcessingStep(19);
        this.newValueOrException = this.heapEntry.getValueOrException();
        if (this.heapCache.isUpdateTimeNeeded()) {
            this.lastRefreshTime = this.heapEntry.getModificationTime();
        }
        this.expiry = this.timing().limitExpiryTime(this.getStartTime(), expiryTime);
        this.setUntilInExceptionWrapper();
        this.checkKeepOrRemove();
    }

    @Override
    public void putAndSetExpiry(V value, long expiryTime, long refreshTime) {
        ++this.semanticCallback;
        this.heapEntry.nextProcessingStep(3);
        this.newValueOrException = value;
        if (refreshTime >= 0L) {
            this.lastRefreshTime = refreshTime;
        } else if (this.heapCache.isUpdateTimeNeeded()) {
            this.lastRefreshTime = this.getMutationStartTime();
        }
        if (expiryTime != -1L) {
            this.expiry = this.timing().limitExpiryTime(this.getStartTime(), expiryTime);
            this.setUntilInExceptionWrapper();
            this.expiryCalculated();
        } else {
            this.mutationCalculateExpiry();
        }
    }

    public void mutationCalculateExpiry() {
        this.heapEntry.nextProcessingStep(8);
        if (this.heapCache.isDisabled()) {
            this.cacheDisabledExpireImmediately();
            return;
        }
        if (this.newValueOrException instanceof ExceptionWrapper) {
            try {
                this.expiry = 0L;
                ExceptionWrapper ew = (ExceptionWrapper)this.newValueOrException;
                if (this.heapEntry.isValidOrExpiredAndNoException()) {
                    this.expiry = this.timing().suppressExceptionUntil(this.heapEntry, ew);
                }
                if (this.expiry > this.loadStartedTime) {
                    this.suppressException = true;
                    this.newValueOrException = this.heapEntry.getValueOrException();
                    this.lastRefreshTime = this.heapEntry.getModificationTime();
                    this.metrics().suppressedException();
                    this.heapEntry.setSuppressedLoadExceptionInformation(ew);
                } else {
                    if (this.valueDefinitelyLoaded) {
                        this.metrics().loadException();
                    }
                    this.expiry = this.timing().cacheExceptionUntil(this.heapEntry, ew);
                }
                this.setUntilInExceptionWrapper();
            }
            catch (Throwable ex) {
                if (this.valueDefinitelyLoaded) {
                    this.resiliencePolicyException((RuntimeException)((Object)new ResiliencePolicyException(ex)));
                    return;
                }
                this.expiryCalculationException(ex);
                return;
            }
        }
        Object newValue = this.newValueOrException;
        try {
            this.expiry = this.timing().calculateNextRefreshTime(this.heapEntry, newValue, this.lastRefreshTime);
            if (this.newValueOrException == null && this.heapCache.isRejectNullValues() && this.expiry != 0L) {
                RuntimeException ouch = this.heapCache.returnNullValueDetectedException();
                if (this.valueDefinitelyLoaded) {
                    this.decideForLoaderExceptionAfterExpiryCalculation((RuntimeException)new CacheLoaderException((Throwable)ouch));
                } else {
                    this.mutationAbort(ouch);
                }
                return;
            }
            this.heapEntry.resetSuppressedLoadExceptionInformation();
        }
        catch (Throwable ex) {
            if (this.valueDefinitelyLoaded) {
                this.decideForLoaderExceptionAfterExpiryCalculation((RuntimeException)((Object)new ExpiryPolicyException(ex)));
                return;
            }
            this.expiryCalculationException(ex);
            return;
        }
        this.expiryCalculated();
    }

    private void decideForLoaderExceptionAfterExpiryCalculation(RuntimeException ouch) {
        this.newValueOrException = new ExceptionWrapper(this.key, (Throwable)ouch, this.loadStartedTime, this.heapEntry, this.getExceptionPropagator());
        this.expiry = 0L;
        this.mutationCalculateExpiry();
    }

    private void resiliencePolicyException(RuntimeException ouch) {
        this.newValueOrException = new ExceptionWrapper(this.key, (Throwable)ouch, this.loadStartedTime, this.heapEntry, this.getExceptionPropagator());
        this.expiry = 0L;
        this.expiryCalculated();
    }

    private void setUntilInExceptionWrapper() {
        if (this.newValueOrException instanceof ExceptionWrapper) {
            ExceptionWrapper ew = (ExceptionWrapper)this.newValueOrException;
            this.newValueOrException = new ExceptionWrapper(ew, Math.abs(this.expiry));
        }
    }

    public void expiryCalculationException(Throwable t) {
        this.mutationAbort((RuntimeException)((Object)new ExpiryPolicyException(t)));
    }

    public void cacheDisabledExpireImmediately() {
        this.expiry = 0L;
        this.expiryCalculated();
    }

    public void expiryCalculated() {
        this.heapEntry.nextProcessingStep(9);
        if (this.valueLoadedOrRevived) {
            if (this.loadAndRestart) {
                this.loadAndExpiryCalculatedExamineAgain();
                return;
            }
            this.checkKeepOrRemove();
            return;
        }
        if (this.expiry > 0L || this.expiry == -1L || this.expiry < 0L && -this.expiry > this.loadStartedTime) {
            if (this.heapEntry.isVirgin()) {
                this.metrics().putNewEntry();
            } else {
                this.metrics().putHit();
            }
        }
        this.mutationMayCallWriter();
    }

    public void loadAndExpiryCalculatedExamineAgain() {
        this.loadAndRestart = false;
        this.valueLoadedOrRevived = false;
        this.valueDefinitelyLoaded = false;
        this.successfulLoad = true;
        this.heapOrLoadedEntry = new ExaminationEntry<K, V>(){

            @Override
            public K getKey() {
                return EntryAction.this.heapEntry.getKey();
            }

            @Override
            public Object getValueOrException() {
                return EntryAction.this.newValueOrException;
            }

            @Override
            public long getModificationTime() {
                return EntryAction.this.lastRefreshTime;
            }

            @Override
            public long getExpiryTime() {
                return EntryAction.this.expiry;
            }
        };
        this.examine();
    }

    public void updateDidNotTriggerDifferentMutationStoreLoadedValue() {
        this.checkKeepOrRemove();
    }

    public void mutationMayCallWriter() {
        if (this.writer() == null) {
            this.skipWritingNoWriter();
            return;
        }
        this.mutationCallWriter();
    }

    public void mutationCallWriter() {
        if (this.remove) {
            try {
                this.heapEntry.nextProcessingStep(10);
                this.writer().delete(this.key);
            }
            catch (Throwable t) {
                this.onWriteFailure(t);
                return;
            }
            this.onWriteSuccess();
            return;
        }
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.skipWritingForException();
            return;
        }
        this.heapEntry.nextProcessingStep(10);
        try {
            this.writer().write(this.key, this.newValueOrException);
        }
        catch (Throwable t) {
            this.onWriteFailure(t);
            return;
        }
        this.onWriteSuccess();
    }

    public void onWriteSuccess() {
        this.heapEntry.nextProcessingStep(11);
        this.checkKeepOrRemove();
    }

    public void onWriteFailure(Throwable t) {
        this.mutationAbort((RuntimeException)new CacheWriterException(t));
    }

    public void skipWritingForException() {
        this.checkKeepOrRemove();
    }

    public void skipWritingNoWriter() {
        this.checkKeepOrRemove();
    }

    public void checkKeepOrRemove() {
        boolean expired;
        boolean hasKeepAfterExpired = this.heapCache.isKeepAfterExpired();
        boolean bl = expired = this.expiry == 0L;
        if (!expired || this.remove) {
            this.mutationMayStore();
            return;
        }
        if (hasKeepAfterExpired) {
            this.expiredImmediatelyKeepData();
            return;
        }
        this.expiredImmediatelyAndRemove();
    }

    public void expiredImmediatelyKeepData() {
        this.expiredImmediately = true;
        this.mutationMayStore();
    }

    public void expiredImmediatelyAndRemove() {
        this.remove = true;
        this.expiredImmediately = true;
        this.mutationMayStore();
    }

    public void mutationMayStore() {
        this.skipStore();
    }

    public void skipStore() {
        this.callListeners();
    }

    public void callListeners() {
        if (!this.mightHaveListeners()) {
            this.mutationReleaseLockAndStartTimer();
            return;
        }
        Cache<K, V> userCache = this.getCache();
        Object oldValueOrException = this.heapEntry.getValueOrException();
        if (this.expiredImmediately || this.remove) {
            CacheEntry<K, V> entryCopy = this.heapCache.returnCacheEntry(this.getKey(), oldValueOrException);
            if (this.expiredImmediately) {
                this.sendExpiryEventsWhenExpiredDuringOperation(entryCopy);
            } else if (this.remove && this.heapDataValid && this.entryRemovedListeners() != null) {
                for (CacheEntryRemovedListener<K, V> l : this.entryRemovedListeners()) {
                    try {
                        l.onEntryRemoved(userCache, entryCopy);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new CacheEventListenerException(t);
                    }
                }
            }
        } else {
            CacheEntry<K, V> entryCopy = this.heapCache.returnCacheEntry(this.getKey(), this.newValueOrException);
            if (this.heapDataValid) {
                if (this.entryUpdatedListeners() != null) {
                    CacheEntry<Object, V> previousEntry = this.heapCache.returnCacheEntry(this.heapEntry.getKey(), oldValueOrException);
                    for (CacheEntryUpdatedListener<K, V> l : this.entryUpdatedListeners()) {
                        try {
                            l.onEntryUpdated(userCache, previousEntry, entryCopy);
                        }
                        catch (Throwable t) {
                            this.exceptionToPropagate = new CacheEventListenerException(t);
                        }
                    }
                }
            } else if (this.entryCreatedListeners() != null) {
                for (CacheEntryCreatedListener<K, V> l : this.entryCreatedListeners()) {
                    try {
                        l.onEntryCreated(userCache, entryCopy);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new CacheEventListenerException(t);
                    }
                }
            }
        }
        this.mutationReleaseLockAndStartTimer();
    }

    public Cache<K, V> getCache() {
        return this.internalCache.getUserCache();
    }

    private void sendExpiryEventsWhenExpiredDuringOperation(CacheEntry<K, V> entryCopy) {
        if (this.heapDataValid && this.entryExpiredListeners() != null) {
            this.sendExpiryEvents(entryCopy);
        }
    }

    private void sendExpiryEvents(CacheEntry<K, V> entryCopy) {
        Cache<K, V> userCache = this.getCache();
        for (CacheEntryExpiredListener<K, V> l : this.entryExpiredListeners()) {
            try {
                l.onEntryExpired(userCache, entryCopy);
            }
            catch (Throwable t) {
                this.exceptionToPropagate = new CacheEventListenerException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationReleaseLockAndStartTimer() {
        boolean justExpired = false;
        boolean evictionHint = false;
        Entry<K, V> entry = this.heapEntry;
        synchronized (entry) {
            if (this.heapCache.isRecordRefreshTime()) {
                this.heapEntry.setRefreshTime(this.lastRefreshTime);
            }
            if (this.remove) {
                if (this.expiredImmediately) {
                    this.heapEntry.setNextRefreshTime(4L);
                    this.heapEntry.setValueOrException(this.newValueOrException);
                } else if (!this.heapEntry.isVirgin()) {
                    this.heapEntry.setNextRefreshTime(2L);
                }
            } else {
                this.heapEntry.setValueOrException(this.newValueOrException);
                evictionHint = this.heapCache.eviction.updateWeight(this.heapEntry);
            }
            if (this.refresh) {
                this.heapCache.startRefreshProbationTimer(this.heapEntry, this.expiry);
            } else if (this.remove) {
                this.heapCache.removeEntry(this.heapEntry);
            } else {
                try {
                    this.heapEntry.setNextRefreshTime(this.timing().stopStartTimer(this.expiry, this.heapEntry));
                    boolean entryExpired = this.heapEntry.isExpiredState();
                    if (!this.expiredImmediately && entryExpired) {
                        justExpired = true;
                    }
                }
                catch (RuntimeException ex) {
                    this.exceptionToPropagate = ex;
                }
            }
            if (!(!this.valueLoadedOrRevived || this.remove && this.heapEntry.getValueOrException() == null && this.heapCache.isRejectNullValues())) {
                this.operation.loaded(this.key, this, this.heapEntry);
            }
            if (!justExpired) {
                this.heapEntry.processingDone(this);
                this.entryLocked = false;
            }
        }
        if (justExpired) {
            this.expiredAtEndOfOperationStartOver();
            return;
        }
        if (evictionHint) {
            this.heapCache.eviction.evictEventually();
        }
        this.updateMutationStatistics();
        this.mutationDone();
    }

    public void expiredAtEndOfOperationStartOver() {
        this.heapDataValid = true;
        this.heapEntry.nextProcessingStep(19);
        this.expiry = 0L;
        this.checkKeepOrRemove();
    }

    private boolean isGetLike() {
        return !this.refresh && this.completedCallback != NOOP_CALLBACK && this.countMiss;
    }

    public void updateMutationStatistics() {
        if (this.expiredImmediately && !this.remove) {
            this.metrics().expiredKept();
        }
        if (this.loaderWasCalled) {
            long delta = this.loadCompletedTime - this.loadStartedTime;
            if (this.refresh) {
                this.metrics().refresh(delta);
            } else if (this.isGetLike()) {
                this.metrics().readThrough(delta);
            } else {
                this.metrics().explicitLoad(delta);
            }
            if (this.countMiss && this.heapHit) {
                this.metrics().heapHitButNoRead();
            }
            return;
        }
        this.updateReadStatisticsNoTailCall();
    }

    private void updateReadStatisticsNoTailCall() {
        if (this.countMiss) {
            if (this.heapHit) {
                this.metrics().peekHitNotFresh();
            }
            if (this.heapMiss) {
                this.metrics().peekMiss();
            }
        } else if (this.doNotCountAccess && this.heapHit) {
            this.metrics().heapHitButNoRead();
        }
    }

    @Override
    public void failure(RuntimeException t) {
        ++this.semanticCallback;
        this.mutationAbort(t);
    }

    public void examinationAbort(CustomizationException t) {
        this.exceptionToPropagate = t;
        this.abort();
    }

    public void mutationAbort(RuntimeException t) {
        this.exceptionToPropagate = t;
        this.abort();
    }

    public void mutationDone() {
        this.completeProcessCallbacks();
    }

    public void abort() {
        if (this.entryLocked) {
            this.abortReleaseLock();
            return;
        }
        this.abortFinalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortReleaseLock() {
        Entry<K, V> entry = this.heapEntry;
        synchronized (entry) {
            this.heapEntry.processingDone(this);
            if (this.heapEntry.isVirgin()) {
                this.heapCache.removeEntry(this.heapEntry);
            }
            this.entryLocked = false;
        }
        this.abortFinalize();
    }

    public void abortFinalize() {
        this.updateReadStatisticsNoTailCall();
        this.completeProcessCallbacks();
    }

    public void completeProcessCallbacks() {
        this.completed = true;
        if (this.nextAction != null) {
            this.executor().execute(this.nextAction);
        }
        if (this.completedCallback != null) {
            this.completedCallback.entryActionCompleted(this);
        }
        this.ready();
    }

    public void ready() {
    }

    public RuntimeException getExceptionToPropagate() {
        return this.exceptionToPropagate;
    }

    public Throwable getLoaderException() {
        if (this.result instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)this.result).getException();
        }
        return null;
    }

    public Throwable getException() {
        if (this.exceptionToPropagate != null) {
            return this.exceptionToPropagate;
        }
        return this.getLoaderException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncExecutionStartedWaitIfSynchronousCall() {
        if (!this.bulkMode && this.syncThread == Thread.currentThread()) {
            Entry<K, V> entry = this.heapEntry;
            synchronized (entry) {
                this.heapEntry.waitForProcessing();
            }
        }
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isResultAvailable() {
        return this.resultAvailable;
    }

    public static interface CompletedCallback<K, V, R> {
        public void entryActionCompleted(EntryAction<K, V, R> var1);
    }

    public static class AbortWhenProcessingException
    extends CacheException {
    }
}

