/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.core.api.InternalCache;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessor;

public class ConcurrentMapWrapper<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final boolean permitNull;
    private final Cache<K, V> cache;
    private final Class<?> keyType;
    private final Class<?> valueType;

    public ConcurrentMapWrapper(InternalCache<K, V> cache) {
        this.cache = cache;
        this.permitNull = cache.isNullValuePermitted();
        this.keyType = cache.getKeyType().getType();
        this.valueType = cache.getValueType().getType();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        EntryProcessor p = e -> {
            if (!e.exists()) {
                e.setValue(value);
                return null;
            }
            return e.getValue();
        };
        return (V)this.invokeDirect(key, p);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.keyType.isAssignableFrom(key.getClass()) && this.valueType.isAssignableFrom(value.getClass())) {
            return this.cache.removeIfEquals(key, value);
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replaceIfEquals(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        EntryProcessor p = e -> {
            if (e.exists()) {
                Object result = e.getValue();
                e.setValue(value);
                return result;
            }
            return null;
        };
        return (V)this.invokeDirect(key, p);
    }

    @Override
    public int size() {
        return (int)((InternalCache)this.cache).getTotalEntryCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keyType.isAssignableFrom(key.getClass())) {
            return this.cache.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            if (!this.permitNull) {
                throw new NullPointerException();
            }
            for (CacheEntry e : this.cache.entries()) {
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            for (CacheEntry e : this.cache.entries()) {
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.keyType.isAssignableFrom(key.getClass())) {
            return (V)this.cache.peek(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        EntryProcessor p = e -> {
            Object result = e.exists() ? e.getValue() : null;
            e.setValue(value);
            return result;
        };
        return (V)this.invokeDirect(key, p);
    }

    @Override
    public V remove(Object key) {
        if (!this.keyType.isAssignableFrom(key.getClass())) {
            return null;
        }
        EntryProcessor p = e -> {
            Object result = e.exists() ? e.getValue() : null;
            e.remove();
            return result;
        };
        return (V)this.cache.invoke(key, p);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = ConcurrentMapWrapper.this.cache.entries().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((CacheEntry)it.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return ConcurrentMapWrapper.this.containsKey(o);
            }

            @Override
            public int size() {
                return ConcurrentMapWrapper.this.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator it = ConcurrentMapWrapper.this.cache.entries().iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((CacheEntry)it.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ConcurrentMapWrapper.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = ConcurrentMapWrapper.this.cache.entries().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final CacheEntry e = (CacheEntry)it.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public V getValue() {
                                return e.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return ConcurrentMapWrapper.this.cache.peekAndPut(this.getKey(), value);
                            }

                            @Override
                            public int hashCode() {
                                return (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
                            }

                            public String toString() {
                                return this.getKey() + "=" + this.getValue();
                            }

                            @Override
                            public boolean equals(Object obj) {
                                if (!(obj instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry entry = (Map.Entry)obj;
                                return this.getKey().equals(entry.getKey()) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return ConcurrentMapWrapper.this.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                if (!ConcurrentMapWrapper.this.containsKey(entry.getKey())) {
                    return false;
                }
                Object val = ConcurrentMapWrapper.this.get(entry.getKey());
                if (val == entry.getValue()) {
                    return true;
                }
                if (val == null) {
                    return false;
                }
                return val.equals(entry.getValue());
            }
        };
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.invokeUnwrapException(key, entry -> {
            Object oldValue = null;
            if (!entry.exists() || (oldValue = entry.getValue()) == null) {
                entry.lock();
                Object value = mappingFunction.apply((Object)key);
                if (value != null) {
                    entry.setValue(value);
                    return value;
                }
            }
            return oldValue;
        });
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.invokeUnwrapException(key, entry -> {
            Object value = null;
            if (entry.exists()) {
                entry.lock();
                value = entry.getValue();
                if (value == null) {
                    return value;
                }
                value = remappingFunction.apply((Object)key, (Object)entry.getValue());
                if (value != null) {
                    entry.setValue(value);
                } else {
                    entry.remove();
                }
            }
            return value;
        });
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.invokeUnwrapException(key, entry -> {
            Object value = null;
            if (entry.exists()) {
                value = entry.getValue();
            }
            entry.lock();
            value = remappingFunction.apply((Object)key, (Object)value);
            if (value != null) {
                entry.setValue(value);
            } else {
                entry.remove();
            }
            return value;
        });
    }

    private <R> R invokeDirect(K key, EntryProcessor<K, V, R> p) {
        return (R)this.cache.invoke(key, p);
    }

    private <R> R invokeUnwrapException(K key, EntryProcessor<K, V, R> p) {
        try {
            return (R)this.cache.invoke(key, p);
        }
        catch (EntryProcessingException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw ex;
        }
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        CacheEntry entry = this.cache.peekEntry(key);
        return (V)(entry != null ? entry.getValue() : defaultValue);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        return (V)this.invokeUnwrapException(key, entry -> {
            Object newValue;
            Object oldValue = entry.exists() ? entry.getValue() : null;
            Object object = newValue = oldValue == null ? value : remappingFunction.apply((Object)oldValue, (Object)value);
            if (newValue == null) {
                entry.remove();
            } else {
                entry.setValue(newValue);
            }
            return newValue;
        });
    }
}

