/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Logger;

public class Loader {
    private static final Logger logger = Logger.create(Loader.class);
    private static final String PLATFORM;
    private static java.util.Properties platformProperties;
    static File cacheDir;
    static File tempDir;
    static Map<String, String> loadedLibraries;
    static boolean pathsFirst;
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatform() {
        return System.getProperty("org.bytedeco.javacpp.platform", PLATFORM);
    }

    public static java.util.Properties loadProperties() {
        String name = Loader.getPlatform();
        if (platformProperties != null && name.equals(platformProperties.getProperty("platform"))) {
            return platformProperties;
        }
        platformProperties = Loader.loadProperties(name, null);
        return platformProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static java.util.Properties loadProperties(String name, String defaults) {
        java.util.Properties p;
        block30: {
            if (defaults == null) {
                defaults = "generic";
            }
            p = new java.util.Properties();
            p.put("platform", name);
            p.put("platform.path.separator", File.pathSeparator);
            String s = System.mapLibraryName("/");
            int i = s.indexOf(47);
            p.put("platform.library.prefix", s.substring(0, i));
            p.put("platform.library.suffix", s.substring(i + 1));
            name = "properties/" + name + ".properties";
            InputStream is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e) {
                    p.load(is);
                }
            }
            catch (Exception e) {
                name = "properties/" + defaults + ".properties";
                InputStream is2 = Loader.class.getResourceAsStream(name);
                try {
                    p.load(new InputStreamReader(is2));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is2);
                }
                try {
                    if (is2 != null) {
                        is2.close();
                    }
                    break block30;
                }
                catch (IOException ex) {
                    logger.error("Unable to close resource : " + ex.getMessage());
                }
                break block30;
                catch (Exception ex) {
                    try {
                        if (is2 != null) {
                            is2.close();
                        }
                        break block30;
                    }
                    catch (IOException ex2) {
                        logger.error("Unable to close resource : " + ex2.getMessage());
                    }
                    break block30;
                    catch (Throwable throwable) {
                        try {
                            if (is2 != null) {
                                is2.close();
                            }
                        }
                        catch (IOException ex3) {
                            logger.error("Unable to close resource : " + ex3.getMessage());
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("Unable to close resource : " + ex.getMessage());
                }
            }
        }
        return p;
    }

    public static Class getEnclosingClass(Class cls) {
        Platform p;
        Class<?> c = cls;
        while (c.getDeclaringClass() != null && !c.isAnnotationPresent(Properties.class) && (!c.isAnnotationPresent(Platform.class) || (p = c.getAnnotation(Platform.class)).pragma().length <= 0 && p.define().length <= 0 && p.exclude().length <= 0 && p.include().length <= 0 && p.cinclude().length <= 0 && p.includepath().length <= 0 && p.includeresource().length <= 0 && p.compiler().length <= 0 && p.linkpath().length <= 0 && p.linkresource().length <= 0 && p.link().length <= 0 && p.frameworkpath().length <= 0 && p.framework().length <= 0 && p.preloadpath().length <= 0 && p.preload().length <= 0 && p.resourcepath().length <= 0 && p.resource().length <= 0 && p.library().length() <= 0)) {
            c = c.getDeclaringClass();
        }
        return c;
    }

    public static ClassProperties loadProperties(Class[] cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        if (cls != null) {
            for (Class c : cls) {
                cp.load(c, inherit);
            }
        }
        return cp;
    }

    public static ClassProperties loadProperties(Class cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        if (cls != null) {
            cp.load(cls, inherit);
        }
        return cp;
    }

    public static Class getCallerClass(int i) {
        Class[] classContext = null;
        try {
            classContext = new SecurityManager(){

                public Class[] getClassContext() {
                    return super.getClassContext();
                }
            }.getClassContext();
        }
        catch (NoSuchMethodError | SecurityException e) {
            logger.warn("Could not create an instance of SecurityManager: " + e.getMessage());
        }
        if (classContext != null) {
            for (int j = 0; j < classContext.length; ++j) {
                if (classContext[j] != Loader.class) continue;
                return classContext[i + j];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j = 0; j < classNames.length; ++j) {
                    if (Class.forName(classNames[j].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i + j].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("No definition for the class found : " + e.getMessage());
            }
        }
        return null;
    }

    public static File cacheResource(String name) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.cacheResource(cls, name);
    }

    public static File cacheResource(Class cls, String name) throws IOException {
        return Loader.cacheResource(cls.getResource(name));
    }

    public static File[] cacheResources(String name) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.cacheResources(cls, name);
    }

    public static File[] cacheResources(Class cls, String name) throws IOException {
        URL[] urls = Loader.findResources(cls, name);
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = Loader.cacheResource(urls[i]);
        }
        return files;
    }

    public static File cacheResource(URL resourceURL) throws IOException {
        return Loader.cacheResource(resourceURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File cacheResource(URL resourceURL, String target) throws IOException {
        long timestamp;
        long size;
        File urlFile;
        try {
            urlFile = new File(new URI(resourceURL.toString().split("#")[0]));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            urlFile = new File(resourceURL.getPath());
        }
        String name = urlFile.getName();
        boolean reference = false;
        File cacheDir = Loader.getCacheDir();
        File cacheSubdir = cacheDir.getCanonicalFile();
        String s = System.getProperty("org.bytedeco.javacpp.cachedir.nosubdir", "false").toLowerCase();
        boolean noSubdir = s.equals("true") || s.equals("t") || s.equals("");
        URLConnection urlConnection = resourceURL.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)urlConnection).getJarFile();
            JarEntry jarEntry = ((JarURLConnection)urlConnection).getJarEntry();
            File jarFileFile = new File(jarFile.getName());
            File jarEntryFile = new File(jarEntry.getName());
            size = jarEntry.getSize();
            timestamp = jarEntry.getTime();
            if (!noSubdir) {
                cacheSubdir = new File(cacheSubdir, jarFileFile.getName() + File.separator + jarEntryFile.getParent());
            }
        } else {
            size = urlFile.length();
            timestamp = urlFile.lastModified();
            if (!noSubdir) {
                cacheSubdir = new File(cacheSubdir, urlFile.getParentFile().getName());
            }
        }
        if (resourceURL.getRef() != null) {
            name = resourceURL.getRef();
            reference = true;
        }
        File file = new File(cacheSubdir, name);
        File lockFile = new File(cacheDir, ".lock");
        AbstractInterruptibleChannel lockChannel = null;
        FileLock lock = null;
        ReentrantLock threadLock = null;
        if (target != null && target.length() > 0) {
            try {
                Path path = file.toPath();
                Path targetPath = Paths.get(target, new String[0]);
                if (file.exists() && Files.isSymbolicLink(path) && Files.readSymbolicLink(path).equals(targetPath) || !targetPath.isAbsolute() || targetPath.equals(path)) return file;
                if (logger.isDebugEnabled()) {
                    logger.debug("Locking " + cacheDir + " to create symbolic link");
                }
                threadLock = new ReentrantLock();
                threadLock.lock();
                lockChannel = new FileOutputStream(lockFile).getChannel();
                lock = ((FileChannel)lockChannel).lock();
                if (file.exists() && Files.isSymbolicLink(path) && Files.readSymbolicLink(path).equals(targetPath) || !targetPath.isAbsolute() || targetPath.equals(path)) return file;
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating symbolic link " + path + " to " + targetPath);
                }
                try {
                    file.getParentFile().mkdirs();
                    Files.createSymbolicLink(path, targetPath, new FileAttribute[0]);
                    return file;
                }
                catch (FileAlreadyExistsException e) {
                    file.delete();
                    Files.createSymbolicLink(path, targetPath, new FileAttribute[0]);
                }
                return file;
            }
            catch (IOException | RuntimeException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to create symbolic link " + file + ": " + e);
                }
                File targetPath = null;
                return targetPath;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
                if (lockChannel != null) {
                    lockChannel.close();
                }
                if (threadLock != null) {
                    threadLock.unlock();
                }
            }
        }
        if (urlFile.exists() && reference) {
            try {
                Path path = file.toPath();
                Path urlPath = urlFile.toPath();
                if (!(file.exists() && Files.isSymbolicLink(path) && Files.readSymbolicLink(path).equals(urlPath) || !urlPath.isAbsolute() || urlPath.equals(path))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Locking " + cacheDir + " to create symbolic link");
                    }
                    threadLock = new ReentrantLock();
                    threadLock.lock();
                    lockChannel = new FileOutputStream(lockFile).getChannel();
                    lock = ((FileChannel)lockChannel).lock();
                    if (!(file.exists() && Files.isSymbolicLink(path) && Files.readSymbolicLink(path).equals(urlPath) || !urlPath.isAbsolute() || urlPath.equals(path))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Creating symbolic link " + path + " to " + urlPath);
                        }
                        try {
                            file.getParentFile().mkdirs();
                            Files.createSymbolicLink(path, urlPath, new FileAttribute[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            file.delete();
                            Files.createSymbolicLink(path, urlPath, new FileAttribute[0]);
                        }
                    }
                }
                File file2 = file;
                return file2;
            }
            catch (IOException | RuntimeException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not create symbolic link " + file + ": " + e);
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
                if (lockChannel != null) {
                    lockChannel.close();
                }
                if (threadLock != null) {
                    threadLock.unlock();
                }
            }
        }
        if (file.exists() && file.length() == size && file.lastModified() == timestamp && cacheSubdir.equals(file.getCanonicalFile().getParentFile())) return file;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Locking " + cacheDir + " before extracting");
            }
            threadLock = new ReentrantLock();
            threadLock.lock();
            lockChannel = new FileOutputStream(lockFile).getChannel();
            lock = ((FileChannel)lockChannel).lock();
            if (file.exists() && file.length() == size && file.lastModified() == timestamp && cacheSubdir.equals(file.getCanonicalFile().getParentFile())) return file;
            if (logger.isDebugEnabled()) {
                logger.debug("Extracting " + resourceURL);
            }
            file.delete();
            Loader.extractResource(resourceURL, file, null, null);
            file.setLastModified(timestamp);
            return file;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            if (lockChannel != null) {
                lockChannel.close();
            }
            if (threadLock != null) {
                threadLock.unlock();
            }
        }
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File[] extractResources(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResources(cls, name, directory, prefix, suffix);
    }

    public static File[] extractResources(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        URL[] urls = Loader.findResources(cls, name);
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = Loader.extractResource(urls[i], directory, prefix, suffix);
        }
        return files;
    }

    public static File extractResource(URL resourceURL, File directoryOrFile, String prefix, String suffix) throws IOException {
        URLConnection urlConnection;
        URLConnection uRLConnection = urlConnection = resourceURL != null ? resourceURL.openConnection() : null;
        if (urlConnection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)urlConnection).getJarFile();
            JarEntry jarEntry = ((JarURLConnection)urlConnection).getJarEntry();
            String jarFileName = jarFile.getName();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith("/")) {
                jarEntryName = jarEntryName + "/";
            }
            if (jarEntry.isDirectory() || jarFile.getJarEntry(jarEntryName) != null) {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(jarEntryName)) continue;
                    File file = new File(directoryOrFile, entryName.substring(jarEntryName.length()));
                    if (entry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        String s = resourceURL.toString();
                        URL u = new URL(s.substring(0, s.indexOf("!/") + 2) + entryName);
                        file = Loader.extractResource(u, file, prefix, suffix);
                    }
                    file.setLastModified(entry.getTime());
                }
                return directoryOrFile;
            }
        }
        InputStream is = urlConnection != null ? urlConnection.getInputStream() : null;
        OutputStream os = null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int length;
            if (prefix == null && suffix == null) {
                File directory;
                if (directoryOrFile == null) {
                    directoryOrFile = new File(System.getProperty("java.io.tmpdir"));
                }
                if (directoryOrFile.isDirectory()) {
                    directory = directoryOrFile;
                    try {
                        file = new File(directoryOrFile, new File(new URI(resourceURL.toString().split("#")[0])).getName());
                    }
                    catch (IllegalArgumentException | URISyntaxException ex) {
                        file = new File(directoryOrFile, new File(resourceURL.getPath()).getName());
                    }
                } else {
                    directory = directoryOrFile.getParentFile();
                    file = directoryOrFile;
                }
                if (directory != null) {
                    directory.mkdirs();
                }
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directoryOrFile);
            }
            file.delete();
            os = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        finally {
            is.close();
            if (os != null) {
                os.close();
            }
        }
        return file;
    }

    public static URL[] findResources(Class cls, String name) throws IOException {
        while (name.contains("//")) {
            name = name.replace("//", "/");
        }
        if (!name.startsWith("/")) {
            String s = cls.getName().replace('.', '/');
            int n = s.lastIndexOf(47);
            if (n >= 0) {
                name = s.substring(0, n + 1) + name;
            }
        } else {
            name = name.substring(1);
        }
        Enumeration<URL> urls = cls.getClassLoader().getResources(name);
        ArrayList<URL> array = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            array.add(urls.nextElement());
        }
        return array.toArray(new URL[array.size()]);
    }

    public static File getCacheDir() throws IOException {
        if (cacheDir == null) {
            String[] dirNames;
            for (String dirName : dirNames = new String[]{System.getProperty("org.bytedeco.javacpp.cachedir"), System.getProperty("user.home") + "/.javacpp/cache/", System.getProperty("java.io.tmpdir") + "/.javacpp-" + System.getProperty("user.name") + "/cache/"}) {
                if (dirName == null) continue;
                try {
                    File f = new File(dirName);
                    if (!f.exists() && !f.mkdirs()) continue;
                    cacheDir = f;
                    break;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (cacheDir == null) {
            throw new IOException("Could not create the cache: Set the \"org.bytedeco.javacpp.cachedir\" system property.");
        }
        return cacheDir;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            for (int i = 0; i < 1000; ++i) {
                File f = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f.mkdir()) continue;
                tempDir = f;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static boolean isLoadLibraries() {
        String s = System.getProperty("org.bytedeco.javacpp.loadlibraries", "true").toLowerCase();
        return s.equals("true") || s.equals("t") || s.equals("");
    }

    public static boolean checkPlatform(Class<?> cls, java.util.Properties properties) {
        Class enclosingClass = Loader.getEnclosingClass(cls);
        while (!cls.isAnnotationPresent(Properties.class) && !cls.isAnnotationPresent(Platform.class) && cls.getSuperclass() != null) {
            if (enclosingClass != null && cls.getSuperclass() == Object.class) {
                cls = enclosingClass;
                enclosingClass = null;
                continue;
            }
            cls = cls.getSuperclass();
        }
        Properties classProperties = cls.getAnnotation(Properties.class);
        if (classProperties != null) {
            Class[] classes = classProperties.inherit();
            String[] defaultNames = classProperties.names();
            ArrayDeque<Class> queue = new ArrayDeque<Class>(Arrays.asList(classes));
            while (queue.size() > 0 && (defaultNames == null || defaultNames.length == 0)) {
                Class c = (Class)queue.removeFirst();
                Properties p = c.getAnnotation(Properties.class);
                if (p == null) continue;
                defaultNames = p.names();
                queue.addAll(Arrays.asList(p.inherit()));
            }
            Platform[] platforms = classProperties.value();
            if (platforms != null) {
                for (Platform p : platforms) {
                    if (!Loader.checkPlatform(p, properties, defaultNames)) continue;
                    return true;
                }
            } else if (classes != null) {
                for (Class c : classes) {
                    if (!Loader.checkPlatform(c, properties)) continue;
                    return true;
                }
            }
        } else if (Loader.checkPlatform(cls.getAnnotation(Platform.class), properties, new String[0])) {
            return true;
        }
        return false;
    }

    public static boolean checkPlatform(Platform platform, java.util.Properties properties, String ... defaultNames) {
        if (platform == null) {
            return true;
        }
        if (defaultNames == null) {
            defaultNames = new String[]{};
        }
        String platform2 = properties.getProperty("platform");
        String platformExtension = properties.getProperty("platform.extension", "");
        String[][] names = new String[][]{platform.value().length > 0 ? platform.value() : defaultNames, platform.not()};
        boolean[] matches = new boolean[]{false, false};
        block0: for (int i = 0; i < names.length; ++i) {
            for (String s : names[i]) {
                if (!platform2.startsWith(s)) continue;
                matches[i] = true;
                continue block0;
            }
        }
        if (!(names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1])) {
            boolean match = platform.extension().length == 0 || Loader.isLoadLibraries() && platformExtension.length() == 0;
            for (String s : platform.extension()) {
                if (platformExtension.length() <= 0 || !platformExtension.endsWith(s)) continue;
                match = true;
                break;
            }
            return match;
        }
        return false;
    }

    public static String load() {
        return Loader.load(Loader.getCallerClass(2), Loader.loadProperties(), pathsFirst);
    }

    public static String load(boolean pathsFirst) {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls, Loader.loadProperties(), pathsFirst);
    }

    public static String load(Class cls) {
        return Loader.load(cls, Loader.loadProperties(), pathsFirst);
    }

    public static String load(Class cls, java.util.Properties properties, boolean pathsFirst) {
        if (!Loader.isLoadLibraries() || cls == null) {
            return null;
        }
        if (!Loader.checkPlatform(cls, properties)) {
            throw new UnsatisfiedLinkError("Platform \"" + properties.getProperty("platform") + "\" not supported by " + cls);
        }
        ClassProperties p = Loader.loadProperties(cls = Loader.getEnclosingClass(cls), properties, true);
        List<String> targets = p.get("target");
        if (targets.isEmpty()) {
            if (p.getInheritedClasses() != null) {
                for (Class c : p.getInheritedClasses()) {
                    targets.add(c.getName());
                }
            }
            targets.add(cls.getName());
        }
        for (String s : targets) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Loading class " + s);
                }
                Class.forName(s, true, cls.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to load class " + s + ": " + ex);
                }
                NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
                e.initCause(ex);
                throw e;
            }
        }
        String cacheDir = null;
        try {
            cacheDir = Loader.getCacheDir().getCanonicalPath();
        }
        catch (IOException s) {
            // empty catch block
        }
        ArrayList<String> preloads = new ArrayList<String>();
        ArrayList<String> preloaded = new ArrayList<String>();
        preloads.addAll(p.get("platform.preload"));
        preloads.addAll(p.get("platform.link"));
        UnsatisfiedLinkError preloadError = null;
        for (String preload : preloads) {
            try {
                URL[] urls = Loader.findLibrary(cls, p, preload, pathsFirst);
                String filename = Loader.loadLibrary(urls, preload, new String[0]);
                if (filename != null) {
                    preloaded.add(filename);
                }
                if (cacheDir == null || filename == null || !filename.startsWith(cacheDir)) continue;
                Loader.createLibraryLink(filename, p, preload, new String[0]);
            }
            catch (UnsatisfiedLinkError e) {
                preloadError = e;
            }
        }
        try {
            String library = p.getProperty("platform.library");
            URL[] urls = Loader.findLibrary(cls, p, library, pathsFirst);
            String filename = Loader.loadLibrary(urls, library, preloaded.toArray(new String[preloaded.size()]));
            if (cacheDir != null && filename != null && filename.startsWith(cacheDir)) {
                Loader.createLibraryLink(filename, p, library, new String[0]);
            }
            return filename;
        }
        catch (UnsatisfiedLinkError e) {
            if (preloadError != null && e.getCause() == null) {
                e.initCause(preloadError);
            }
            throw e;
        }
    }

    public static URL[] findLibrary(Class cls, ClassProperties properties, String libnameversion) {
        return Loader.findLibrary(cls, properties, libnameversion, pathsFirst);
    }

    public static URL[] findLibrary(Class cls, ClassProperties properties, String libnameversion, boolean pathsFirst) {
        if (libnameversion.trim().endsWith("#")) {
            return new URL[0];
        }
        String[] split = libnameversion.split("#");
        boolean reference = split.length > 1;
        String[] s = split[0].split("@");
        String[] s2 = (reference ? split[1] : split[0]).split("@");
        String libname = s[0];
        String libname2 = s2[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        String version2 = s2.length > 1 ? s2[s2.length - 1] : "";
        String platform = properties.getProperty("platform");
        String[] extensions = properties.get("platform.extension").toArray(new String[0]);
        String prefix = properties.getProperty("platform.library.prefix", "");
        String suffix = properties.getProperty("platform.library.suffix", "");
        String[] styles = new String[]{prefix + libname + suffix + version, prefix + libname + version + suffix, prefix + libname + suffix};
        String[] styles2 = new String[]{prefix + libname2 + suffix + version2, prefix + libname2 + version2 + suffix, prefix + libname2 + suffix};
        String[] suffixes = properties.get("platform.library.suffix").toArray(new String[0]);
        if (suffixes.length > 1) {
            styles = new String[3 * suffixes.length];
            styles2 = new String[3 * suffixes.length];
            for (int i = 0; i < suffixes.length; ++i) {
                styles[3 * i] = prefix + libname + suffixes[i] + version;
                styles[3 * i + 1] = prefix + libname + version + suffixes[i];
                styles[3 * i + 2] = prefix + libname + suffixes[i];
                styles2[3 * i] = prefix + libname2 + suffixes[i] + version2;
                styles2[3 * i + 1] = prefix + libname2 + version2 + suffixes[i];
                styles2[3 * i + 2] = prefix + libname2 + suffixes[i];
            }
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(properties.get("platform.preloadpath"));
        paths.addAll(properties.get("platform.linkpath"));
        String libpath = System.getProperty("java.library.path", "");
        if (libpath.length() > 0) {
            paths.addAll(Arrays.asList(libpath.split(File.pathSeparator)));
        }
        ArrayList<URL> urls = new ArrayList<URL>(styles.length * (1 + paths.size()));
        for (int i = 0; cls != null && i < styles.length; ++i) {
            for (String extension : Arrays.copyOf(extensions, extensions.length + 1)) {
                String subdir = platform + (extension == null ? "" : extension) + "/";
                URL u = cls.getResource(subdir + styles[i]);
                if (u == null) continue;
                if (reference) {
                    try {
                        u = new URL(u + "#" + styles2[i]);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (urls.contains(u)) continue;
                urls.add(u);
            }
        }
        int k = pathsFirst ? 0 : urls.size();
        for (int i = 0; paths.size() > 0 && i < styles.length; ++i) {
            for (String path : paths) {
                File file = new File(path, styles[i]);
                if (!file.exists()) continue;
                try {
                    URL u = file.toURI().toURL();
                    if (reference) {
                        u = new URL(u + "#" + styles2[i]);
                    }
                    if (urls.contains(u)) continue;
                    urls.add(k++, u);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static String loadLibrary(URL[] urls, String libnameversion, String ... preloaded) {
        if (!Loader.isLoadLibraries()) {
            return null;
        }
        String[] split = libnameversion.split("#");
        String libnameversion2 = split[0];
        if (split.length > 1) {
            libnameversion2 = split[1];
        }
        String filename = loadedLibraries.get(libnameversion2);
        UnsatisfiedLinkError loadError = null;
        try {
            for (URL url : urls) {
                File file;
                block30: {
                    URI uri = url.toURI();
                    file = null;
                    try {
                        file = new File(uri);
                    }
                    catch (Exception exc) {
                        block29: {
                            File f = Loader.cacheResource(url, filename);
                            try {
                                if (f != null) {
                                    file = f;
                                } else {
                                    try {
                                        file = new File(new URI(uri.toString().split("#")[0]));
                                    }
                                    catch (IllegalArgumentException | URISyntaxException e) {
                                        file = new File(uri.getPath());
                                    }
                                }
                            }
                            catch (Exception exc2) {
                                if (!logger.isDebugEnabled()) break block29;
                                logger.debug("Failed to access " + uri + ": " + exc2);
                            }
                        }
                        if (file == null || preloaded == null) break block30;
                        File dir = file.getParentFile();
                        for (String s : preloaded) {
                            File file2 = new File(s);
                            File dir2 = file2.getParentFile();
                            if (dir2.equals(dir)) continue;
                            File linkFile = new File(dir, file2.getName());
                            try {
                                Path linkPath = linkFile.toPath();
                                Path targetPath = file2.toPath();
                                if (linkFile.exists() && Files.isSymbolicLink(linkPath) && Files.readSymbolicLink(linkPath).equals(targetPath) || !targetPath.isAbsolute() || targetPath.equals(linkPath)) continue;
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Creating symbolic link " + linkPath + " to " + targetPath);
                                }
                                linkFile.delete();
                                Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
                            }
                            catch (IOException | RuntimeException e) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Failed to create symbolic link " + linkFile + " to " + file2 + ": " + e);
                            }
                        }
                    }
                }
                if (filename != null) {
                    return filename;
                }
                if (file == null || !file.exists()) continue;
                String filename2 = file.getAbsolutePath();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Loading " + filename2);
                    }
                    loadedLibraries.put(libnameversion2, filename2);
                    System.load(filename2);
                    return filename2;
                }
                catch (UnsatisfiedLinkError e) {
                    loadError = e;
                    loadedLibraries.remove(libnameversion2);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to load " + filename2 + ": " + e);
                }
            }
            if (filename != null) {
                return filename;
            }
            if (!libnameversion.trim().endsWith("#")) {
                String libname = libnameversion.split("#")[0].split("@")[0];
                if (logger.isDebugEnabled()) {
                    logger.debug("Loading library " + libname);
                }
                loadedLibraries.put(libnameversion2, libname);
                System.loadLibrary(libname);
                return libname;
            }
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            loadedLibraries.remove(libnameversion2);
            if (loadError != null && e.getCause() == null) {
                e.initCause(loadError);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to load for " + libnameversion + ": " + e);
            }
            throw e;
        }
        catch (IOException | URISyntaxException ex) {
            loadedLibraries.remove(libnameversion2);
            if (loadError != null && ex.getCause() == null) {
                ex.initCause(loadError);
            }
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to extract for " + libnameversion + ": " + e);
            }
            throw e;
        }
    }

    public static String createLibraryLink(String filename, ClassProperties properties, String libnameversion, String ... paths) {
        String version;
        String[] stringArray;
        File file = new File(filename);
        String parent = file.getParent();
        String name = file.getName();
        String link = null;
        if (libnameversion != null) {
            stringArray = libnameversion.split("#");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] split = stringArray;
        String[] s = (split.length > 1 ? split[1] : split[0]).split("@");
        String libname = s[0];
        String string = version = s.length > 1 ? s[s.length - 1] : "";
        if (!name.contains(libname)) {
            return filename;
        }
        for (String suffix : properties.get("platform.library.suffix")) {
            int n2;
            int n = name.lastIndexOf(suffix);
            int n3 = n2 = version.length() != 0 ? name.lastIndexOf(version) : name.indexOf(".");
            if (n <= 0 || n2 <= 0) continue;
            link = name.substring(0, n < n2 ? n : n2) + suffix;
            break;
        }
        if (link == null) {
            for (String suffix : properties.get("platform.library.suffix")) {
                if (!name.endsWith(suffix)) continue;
                link = name;
                break;
            }
        }
        if (link != null && link.length() > 0) {
            File linkFile = new File(parent, link);
            try {
                Path linkPath = linkFile.toPath();
                Path targetPath = Paths.get(name, new String[0]);
                if (!(linkFile.exists() && Files.isSymbolicLink(linkPath) && Files.readSymbolicLink(linkPath).equals(targetPath) || targetPath.isAbsolute() || targetPath.equals(linkPath.getFileName()))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Creating symbolic link " + linkPath);
                    }
                    linkFile.delete();
                    Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
                }
                filename = linkFile.toString();
                for (String parent2 : paths) {
                    if (parent2 == null) continue;
                    for (String link2 : new String[]{link, name}) {
                        File linkFile2 = new File(parent2, link2);
                        Path linkPath2 = linkFile2.toPath();
                        Path relativeTarget = Paths.get(parent2, new String[0]).relativize(Paths.get(parent, new String[0])).resolve(name);
                        if (linkFile2.exists() && Files.isSymbolicLink(linkPath2) && Files.readSymbolicLink(linkPath2).equals(relativeTarget) || relativeTarget.isAbsolute() || relativeTarget.equals(linkPath2.getFileName())) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Creating symbolic link " + linkPath2);
                        }
                        linkFile2.delete();
                        Files.createSymbolicLink(linkPath2, relativeTarget, new FileAttribute[0]);
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to create symbolic link " + linkFile + ": " + e);
                }
                return null;
            }
        }
        return filename;
    }

    static Class putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        try {
            Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
            if (member != null) {
                Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            logger.warn("Loader.putMemberOffset(): " + e);
            return null;
        }
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        while (offsets == null && type.getSuperclass() != null) {
            type = type.getSuperclass().asSubclass(Pointer.class);
            offsets = memberOffsets.get(type);
        }
        return offsets.get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return Loader.offsetof(type, "sizeof");
    }

    @Name(value={"JavaCPP_totalProcessors"})
    public static native int totalProcessors();

    @Name(value={"JavaCPP_totalCores"})
    public static native int totalCores();

    @Name(value={"JavaCPP_totalChips"})
    public static native int totalChips();

    @Name(value={"JavaCPP_addressof"})
    public static native Pointer addressof(String var0);

    static {
        platformProperties = null;
        String jvmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        String abiType = System.getProperty("sun.arch.abi", "").toLowerCase();
        String libPath = System.getProperty("sun.boot.library.path", "").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (jvmName.startsWith("robovm") && osName.startsWith("darwin")) {
            osName = "ios";
            osArch = "arm";
        } else if (osName.startsWith("mac os x") || osName.startsWith("darwin")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("aarch64") || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
            osArch = "arm64";
        } else if (osArch.startsWith("arm") && (abiType.equals("gnueabihf") || libPath.contains("openjdk-armhf"))) {
            osArch = "armhf";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        PLATFORM = osName + "-" + osArch;
        cacheDir = null;
        tempDir = null;
        loadedLibraries = Collections.synchronizedMap(new HashMap());
        pathsFirst = false;
        String s = System.getProperty("org.bytedeco.javacpp.pathsfirst", "false").toLowerCase();
        pathsFirst = s.equals("true") || s.equals("t") || s.equals("");
        memberOffsets = new WeakHashMap();
    }
}

