/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.Response;

public class HttpUtil {
    private static final Log LOG = LogFactory.getLog(HttpUtil.class);
    private static Proxy proxyObj = null;
    private static int timeoutValue = 0;
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    public static Response doHttpRequest(String urlStr, String requestMethod, String body, Map<String, String> header) throws SocialAuthException {
        HttpURLConnection conn;
        try {
            URL url = new URL(urlStr);
            conn = proxyObj != null ? (HttpURLConnection)url.openConnection(proxyObj) : (HttpURLConnection)url.openConnection();
            if (MethodType.POST.toString().equalsIgnoreCase(requestMethod) || MethodType.PUT.toString().equalsIgnoreCase(requestMethod)) {
                conn.setDoOutput(true);
            }
            conn.setDoInput(true);
            conn.setInstanceFollowRedirects(true);
            if (timeoutValue > 0) {
                LOG.debug((Object)("Setting connection timeout : " + timeoutValue));
                conn.setConnectTimeout(timeoutValue);
            }
            if (requestMethod != null) {
                conn.setRequestMethod(requestMethod);
            }
            if (header != null) {
                for (String key : header.keySet()) {
                    conn.setRequestProperty(key, header.get(key));
                }
            }
            OutputStream os = null;
            if (body != null && requestMethod != null && !MethodType.GET.toString().equals(requestMethod) && !MethodType.DELETE.toString().equals(requestMethod)) {
                os = conn.getOutputStream();
                DataOutputStream out = new DataOutputStream(os);
                out.write(body.getBytes("UTF-8"));
                out.flush();
            }
            conn.connect();
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        return new Response(conn);
    }

    public static Response doHttpRequest(String urlStr, String requestMethod, Map<String, String> params, Map<String, String> header, InputStream inputStream, String fileName, String fileParamName) throws SocialAuthException {
        HttpURLConnection conn;
        try {
            URL url = new URL(urlStr);
            conn = proxyObj != null ? (HttpURLConnection)url.openConnection(proxyObj) : (HttpURLConnection)url.openConnection();
            if (requestMethod.equalsIgnoreCase(MethodType.POST.toString()) || requestMethod.equalsIgnoreCase(MethodType.PUT.toString())) {
                conn.setDoOutput(true);
            }
            conn.setDoInput(true);
            conn.setInstanceFollowRedirects(true);
            if (timeoutValue > 0) {
                LOG.debug((Object)("Setting connection timeout : " + timeoutValue));
                conn.setConnectTimeout(timeoutValue);
            }
            if (requestMethod != null) {
                conn.setRequestMethod(requestMethod);
            }
            if (header != null) {
                for (String key : header.keySet()) {
                    conn.setRequestProperty(key, header.get(key));
                }
            }
            OutputStream os = null;
            if (inputStream != null && requestMethod != null && !MethodType.GET.toString().equals(requestMethod) && !MethodType.DELETE.toString().equals(requestMethod)) {
                int b;
                LOG.debug((Object)(requestMethod + " request"));
                String boundary = "----Socialauth-posting" + System.currentTimeMillis();
                conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                boundary = "--" + boundary;
                os = conn.getOutputStream();
                DataOutputStream out = new DataOutputStream(os);
                HttpUtil.write(out, boundary + "\r\n");
                if (fileParamName != null) {
                    HttpUtil.write(out, "Content-Disposition: form-data; name=\"" + fileParamName + "\"; filename=\"" + fileName + "\"\r\n");
                } else {
                    HttpUtil.write(out, "Content-Disposition: form-data;  filename=\"" + fileName + "\"\r\n");
                }
                HttpUtil.write(out, "Content-Type: multipart/form-data\r\n\r\n");
                while ((b = inputStream.read()) != -1) {
                    out.write(b);
                }
                HttpUtil.write(out, "\r\n");
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    HttpUtil.write(out, boundary + "\r\n");
                    HttpUtil.write(out, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
                    LOG.debug((Object)entry.getValue());
                    out.write(entry.getValue().getBytes("UTF-8"));
                    HttpUtil.write(out, "\r\n");
                }
                HttpUtil.write(out, boundary + "--\r\n");
                HttpUtil.write(out, "\r\n");
            }
            conn.connect();
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        return new Response(conn);
    }

    public static String buildParams(Map<String, String> params) throws Exception {
        ArrayList<String> argList = new ArrayList<String>();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null || val.length() <= 0) continue;
            String arg = key + "=" + HttpUtil.encodeURIComponent(val);
            argList.add(arg);
        }
        Collections.sort(argList);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < argList.size(); ++i) {
            s.append((String)argList.get(i));
            if (i == argList.size() - 1) continue;
            s.append("&");
        }
        return s.toString();
    }

    public static String encodeURIComponent(String value) throws Exception {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new SocialAuthException(wow.getMessage(), wow);
        }
    }

    private static String getHex(byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        for (int i = 0; i < buf.length; ++i) {
            int n = buf[i] & 0xFF;
            o.append("%");
            if (n < 16) {
                o.append("0");
            }
            o.append(Long.toString(n, 16).toUpperCase());
        }
        return o.toString();
    }

    public static String decodeURIComponent(String encodedURI) {
        StringBuffer buffer = new StringBuffer();
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < encodedURI.length(); ++i) {
            int bytePattern;
            char actualChar = encodedURI.charAt(i);
            switch (actualChar) {
                case '%': {
                    actualChar = encodedURI.charAt(++i);
                    int hb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    actualChar = encodedURI.charAt(++i);
                    int lb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    bytePattern = hb << 4 | lb;
                    break;
                }
                case '+': {
                    bytePattern = 32;
                    break;
                }
                default: {
                    bytePattern = actualChar;
                }
            }
            if ((bytePattern & 0xC0) == 128) {
                sumb = sumb << 6 | bytePattern & 0x3F;
                if (--more != 0) continue;
                buffer.append((char)sumb);
                continue;
            }
            if ((bytePattern & 0x80) == 0) {
                buffer.append((char)bytePattern);
                continue;
            }
            if ((bytePattern & 0xE0) == 192) {
                sumb = bytePattern & 0x1F;
                more = 1;
                continue;
            }
            if ((bytePattern & 0xF0) == 224) {
                sumb = bytePattern & 0xF;
                more = 2;
                continue;
            }
            if ((bytePattern & 0xF8) == 240) {
                sumb = bytePattern & 7;
                more = 3;
                continue;
            }
            if ((bytePattern & 0xFC) == 248) {
                sumb = bytePattern & 3;
                more = 4;
                continue;
            }
            sumb = bytePattern & 1;
            more = 5;
        }
        return buffer.toString();
    }

    public static void setProxyConfig(String host, int port) {
        if (host != null) {
            int proxyPort = port;
            if (proxyPort < 0) {
                proxyPort = 0;
            }
            LOG.debug((Object)("Setting proxy - Host : " + host + "   port : " + port));
            proxyObj = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
    }

    public static void setConnectionTimeout(int timeout) {
        timeoutValue = timeout;
    }

    public static void write(DataOutputStream out, String outStr) throws IOException {
        out.writeBytes(outStr);
        LOG.debug((Object)outStr);
    }
}

