/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONObject;

public class SalesForceImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 6929330230703360670L;
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(SalesForceImpl.class);
    private OAuthConfig config;
    private Permission scope;
    private AccessGrant accessGrant;
    private Profile userProfile;
    private String profileURL;
    private OAuthStrategyBase authenticationStrategy;
    private static final String AllPerms;
    private static final String AuthPerms;

    public SalesForceImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        if (!successUrl.startsWith("https")) {
            throw new SocialAuthException("To implement SalesForce provider your web application should run on a secure port. Please use an https URL instead of http.");
        }
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error") != null && "access_denied".equals(requestParams.get("error"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return this.getProfile();
        }
        throw new SocialAuthException("Access token not found");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for SalesForce");
        throw new SocialAuthException("Retrieving contacts is not implemented for SalesForce");
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for SalesForce");
        throw new SocialAuthException("Update Status is not implemented for SalesForce");
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    private Profile getProfile() throws Exception {
        String result;
        Response serviceResponse;
        if (this.accessGrant.getAttribute("id") != null) {
            this.profileURL = (String)this.accessGrant.getAttribute("id");
        }
        this.LOG.debug((Object)("Profile URL : " + this.profileURL));
        Profile p = new Profile();
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "OAuth " + this.accessGrant.getKey());
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(this.profileURL, MethodType.GET.toString(), null, headerParam, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + this.profileURL, e);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to read response from  " + this.profileURL, e);
        }
        try {
            JSONObject resp = new JSONObject(result);
            p.setValidatedId(resp.optString("user_id", null));
            p.setFirstName(resp.optString("first_name", null));
            p.setLastName(resp.optString("last_name", null));
            p.setDisplayName(resp.optString("display_name", null));
            p.setEmail(resp.optString("email", null));
            String locale = resp.optString("locale", null);
            if (locale != null) {
                String[] a = locale.split("_");
                p.setLanguage(a[0]);
                p.setCountry(a[1]);
            }
            if (resp.has("photos")) {
                JSONObject photosResp = resp.getJSONObject("photos");
                if (p.getProfileImageURL() == null || p.getProfileImageURL().length() <= 0) {
                    p.setProfileImageURL(photosResp.optString("thumbnail", null));
                }
            }
            serviceResponse.close();
            p.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(result);
            }
            this.userProfile = p;
            return p;
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for SalesForce");
        throw new SocialAuthException("Upload Image is not implemented for SalesForce");
    }

    private String getScope() {
        String scopeStr = null;
        scopeStr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) ? this.config.getCustomPermissions() : AllPerms);
        return scopeStr;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        AllPerms = new String("full");
        AuthPerms = new String("api");
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://login.salesforce.com/services/oauth2/authorize");
        ENDPOINTS.put("accessTokenURL", "https://login.salesforce.com/services/oauth2/token");
    }
}

