/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONObject;

public class GitHubImpl
extends AbstractProvider {
    private static final long serialVersionUID = -3529658778980357392L;
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(this.getClass());
    private Permission scope;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    public GitHubImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        if (this.config.getCustomProperties() != null) {
            Map<String, String> properties = this.config.getCustomProperties();
            if (properties.get("apiURL") != null) {
                ENDPOINTS.put("apiURL", this.config.getCustomProperties().get("apiURL"));
            } else {
                properties.put("apiURL", ENDPOINTS.get("apiURL"));
                this.config.setCustomProperties(properties);
            }
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error_reason") != null && "user_denied".equals(requestParams.get("error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return this.getProfile();
        }
        throw new SocialAuthException("Access token not found");
    }

    private Profile getProfile() throws Exception {
        String presp;
        try {
            Response response = this.authenticationStrategy.executeFeed(ENDPOINTS.get("apiURL") + "/user");
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from " + ENDPOINTS.get("apiURL") + "/user", e);
        }
        try {
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            p.setValidatedId(resp.optString("id", null));
            p.setFullName(resp.optString("name", null));
            p.setEmail(resp.optString("email", null));
            p.setLocation(resp.optString("location", null));
            p.setProfileImageURL(resp.optString("avatar_url", null));
            p.setDisplayName(resp.optString("login", null));
            p.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(presp);
            }
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GitHub");
        throw new SocialAuthException("Update Status is not implemented for GitHub");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GitHub");
        throw new SocialAuthException("Get contact list is not implemented for GitHub");
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException, SocialAuthException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GitHub");
        throw new SocialAuthException("Upload Image is not implemented for GitHub");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            result.append(",").append(arr[i]);
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            result.append(",").append(pluginScopes);
        }
        return result.toString();
    }

    static {
        AllPerms = new String[]{"user", "user:email"};
        AuthPerms = new String[]{"user", "user:email"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://github.com/login/oauth/authorize");
        ENDPOINTS.put("accessTokenURL", "https://github.com/login/oauth/access_token");
        ENDPOINTS.put("apiURL", "https://api.github.com");
    }
}

