/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.facebook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Album;
import org.brickred.socialauth.Photo;
import org.brickred.socialauth.plugin.AlbumsPlugin;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlbumsPluginImpl
implements AlbumsPlugin,
Serializable {
    private static final long serialVersionUID = 5350785649768508189L;
    private static final String ALBUMS_URL = "https://graph.facebook.com/v2.10/me/albums";
    private static final String ALBUM_PHOTOS_URL = "https://graph.facebook.com/v2.10/%1$s/photos?fields=names,link,picture,images";
    private static final String ALBUM_COVER_URL = "https://graph.facebook.com/v2.10/%1$s/picture?access_token=%2$s";
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;

    public AlbumsPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Album> getAlbums() throws Exception {
        Response response = this.providerSupport.api(ALBUMS_URL, MethodType.GET.toString(), null, null, null);
        String respStr = response.getResponseBodyAsString("UTF-8");
        this.LOG.debug((Object)("Albums JSON :: " + respStr));
        ArrayList<Album> albums = new ArrayList<Album>();
        JSONObject resp = new JSONObject(respStr);
        JSONArray data = resp.getJSONArray("data");
        this.LOG.debug((Object)("Albums count : " + data.length()));
        for (int i = 0; i < data.length(); ++i) {
            Album album = new Album();
            JSONObject obj = data.getJSONObject(i);
            String albumId = obj.optString("id", null);
            album.setId(albumId);
            album.setName(obj.optString("name", null));
            album.setLink(obj.optString("link", null));
            album.setCoverPhoto(obj.optString("cover_photo", null));
            album.setPhotosCount(obj.optInt("count"));
            if (albumId != null) {
                album.setCoverPhoto(String.format(ALBUM_COVER_URL, albumId, this.providerSupport.getAccessGrant().getKey()));
            }
            List<Photo> photos = this.getAlbumPhotos(albumId);
            album.setPhotos(photos);
            albums.add(album);
        }
        return albums;
    }

    private List<Photo> getAlbumPhotos(String id) throws Exception {
        Response response = this.providerSupport.api(String.format(ALBUM_PHOTOS_URL, id), MethodType.GET.toString(), null, null, null);
        String respStr = response.getResponseBodyAsString("UTF-8");
        this.LOG.info((Object)("Getting Photos of Album :: " + id));
        JSONObject resp = new JSONObject(respStr);
        JSONArray data = resp.getJSONArray("data");
        this.LOG.debug((Object)("Photos count : " + data.length()));
        ArrayList<Photo> photos = new ArrayList<Photo>();
        for (int i = 0; i < data.length(); ++i) {
            Photo photo = new Photo();
            JSONObject obj = data.getJSONObject(i);
            photo.setId(obj.optString("id", null));
            photo.setTitle(obj.optString("name", null));
            photo.setLink(obj.optString("link", null));
            photo.setThumbImage(obj.optString("picture", null));
            JSONArray images = obj.getJSONArray("images");
            for (int k = 0; k < images.length(); ++k) {
                JSONObject img = images.getJSONObject(k);
                int ht = 0;
                int wt = 0;
                if (img.has("height")) {
                    ht = img.optInt("height");
                }
                if (img.has("width")) {
                    wt = img.optInt("width");
                }
                if (ht == 600 || wt == 600) {
                    photo.setLargeImage(img.optString("source"));
                    continue;
                }
                if (ht == 480 || wt == 480) {
                    photo.setMediumImage(img.optString("source"));
                    continue;
                }
                if (ht != 320 && wt != 320) continue;
                photo.setSmallImage(img.optString("source"));
            }
            photos.add(photo);
        }
        return photos;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

