/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinkedInOAuth2Impl
extends AbstractProvider {
    private static final long serialVersionUID = 3389564715902769183L;
    private static final String CONNECTION_URL = "https://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url,picture-url)?oauth2_access_token=";
    private static final String UPDATE_STATUS_URL = "https://api.linkedin.com/v1/people/~/shares?oauth2_access_token=";
    private static final String PROFILE_URL = "https://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name),phone-numbers,main-address)?oauth2_access_token=";
    private static final String STATUS_BODY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><share><comment>%1$s</comment><visibility><code>anyone</code></visibility></share>";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(LinkedInOAuth2Impl.class);
    private Permission scope;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;
    private String state;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    public LinkedInOAuth2Impl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        this.state = "SocialAuth" + System.currentTimeMillis();
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessToken = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", this.state);
        return this.authenticationStrategy.getLoginRedirectURL(successUrl, map);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        String stateStr;
        if (requestParams.containsKey("state") && !this.state.equals(stateStr = requestParams.get("state"))) {
            throw new SocialAuthException("State parameter value does not match with expected value");
        }
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        return this.getProfile();
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        this.LOG.info((Object)"Fetching contacts from https://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url,picture-url)?oauth2_access_token=");
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(CONNECTION_URL + this.authenticationStrategy.getAccessGrant().getKey());
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from https://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url,picture-url)?oauth2_access_token=", ie);
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts from response.https://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url,picture-url)?oauth2_access_token=", e);
        }
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        if (root != null) {
            NodeList pList = root.getElementsByTagName("person");
            if (pList != null && pList.getLength() > 0) {
                this.LOG.debug((Object)("Found contacts : " + pList.getLength()));
                for (int i = 0; i < pList.getLength(); ++i) {
                    Element p = (Element)pList.item(i);
                    String fname = XMLParseUtil.getElementData(p, "first-name");
                    String lname = XMLParseUtil.getElementData(p, "last-name");
                    String id = XMLParseUtil.getElementData(p, "id");
                    String profileUrl = XMLParseUtil.getElementData(p, "public-profile-url");
                    String pictureUrl = XMLParseUtil.getElementData(p, "picture-url");
                    if (id == null) continue;
                    Contact cont = new Contact();
                    if (fname != null) {
                        cont.setFirstName(fname);
                    }
                    if (lname != null) {
                        cont.setLastName(lname);
                    }
                    if (profileUrl != null) {
                        cont.setProfileUrl(profileUrl);
                    }
                    if (pictureUrl != null) {
                        cont.setProfileImageURL(pictureUrl);
                    }
                    cont.setId(id);
                    if (this.config.isSaveRawResponse()) {
                        cont.setRawResponse(XMLParseUtil.getStringFromElement(p));
                    }
                    contactList.add(cont);
                }
            } else {
                this.LOG.debug((Object)"No connections were obtained from : https://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url,picture-url)?oauth2_access_token=");
            }
        }
        return contactList;
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        String message = msg;
        if (msg.length() > 700) {
            this.LOG.warn((Object)"Message length can not be greater than 700 characters. So truncating it to 700 chars");
            message = msg.substring(0, 700);
        }
        message = message.replace("&", "&amp;");
        this.LOG.info((Object)("Updating status " + message + " on " + UPDATE_STATUS_URL));
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Content-Type", "text/xml;charset=UTF-8");
        String msgBody = String.format(STATUS_BODY, message);
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(UPDATE_STATUS_URL + this.authenticationStrategy.getAccessGrant().getKey(), MethodType.POST.toString(), null, headerParams, msgBody);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to update status on https://api.linkedin.com/v1/people/~/shares?oauth2_access_token=", ie);
        }
        this.LOG.debug((Object)("Status Updated and return status code is : " + serviceResponse.getStatus()));
        return serviceResponse;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    private Profile getProfile() throws Exception {
        Element root;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(PROFILE_URL + this.authenticationStrategy.getAccessGrant().getKey());
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  https://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name),phone-numbers,main-address)?oauth2_access_token=", e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  https://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name),phone-numbers,main-address)?oauth2_access_token=. Staus :" + serviceResponse.getStatus());
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the profile from response.https://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name),phone-numbers,main-address)?oauth2_access_token=", e);
        }
        if (root != null) {
            String mainAddress;
            Element locationEl;
            String loc;
            NodeList location;
            String email;
            Element dobel;
            String fname = XMLParseUtil.getElementData(root, "first-name");
            String lname = XMLParseUtil.getElementData(root, "last-name");
            NodeList dob = root.getElementsByTagName("date-of-birth");
            if (dob != null && dob.getLength() > 0 && (dobel = (Element)dob.item(0)) != null) {
                String y = XMLParseUtil.getElementData(dobel, "year");
                String m = XMLParseUtil.getElementData(dobel, "month");
                String d = XMLParseUtil.getElementData(dobel, "day");
                BirthDate bd = new BirthDate();
                if (m != null) {
                    bd.setMonth(Integer.parseInt(m));
                }
                if (d != null) {
                    bd.setDay(Integer.parseInt(d));
                }
                if (y != null) {
                    bd.setYear(Integer.parseInt(y));
                }
                profile.setDob(bd);
            }
            String picUrl = XMLParseUtil.getElementData(root, "picture-url");
            String id = XMLParseUtil.getElementData(root, "id");
            if (picUrl != null) {
                profile.setProfileImageURL(picUrl);
            }
            if ((email = XMLParseUtil.getElementData(root, "email-address")) != null) {
                profile.setEmail(email);
            }
            if ((location = root.getElementsByTagName("location")) != null && location.getLength() > 0 && (loc = XMLParseUtil.getElementData(locationEl = (Element)location.item(0), "name")) != null) {
                profile.setLocation(loc);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            NodeList phoneNodes = root.getElementsByTagName("phone-number");
            if (phoneNodes != null && phoneNodes.getLength() > 0) {
                Element phoneEl = (Element)phoneNodes.item(0);
                String type = XMLParseUtil.getElementData(phoneEl, "phone-type");
                String phone = XMLParseUtil.getElementData(phoneEl, "phone-number");
                if (type != null && type.length() > 0 && phone != null) {
                    map.put(type, phone);
                }
            }
            if ((mainAddress = XMLParseUtil.getElementData(root, "main-address")) != null) {
                map.put("mainAddress", mainAddress);
            }
            if (map != null && !map.isEmpty()) {
                profile.setContactInfo(map);
            }
            profile.setFirstName(fname);
            profile.setLastName(lname);
            profile.setValidatedId(id);
            profile.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                profile.setRawResponse(XMLParseUtil.getStringFromElement(root));
            }
            this.LOG.debug((Object)("User Profile :" + profile.toString()));
            this.userProfile = profile;
        }
        return profile;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.debug((Object)("Calling URL : " + url));
        return this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for LinkedIn");
        throw new SocialAuthException("Update Image is not implemented for LinkedIn");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.linkedin.oauth2.FeedPluginImpl");
        list.add("org.brickred.socialauth.plugin.linkedin.oauth2.CareerPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            result.append(" ").append(arr[i]);
        }
        List<String> scopes = this.config.getPluginsScopes();
        if (scopes != null && !scopes.isEmpty()) {
            String scopesStr = scopes.get(0);
            for (int i = 1; i < scopes.size(); ++i) {
                scopesStr = scopesStr + " " + scopes.get(i);
            }
            result.append(" ").append(scopesStr);
        }
        return result.toString();
    }

    static {
        AllPerms = new String[]{"r_fullprofile", "r_emailaddress", "r_network", "r_contactinfo", "rw_nus"};
        AuthPerms = new String[]{"r_fullprofile", "r_emailaddress"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://www.linkedin.com/uas/oauth2/authorization");
        ENDPOINTS.put("accessTokenURL", "https://www.linkedin.com/uas/oauth2/accessToken");
    }
}

