/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FacebookImpl
extends AbstractProvider {
    private static final long serialVersionUID = 8644510564735754296L;
    private static final String PROFILE_FIELDS = "?fields=id,name,picture,age_range,birthday,email,first_name,last_name,gender,location,locale";
    private static final String PROFILE_URL = "https://graph.facebook.com/me?fields=id,name,picture,age_range,birthday,email,first_name,last_name,gender,location,locale";
    private static final String CONTACTS_URL = "https://graph.facebook.com/me/friends";
    private static final String UPDATE_STATUS_URL = "https://graph.facebook.com/me/feed";
    private static final String PROFILE_IMAGE_URL = "http://graph.facebook.com/%1$s/picture";
    private static final String PUBLIC_PROFILE_URL = "http://www.facebook.com/profile.php?id=";
    private static final String IMAGE_UPLOAD_URL = "https://graph.facebook.com/me/photos";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(FacebookImpl.class);
    private Permission scope;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    public FacebookImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException, SocialAuthException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
        this.LOG.debug((Object)"Checking for token expiry");
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(PROFILE_URL);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to check token expire");
            this.LOG.error((Object)e.getMessage());
        }
        this.checkTokenExpiry(response);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error_reason") != null && "user_denied".equals(requestParams.get("error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams);
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return this.authFacebookLogin();
        }
        throw new SocialAuthException("Access token not found");
    }

    private Profile authFacebookLogin() throws Exception {
        String presp;
        try {
            Response response = this.authenticationStrategy.executeFeed(PROFILE_URL);
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from https://graph.facebook.com/me?fields=id,name,picture,age_range,birthday,email,first_name,last_name,gender,location,locale", e);
        }
        try {
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            p.setValidatedId(resp.optString("id", null));
            p.setFullName(resp.optString("name", null));
            p.setFirstName(resp.optString("first_name", null));
            p.setLastName(resp.optString("last_name", null));
            p.setEmail(resp.optString("email", null));
            if (resp.has("location")) {
                p.setLocation(resp.getJSONObject("location").optString("name", null));
            }
            if (resp.has("birthday")) {
                String bstr = resp.optString("birthday");
                String[] arr = bstr.split("/");
                BirthDate bd = new BirthDate();
                if (arr.length > 0) {
                    bd.setMonth(Integer.parseInt(arr[0]));
                }
                if (arr.length > 1) {
                    bd.setDay(Integer.parseInt(arr[1]));
                }
                if (arr.length > 2) {
                    bd.setYear(Integer.parseInt(arr[2]));
                }
                p.setDob(bd);
            }
            p.setGender(resp.optString("gender", null));
            p.setProfileImageURL(String.format(PROFILE_IMAGE_URL, resp.getString("id")));
            String locale = resp.optString("locale", null);
            if (locale != null) {
                String[] a = locale.split("_");
                p.setLanguage(a[0]);
                p.setCountry(a[1]);
            }
            p.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(presp);
            }
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        Response serviceResponse;
        this.LOG.info((Object)("Updating status : " + msg));
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        StringBuilder strb = new StringBuilder();
        strb.append("message=").append(URLEncoder.encode(msg, "UTF-8"));
        strb.append("&access_token").append("=").append(this.accessGrant.getKey());
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(UPDATE_STATUS_URL, MethodType.POST.toString(), null, null, strb.toString());
            if (serviceResponse.getStatus() != 200) {
                throw new SocialAuthException("Status not updated. Return Status code :" + serviceResponse.getStatus());
            }
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        return serviceResponse;
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        ArrayList<Contact> plist = new ArrayList<Contact>();
        this.LOG.info((Object)"Fetching contacts from https://graph.facebook.com/me/friends");
        try {
            Response response = this.authenticationStrategy.executeFeed(CONTACTS_URL);
            respStr = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from https://graph.facebook.com/me/friends", e);
        }
        try {
            this.LOG.debug((Object)("User Contacts list in json : " + respStr));
            JSONObject resp = new JSONObject(respStr);
            JSONArray data = resp.getJSONArray("data");
            this.LOG.debug((Object)("Found contacts : " + data.length()));
            for (int i = 0; i < data.length(); ++i) {
                JSONObject obj = data.getJSONObject(i);
                Contact p = new Contact();
                String name = obj.optString("name", null);
                if (name != null) {
                    String[] nameArr = name.split(" ");
                    if (nameArr.length > 1) {
                        p.setFirstName(nameArr[0]);
                        p.setLastName(nameArr[1]);
                    } else {
                        p.setFirstName(obj.optString("name"));
                    }
                    p.setDisplayName(name);
                }
                String id = obj.optString("id", null);
                p.setId(id);
                if (id != null) {
                    p.setProfileUrl(PUBLIC_PROFILE_URL + id);
                    p.setProfileImageURL(String.format(PROFILE_IMAGE_URL, id));
                }
                if (this.config.isSaveRawResponse()) {
                    p.setRawResponse(obj.toString());
                }
                plist.add(p);
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + respStr, e);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.authFacebookLogin();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.info((Object)("Uploading Image :: " + fileName + ", status message :: " + message));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", message);
        Response response = this.authenticationStrategy.uploadImage(IMAGE_UPLOAD_URL, MethodType.POST.toString(), map, null, fileName, inputStream, null);
        this.LOG.info((Object)("Upload Image status::" + response.getStatus()));
        return response;
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            result.append(",").append(arr[i]);
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            result.append(",").append(pluginScopes);
        }
        return result.toString();
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.facebook.AlbumsPluginImpl");
        list.add("org.brickred.socialauth.plugin.facebook.FeedPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    private void checkTokenExpiry(Response response) throws AccessTokenExpireException, SocialAuthException {
        block7: {
            if (response.getStatus() == 400) {
                try {
                    String respStr = response.getErrorStreamAsString("UTF-8");
                    JSONObject resp = new JSONObject(respStr);
                    if (resp.has("error")) {
                        JSONObject error = resp.getJSONObject("error");
                        String message = error.getString("message");
                        this.LOG.debug((Object)("Error message :: " + message));
                        if (message != null) {
                            message = message.toLowerCase();
                        }
                        if (message.contains("session has expired")) {
                            throw new AccessTokenExpireException();
                        }
                        throw new SocialAuthException("Message :: " + message);
                    }
                    throw new SocialAuthException("Message :: " + respStr);
                }
                catch (Exception e) {
                    if (AccessTokenExpireException.class.isInstance(e)) {
                        new AccessTokenExpireException();
                    }
                    if (!SocialAuthException.class.isInstance(e)) break block7;
                    throw new SocialAuthException(e.getMessage());
                }
            }
        }
    }

    @Override
    public void refreshToken(AccessGrant expireAccessGrant) throws SocialAuthException {
        this.LOG.debug((Object)"Getting refrash token");
        String url = ENDPOINTS.get("accessTokenURL") + "?grant_type=fb_exchange_token&client_id=%1$s&client_secret=%2$s&fb_exchange_token=%3$s";
        url = String.format(url, this.config.get_consumerKey(), this.config.get_consumerSecret(), expireAccessGrant.getKey());
        this.LOG.debug((Object)("URL for Refresh Token :: " + url));
        Response response = HttpUtil.doHttpRequest(url, MethodType.GET.toString(), null, null);
        String result = null;
        try {
            result = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String[] pairs = result.split("&");
        AccessGrant ag = new AccessGrant();
        for (String pair : pairs) {
            String[] kv = pair.split("=");
            if (kv.length != 2) {
                throw new SocialAuthException("Unexpected response from refresh token call");
            }
            if (kv[0].equals("access_token")) {
                ag.setKey(kv[1]);
                continue;
            }
            if (kv[0].equals("expires")) {
                ag.setAttribute("expires", Integer.valueOf(kv[1]));
                continue;
            }
            if (kv[0].equals("expires_in")) {
                ag.setAttribute("expires", Integer.valueOf(kv[1]));
                continue;
            }
            attributes.put(kv[0], kv[1]);
        }
        ag.setAttributes(attributes);
        this.LOG.debug((Object)("Refresh token Access Grant ::" + ag));
        this.accessGrant = ag;
        this.authenticationStrategy.setAccessGrant(ag);
    }

    static {
        AllPerms = new String[]{"publish_actions", "public_profile", "email", "user_birthday", "user_location", "user_photos", "user_friends", "user_posts"};
        AuthPerms = new String[]{"email", "user_birthday", "user_location", "public_profile"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://graph.facebook.com/oauth/authorize");
        ENDPOINTS.put("accessTokenURL", "https://graph.facebook.com/oauth/access_token");
    }
}

