/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.linkedin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Feed;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.plugin.FeedPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FeedPluginImpl
implements FeedPlugin,
Serializable {
    private static final long serialVersionUID = 497690659988355485L;
    private static final String FEED_URL = "http://api.linkedin.com/v1/people/~/network/updates";
    private static final Map<String, String> UPDATE_TYPES;
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;
    String fnameExpression = "//update[%s]/update-content/person/first-name";
    String lnameExpression = "//update[%s]/update-content/person/last-name";
    String idExpression = "//update[%s]/update-content/person/id";
    String cfnameExpression = "//update[%s]/update-content/person/connections/person/first-name";
    String clnameExpression = "//update[%s]/update-content/person/connections/person/last-name";
    String dateExpression = "//update[%s]/timestamp";
    String shareCommentExpression = "//update[%s]/update-content/person/current-share/comment";
    String statusExpression = "//update[%s]/update-content/person/current-status";
    String jobPosterFnameExpression = "//update[%s]/update-content/job-poster/first-name";
    String jobPosterLnameExpression = "//update[%s]/update-content/job-poster/last-name";
    String jobPosterIdExpression = "//update[%s]/update-content/job-poster/id";
    String jobPositionExpression = "//update[%s]/update-content/job/position";
    String jobCompanyExpression = "//update[%s]/update-content/job/company";
    String groupNameExpression = "//update[%s]/update-content/person/member-groups/member-group/name";
    String recommendationExpression = "//update[%s]/update-content/person/recommendations-given/recommendation/recommendation-snippet";
    String recommendeeFnameExpression = "//update[%s]/update-content/person/recommendations-given/recommendation/recommendee/first-name";
    String recommendeeLnameExpression = "//update[%s]/update-content/person/recommendations-given/recommendation/recommendee/last-name";
    String recommenderFnameExpression = "//update[%s]/update-content/person/recommendations-received/recommendation/recommender/first-name";
    String recommenderLnameExpression = "//update[%s]/update-content/person/recommendations-received/recommendation/recommender/last-name";
    String recommendationGivenCountExpression = "count(//update[%s]/update-content/person/recommendations-given)";
    String appUpdateExpression = "//update[%s]/update-content/person/person-activities/activity/body";
    String companyExpression = "//update[%s]/update-content/company/name";
    String companyPersonFnameExpression = "//update[%s]/update-content/company-person-update/person/first-name";
    String companyPersonLnameExpression = "//update[%s]/update-content/company-person-update/person/last-name";
    String companyPersonIdExpression = "//update[%s]/update-content/company-person-update/person/id";
    static final XPath xPath;

    public FeedPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Feed> getFeeds() throws Exception {
        List<Feed> list;
        this.LOG.info((Object)"Getting feeds from URL : http://api.linkedin.com/v1/people/~/network/updates");
        Response serviceResponse = null;
        try {
            serviceResponse = this.providerSupport.api(FEED_URL);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the feeds from http://api.linkedin.com/v1/people/~/network/updates", ie);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the feeds from  http://api.linkedin.com/v1/people/~/network/updates. Staus :" + serviceResponse.getStatus());
        }
        try {
            Element root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
            list = this.getStatusFeed(root);
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the feeds from response.http://api.linkedin.com/v1/people/~/network/updates", e);
        }
        return list;
    }

    private List<Feed> getStatusFeed(Element root) throws Exception {
        NodeList nodes = root.getElementsByTagName("update");
        ArrayList<Feed> list = new ArrayList<Feed>();
        if (nodes != null && nodes.getLength() > 0) {
            this.LOG.debug((Object)("Feeds count :: " + nodes.getLength()));
            for (int i = 1; i <= nodes.getLength(); ++i) {
                String type = xPath.evaluate("//update[" + i + "]/update-type", root);
                String fname = xPath.evaluate(String.format(this.fnameExpression, i), root);
                String lname = xPath.evaluate(String.format(this.lnameExpression, i), root);
                String id = xPath.evaluate(String.format(this.idExpression, i), root);
                String name = fname + " " + lname;
                String time = xPath.evaluate(String.format(this.dateExpression, i), root);
                Date date = new Date(Long.valueOf(time));
                boolean isSet = true;
                Feed feed = new Feed();
                feed.setId(id);
                feed.setCreatedAt(date);
                feed.setFrom(name);
                if ("CONN".equals(type)) {
                    String cfname = xPath.evaluate(String.format(this.cfnameExpression, i), root);
                    String clname = xPath.evaluate(String.format(this.clnameExpression, i), root);
                    feed.setMessage(name + UPDATE_TYPES.get("CONN") + cfname + " " + clname);
                } else if ("NCON".equals(type)) {
                    feed.setMessage(name + UPDATE_TYPES.get("NCON"));
                } else if ("CCEM".equals(type)) {
                    feed.setMessage(name + UPDATE_TYPES.get("CCEM"));
                } else if ("SHAR".equals(type)) {
                    String comment = xPath.evaluate(String.format(this.shareCommentExpression, i), root);
                    feed.setMessage(name + UPDATE_TYPES.get("SHAR") + comment);
                } else if ("STAT".equals(type)) {
                    String status = xPath.evaluate(String.format(this.statusExpression, i), root);
                    feed.setMessage(name + UPDATE_TYPES.get("STAT") + status);
                } else if ("JOBP".equals(type)) {
                    String jpFname = xPath.evaluate(String.format(this.jobPosterFnameExpression, i), root);
                    String jpLname = xPath.evaluate(String.format(this.jobPosterLnameExpression, i), root);
                    String jpId = xPath.evaluate(String.format(this.jobPosterIdExpression, i), root);
                    String position = xPath.evaluate(String.format(this.jobPositionExpression, i), root);
                    String company = xPath.evaluate(String.format(this.jobCompanyExpression, i), root);
                    feed.setFrom(jpFname + " " + jpLname);
                    feed.setId(jpId);
                    feed.setMessage(jpFname + " " + jpLname + UPDATE_TYPES.get("JOBP") + position + " at " + company);
                } else if ("JGRP".equals(type)) {
                    String groupName = xPath.evaluate(String.format(this.groupNameExpression, i), root);
                    feed.setMessage(name + UPDATE_TYPES.get("JGRP") + groupName);
                } else if ("PREC".equals(type)) {
                    double count = (Double)xPath.evaluate(String.format(this.recommendationGivenCountExpression, i), root, XPathConstants.NUMBER);
                    String message = "";
                    if (count > 0.0) {
                        String recommendation = xPath.evaluate(String.format(this.recommendationExpression, i), root);
                        String recommendeeFname = xPath.evaluate(String.format(this.recommendeeFnameExpression, i), root);
                        String recommendeeLname = xPath.evaluate(String.format(this.recommendeeLnameExpression, i), root);
                        message = name + UPDATE_TYPES.get("PREC_GIVEN") + recommendeeFname + " " + recommendeeLname;
                        if (recommendation != null && recommendation.length() > 0) {
                            message = message + " :'" + recommendation + "'";
                        }
                    } else {
                        String recommendeeFname = xPath.evaluate(String.format(this.recommenderFnameExpression, i), root);
                        String recommendeeLname = xPath.evaluate(String.format(this.recommenderLnameExpression, i), root);
                        message = name + UPDATE_TYPES.get("PREC_RECEIVED") + recommendeeFname + " " + recommendeeLname;
                    }
                    feed.setMessage(message);
                } else if ("PROF".equals(type)) {
                    feed.setMessage(name + UPDATE_TYPES.get("PROF"));
                } else if ("APPM".equals(type)) {
                    String update = xPath.evaluate(String.format(this.appUpdateExpression, i), root);
                    feed.setMessage(name + UPDATE_TYPES.get("APPM") + update);
                } else if ("MSFC".equals(type)) {
                    String company = xPath.evaluate(String.format(this.companyExpression, i), root);
                    String pfname = xPath.evaluate(String.format(this.companyPersonFnameExpression, i), root);
                    String plname = xPath.evaluate(String.format(this.companyPersonLnameExpression, i), root);
                    String pid = xPath.evaluate(String.format(this.companyPersonIdExpression, i), root);
                    feed.setMessage(pfname + " " + plname + UPDATE_TYPES.get("MSFC") + company);
                    feed.setFrom(pfname + " " + pfname);
                    feed.setId(pid);
                    list.add(feed);
                } else if ("PICU".equals(type)) {
                    feed.setMessage(name + UPDATE_TYPES.get("PICU"));
                } else {
                    isSet = false;
                }
                if (!isSet) continue;
                list.add(feed);
            }
        }
        return list;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    static {
        xPath = XPathFactory.newInstance().newXPath();
        UPDATE_TYPES = new HashMap<String, String>();
        UPDATE_TYPES.put("CONN", " is now connected to ");
        UPDATE_TYPES.put("NCON", " is now a connection ");
        UPDATE_TYPES.put("CCEM", " has joined LinkedIn ");
        UPDATE_TYPES.put("SHAR", " has shared - ");
        UPDATE_TYPES.put("STAT", " - ");
        UPDATE_TYPES.put("JOBP", "posted a job: ");
        UPDATE_TYPES.put("JGRP", " joined the group ");
        UPDATE_TYPES.put("PREC_GIVEN", " recommends ");
        UPDATE_TYPES.put("PREC_RECEIVED", " was recommended by ");
        UPDATE_TYPES.put("PROF", " updates his/her profile.");
        UPDATE_TYPES.put("APPM", " - ");
        UPDATE_TYPES.put("MSFC", " is now following ");
        UPDATE_TYPES.put("PICU", " updated profile picture ");
    }
}

