/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml.attribute;

import nu.xom.Attribute;
import org.xmlcml.euclid.Util;
import org.xmlcml.stml.attribute.StringSTAttribute;

public class DelimiterAttribute
extends StringSTAttribute {
    public static final String NAME = "delimiter";
    private String splitter = null;
    private String concat = null;

    public DelimiterAttribute() {
        super(NAME);
    }

    public DelimiterAttribute(String value) {
        super(NAME);
        this.setSTMLValue(value);
    }

    public DelimiterAttribute(Attribute att) throws RuntimeException {
        super(att);
        this.setSTMLValue(att.getValue());
    }

    @Override
    public void setSTMLValue(String value) throws RuntimeException {
        if (value == null) {
            value = " ";
        }
        if ((value = value.trim()).equals("")) {
            value = " ";
        } else if (value.length() > 1) {
            throw new RuntimeException("Non-whitespace delimiter must only be single character");
        }
        super.setSTMLValue(value);
        if (value.equals(" ")) {
            this.setSplitter("\\s+");
            this.setConcat(" ");
        } else {
            this.setSplitter(DelimiterAttribute.getEscapedDelimiter(value));
            this.setConcat(value);
        }
    }

    public String getConcat() {
        return this.concat;
    }

    public void setConcat(String concat) {
        this.concat = concat;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public void setSplitter(String splitter) {
        this.splitter = splitter;
    }

    private static String getEscapedDelimiter(String delim) {
        String delim1 = delim;
        if (delim.length() == 1 && (delim.equals("|") || delim.equals("?") || delim.equals("*") || delim.equals("."))) {
            delim1 = "\\" + delim;
        }
        return delim1;
    }

    public String[] getSplitContent(String content) {
        String[] ss = new String[]{};
        if ((content = content.trim()).length() > 0) {
            if (!this.isWhitespace()) {
                if (content.startsWith(this.concat)) {
                    content = content.substring(1);
                }
                if (content.endsWith(this.concat)) {
                    content = content.substring(0, content.length() - this.concat.length());
                }
            }
            ss = content.split(this.splitter);
        }
        return ss;
    }

    public void checkDelimiter(String s) throws RuntimeException {
        if (s.split(this.splitter).length > 1) {
            throw new RuntimeException("cannot delimit {" + s + "} with {" + this.concat + "}");
        }
    }

    public String getDelimitedXMLContent(String s) {
        if (s == null) {
            s = "";
        }
        if (!s.equals("") && !this.isWhitespace()) {
            if (!s.startsWith(this.concat)) {
                s = String.valueOf(this.concat) + s;
            }
            if (!s.endsWith(this.concat)) {
                s = String.valueOf(s) + this.concat;
            }
        }
        return s;
    }

    public String appendXMLContent(String s, String snew) {
        s = this.getDelimitedXMLContent(s);
        s = !this.isWhitespace() ? (s.length() == 0 ? String.valueOf(this.concat) + snew + this.concat : String.valueOf(s) + snew + this.concat) : String.valueOf(s) + this.concat + snew;
        return s;
    }

    private boolean isWhitespace() {
        return "\\s+".equals(this.splitter);
    }

    public String getDelimitedXMLContent(String[] ss) {
        String s;
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.checkDelimiter(s);
            ++n2;
        }
        s = Util.concatenate(ss, this.concat);
        if (!this.isWhitespace()) {
            s = String.valueOf(this.concat) + s + this.concat;
        }
        return s;
    }

    public String getDelimitedXMLContent(boolean[] bb) {
        boolean[] blArray = bb;
        int n = bb.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            this.checkDelimiter("" + b);
            ++n2;
        }
        String s = Util.concatenate(bb, this.concat);
        if (!this.isWhitespace()) {
            s = String.valueOf(this.concat) + s + this.concat;
        }
        return s;
    }

    public String getDelimitedXMLContent(double[] dd) {
        double[] dArray = dd;
        int n = dd.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            this.checkDelimiter("" + d);
            ++n2;
        }
        String s = Util.concatenate(dd, this.concat);
        if (!this.isWhitespace()) {
            s = String.valueOf(this.concat) + s + this.concat;
        }
        return s;
    }

    public String getDelimitedXMLContent(int[] ii) {
        int[] nArray = ii;
        int n = ii.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.checkDelimiter("" + i);
            ++n2;
        }
        String s = Util.concatenate(ii, this.concat);
        if (!this.isWhitespace()) {
            s = String.valueOf(this.concat) + s + this.concat;
        }
        return s;
    }

    public void debug(String s) {
        Util.println("-------- " + s + " -------");
        Util.println(this + " .. " + this.getValue() + " .. " + this.splitter + " .. " + this.concat);
    }

    public static enum Action {
        RESET,
        PRESERVE;

    }
}

