/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Util;

public class Vector3
implements EuclidConstants {
    static final int ZERO_VECT = 0;
    static final int UNK_VECT = 1;
    static final int UNIT_VECT = 2;
    static final int OK_VECT = 3;
    public static final Vector3 ZEROV = new Vector3(0.0, 0.0, 0.0);
    public static final Vector3 XV = new Vector3(1.0, 0.0, 0.0);
    public static final Vector3 YV = new Vector3(0.0, 1.0, 0.0);
    public static final Vector3 ZV = new Vector3(0.0, 0.0, 1.0);
    double[] flarray = new double[3];

    public Vector3() {
    }

    public Vector3(double x, double y, double z) {
        this();
        this.flarray[0] = x;
        this.flarray[1] = y;
        this.flarray[2] = z;
    }

    public Vector3(double[] array) throws EuclidRuntimeException {
        this();
        Util.check(array, 3);
        System.arraycopy(array, 0, this.flarray, 0, 3);
    }

    public Vector3(Axis.Axis3 axis) {
        this();
        Real.zeroArray(3, this.flarray);
        this.flarray[axis.value] = 1.0;
    }

    public Vector3(Vector3 v) {
        this();
        System.arraycopy(v.flarray, 0, this.flarray, 0, 3);
    }

    public Vector3(RealArray f) throws EuclidRuntimeException {
        this();
        RealArray.check(f, 3);
        System.arraycopy(f.getArray(), 0, this.flarray, 0, 3);
    }

    public Vector3(Point3 p) {
        this();
        System.arraycopy(p.flarray, 0, this.flarray, 0, 3);
    }

    public Vector3 clone(Vector3 v) {
        System.arraycopy(v.flarray, 0, this.flarray, 0, 3);
        return this;
    }

    public Vector3 clone(Point3 p) {
        System.arraycopy(p.flarray, 0, this.flarray, 0, 3);
        return this;
    }

    public double[] getArray() {
        return this.flarray;
    }

    public boolean isEqualTo(Vector3 v) {
        return Real.isEqual(this.getLength(), v.getLength());
    }

    public boolean longerThan(Vector3 v) {
        return this.getLength() > v.getLength();
    }

    public Vector3 multiplyBy(double f) {
        Vector3 v1 = new Vector3(this);
        int i = 0;
        while (i < 3) {
            int n = i++;
            v1.flarray[n] = v1.flarray[n] * f;
        }
        return v1;
    }

    public void multiplyEquals(double f) {
        int i = 2;
        while (i >= 0) {
            int n = i--;
            this.flarray[n] = this.flarray[n] * f;
        }
    }

    public Vector3 plus(Vector3 v3) {
        Vector3 v1 = new Vector3();
        v1 = this;
        int i = 0;
        while (i < 3) {
            int n = i;
            v1.flarray[n] = v1.flarray[n] + v3.flarray[i];
            ++i;
        }
        return v1;
    }

    public void plusEquals(Vector3 v3) {
        int i = 2;
        while (i >= 0) {
            int n = i;
            this.flarray[n] = this.flarray[n] + v3.flarray[i];
            --i;
        }
    }

    public Vector3 subtract(Vector3 v3) {
        Vector3 v1 = new Vector3();
        v1 = this;
        int i = 0;
        while (i < 3) {
            int n = i;
            v1.flarray[n] = v1.flarray[n] - v3.flarray[i];
            ++i;
        }
        return v1;
    }

    public void subtractEquals(Vector3 v3) {
        int i = 2;
        while (i >= 0) {
            int n = i;
            this.flarray[n] = this.flarray[n] - v3.flarray[i];
            --i;
        }
    }

    public Vector3 negative() {
        Vector3 v1 = new Vector3(this);
        int i = 0;
        while (i < 3) {
            v1.flarray[i] = -this.flarray[i];
            ++i;
        }
        return v1;
    }

    public Vector3 negativeEquals() {
        int i = 0;
        while (i < 3) {
            this.flarray[i] = -this.flarray[i];
            ++i;
        }
        return this;
    }

    public double elementAt(int n) throws EuclidRuntimeException {
        Util.check(n, 0, 2);
        return this.flarray[n];
    }

    public void setElementAt(int n, double f) throws EuclidRuntimeException {
        Util.check(n, 0, 2);
        this.flarray[n] = f;
    }

    public boolean isIdenticalTo(Vector3 v) {
        return Real.isEqual(this.flarray, v.flarray, Real.getEpsilon());
    }

    public boolean isZero() {
        boolean b = Real.isZero(this.getLength(), Real.getEpsilon());
        return b;
    }

    public Vector3 transform(Transform3 t) {
        Transform3.checkNotNull(t);
        Vector3 vout = new Vector3();
        double[] pv = vout.flarray;
        double[][] pt = t.getMatrix();
        int i = 0;
        while (i < 3) {
            double[] p = this.flarray;
            int j = 0;
            while (j < 3) {
                int n = i;
                pv[n] = pv[n] + pt[i][j] * p[j];
                ++j;
            }
            ++i;
        }
        return vout;
    }

    public Vector3 cross(Vector3 v3) {
        Vector3 v1 = new Vector3();
        int i = 0;
        int j = 1;
        int k = 2;
        while (i < 3) {
            v1.flarray[i] = this.flarray[j] * v3.flarray[k] - this.flarray[k] * v3.flarray[j];
            j = (j + 1) % 3;
            k = (k + 1) % 3;
            ++i;
        }
        return v1;
    }

    public Vector3 round() {
        int i = 0;
        while (i < 3) {
            this.flarray[i] = Math.round(this.flarray[i]);
            ++i;
        }
        return this;
    }

    public Vector3 normalize() {
        double veclength = this.getLength();
        if (veclength < 1.0E-14) {
            throw new EuclidRuntimeException("cannot normalize zero-length vector");
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            this.flarray[n] = this.flarray[n] / veclength;
        }
        return this;
    }

    public Vector3 normalise() {
        return this.normalize();
    }

    public Vector3 getUnitVector() {
        Vector3 v = new Vector3(this);
        v.normalize();
        return v;
    }

    public double getLength() {
        double sum = 0.0;
        int i = 0;
        while (i < 3) {
            sum += this.flarray[i] * this.flarray[i];
            ++i;
        }
        return Math.sqrt(sum);
    }

    public double dot(Vector3 v3) {
        double sum = 0.0;
        int i = 0;
        while (i < 3) {
            sum += this.flarray[i] * v3.flarray[i];
            ++i;
        }
        return sum;
    }

    protected double dot(double[] v3) {
        double sum = 0.0;
        int i = 0;
        while (i < 3) {
            sum += this.flarray[i] * v3[i];
            ++i;
        }
        return sum;
    }

    public Angle getAngleMadeWith(Vector3 v2) {
        Angle a = null;
        if (!this.isZero() && !v2.isZero()) {
            Vector3 v2a;
            Vector3 v1a = this.getUnitVector();
            double tmp = v1a.dot(v2a = v2.getUnitVector());
            if (tmp < -1.0) {
                tmp = -1.0;
            } else if (tmp > 1.0) {
                tmp = 1.0;
            }
            a = new Angle(Math.acos(tmp));
        }
        return a;
    }

    public double getScalarTripleProduct(Vector3 v2, Vector3 v3) {
        return this.dot(v2.cross(v3));
    }

    public Vector3 projectOnto(Vector3 v) throws EuclidRuntimeException {
        if (this.isZero() || v.isZero()) {
            throw new EuclidRuntimeException("zero length vector");
        }
        Vector3 projection = new Vector3();
        Vector3 unit3 = v.getUnitVector();
        Vector3 unit2 = this.getUnitVector();
        double dot = unit2.dot(unit3);
        projection = unit3.multiplyBy(this.getLength() * dot);
        return projection;
    }

    public boolean isColinearVector(Vector3 v) {
        return this.cross(v).isZero();
    }

    public Vector3 getNonColinearVector() {
        return this.isColinearVector(XV) ? YV : XV;
    }

    public Vector3 getPerpendicularVector() {
        return this.isZero() ? ZEROV : this.getNonColinearVector().cross(this);
    }

    public String toString() {
        return "(" + this.flarray[0] + "," + this.flarray[1] + "," + this.flarray[2] + ")";
    }
}

