/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.ParsedSymop;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealSquareMatrix;
import org.xmlcml.euclid.Vector3;

public class Transform3
extends RealSquareMatrix {
    private static final PrintStream SYSOUT = System.out;
    static final Logger LOG = Logger.getLogger(Transform3.class);
    Type trnsfrm;
    static final String[] oper = new String[]{"x", "y", "z"};

    public Transform3() {
        super(4);
        this.trnsfrm = Type.ANY;
        this.createIdentityTransform();
    }

    private void createIdentityTransform() {
        int i = 0;
        while (i < 4) {
            this.flmat[i][i] = 1.0;
            ++i;
        }
    }

    public Transform3(Type t) {
        this();
        this.trnsfrm = t;
    }

    public Transform3(Vector3 v) {
        this();
        this.trnsfrm = Type.ROT_TRANS;
        int i = 0;
        while (i < 3) {
            this.flmat[i][3] = v.flarray[i];
            ++i;
        }
    }

    public Transform3(Axis.Axis3 axis, Angle rot) {
        this();
        this.trnsfrm = Type.ROT_ORIG;
        RealSquareMatrix t1 = new RealSquareMatrix(4);
        double cosx = rot.cos();
        double sinx = rot.sin();
        if (axis == Axis.Axis3.X) {
            t1.flmat[0][0] = 1.0;
            t1.flmat[1][1] = cosx;
            t1.flmat[1][2] = sinx;
            t1.flmat[2][1] = -sinx;
            t1.flmat[2][2] = cosx;
            t1.flmat[3][3] = 1.0;
        } else if (axis == Axis.Axis3.Y) {
            t1.flmat[0][0] = cosx;
            t1.flmat[0][2] = -sinx;
            t1.flmat[1][1] = 1.0;
            t1.flmat[2][0] = sinx;
            t1.flmat[2][2] = cosx;
            t1.flmat[3][3] = 1.0;
        } else if (axis == Axis.Axis3.Z) {
            t1.flmat[0][0] = cosx;
            t1.flmat[0][1] = sinx;
            t1.flmat[1][0] = -sinx;
            t1.flmat[1][1] = cosx;
            t1.flmat[2][2] = 1.0;
            t1.flmat[3][3] = 1.0;
        }
        this.flmat = t1.flmat;
        this.trnsfrm = Type.ROT_ORIG;
    }

    public Transform3(Angle xrot, Angle yrot, Angle zrot) {
        super(4);
        RealSquareMatrix t2;
        this.trnsfrm = Type.ANY;
        double cosx = 0.0;
        double sinx = 0.0;
        this.trnsfrm = Type.ROT_ORIG;
        boolean mat = false;
        RealSquareMatrix t1 = new RealSquareMatrix(4);
        cosx = xrot.cos();
        sinx = xrot.sin();
        t1.flmat[0][0] = 1.0;
        t1.flmat[1][1] = cosx;
        t1.flmat[1][2] = sinx;
        t1.flmat[2][1] = -sinx;
        t1.flmat[2][2] = cosx;
        t1.flmat[3][3] = 1.0;
        mat = true;
        if (!yrot.isEqualTo(0.0)) {
            cosx = yrot.cos();
            sinx = yrot.sin();
            t2 = new RealSquareMatrix(4);
            t2.flmat[0][0] = cosx;
            t2.flmat[1][1] = 1.0;
            t2.flmat[0][2] = -sinx;
            t2.flmat[2][0] = sinx;
            t2.flmat[2][2] = cosx;
            t2.flmat[3][3] = 1.0;
            t1 = mat ? t2.multiply(t1) : t2;
            mat = true;
        }
        if (!zrot.isEqualTo(0.0)) {
            cosx = zrot.cos();
            sinx = zrot.sin();
            t2 = new RealSquareMatrix(4);
            t2.flmat[0][0] = cosx;
            t2.flmat[0][1] = sinx;
            t2.flmat[1][0] = -sinx;
            t2.flmat[1][1] = cosx;
            t2.flmat[2][2] = 1.0;
            t2.flmat[3][3] = 1.0;
            t1 = mat ? t2.multiply(t1) : t2;
        }
        this.flmat = t1.flmat;
        this.trnsfrm = Type.ROT_ORIG;
    }

    public Transform3(Transform3 t, Point3 p) {
        super(4);
        this.trnsfrm = Type.ANY;
        double[] f1 = new double[]{0.0, 0.0, 0.0, 1.0};
        this.trnsfrm = Type.ROT_TRANS;
        Vector3 tvect = new Vector3(p);
        Transform3 trans1 = new Transform3(tvect.negative());
        Transform3 trans2 = new Transform3(tvect);
        RealArray f0 = new RealArray(f1);
        Transform3 temp = t;
        temp.replaceColumnData(3, f0);
        Transform3 temp3 = trans2.concatenate(temp.concatenate(trans1));
        this.flmat = temp3.flmat;
        this.trnsfrm = temp3.trnsfrm;
    }

    public Transform3(Vector3 v, Angle a) {
        super(4);
        this.trnsfrm = Type.ANY;
        this.trnsfrm = Type.ROT_ORIG;
        Vector3 v2 = v;
        v2.normalize();
        double cosa = a.cos();
        RealArray tempf = new RealArray(3, cosa);
        RealSquareMatrix m3 = RealSquareMatrix.diagonal(tempf);
        RealArray temp1 = new RealArray(v2.getArray());
        RealSquareMatrix m2 = RealSquareMatrix.outerProduct(temp1);
        m2.multiplyBy(1.0 - cosa);
        m2 = m2.plus(m3);
        double sina = a.sin();
        m3.clearMatrix();
        double f = sina * v2.flarray[2];
        m3.flmat[0][1] = -f;
        m3.flmat[1][0] = f;
        m3.flmat[0][2] = f = sina * v2.flarray[1];
        m3.flmat[2][0] = -f;
        f = sina * v2.flarray[0];
        m3.flmat[1][2] = -f;
        m3.flmat[2][1] = f;
        m2 = m2.plus(m3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.flmat[i][j] = m2.flmat[i][j];
                ++j;
            }
            ++i;
        }
        this.flmat[3][3] = 1.0;
    }

    public Transform3(Line3 l, Angle a) {
        super(4);
        this.trnsfrm = Type.ANY;
        this.trnsfrm = Type.ROT_TRANS;
        Vector3 v = l.getVector();
        Point3 p = l.getPoint();
        Transform3 temp = new Transform3(v, a);
        Vector3 orig = new Vector3(p);
        Transform3 trans1 = new Transform3(orig.negative());
        orig = new Vector3(p);
        Transform3 trans2 = new Transform3(orig);
        Transform3 temp2 = new Transform3();
        temp2 = new Transform3(trans2.concatenate(temp.concatenate(trans1)));
        this.flmat = temp2.flmat;
    }

    public Transform3(Vector3 v1, Vector3 v2) {
        super(4);
        this.trnsfrm = Type.ANY;
        Vector3 v12 = v1.cross(v2);
        if (v12.isZero()) {
            double unit = 1.0;
            if (v1.dot(v2) < 0.0) {
                unit = -1.0;
            }
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    this.flmat[i][j] = 0.0;
                    ++j;
                }
                this.flmat[i][i] = unit;
                ++i;
            }
        } else {
            Angle a = v1.getAngleMadeWith(v2);
            Transform3 temp = new Transform3(v12, a);
            this.flmat = temp.flmat;
            this.trnsfrm = temp.trnsfrm;
        }
    }

    public Transform3(Vector3 v1, Vector3 v2, Vector3 v3) {
        super(4);
        this.trnsfrm = Type.ANY;
        int i = 0;
        while (i < 3) {
            this.flmat[0][i] = v1.flarray[i];
            this.flmat[1][i] = v2.flarray[i];
            this.flmat[2][i] = v3.flarray[i];
            this.flmat[3][i] = 0.0;
            this.flmat[i][3] = 0.0;
            ++i;
        }
        this.flmat[3][3] = 1.0;
        this.trnsfrm = Type.ROT_ORIG;
    }

    public static Transform3 applyScales(double scaleX, double scaleY, double scaleZ) {
        return new Transform3(new double[]{scaleX, 0.0, 0.0, 0.0, 0.0, scaleY, 0.0, 0.0, 0.0, 0.0, scaleZ, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    public static Transform3 applyScale(double scale) {
        return Transform3.applyScales(scale, scale, scale);
    }

    public Transform3(double[] array) throws EuclidRuntimeException {
        super(4, array);
        this.trnsfrm = Type.ANY;
        this.trnsfrm = this.checkMatrix();
    }

    public Transform3(Transform3 m) {
        super(m);
        this.trnsfrm = Type.ANY;
        this.trnsfrm = m.trnsfrm;
    }

    public Transform3(RealSquareMatrix m) throws EuclidRuntimeException {
        this();
        if (m.getCols() == 3) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    this.flmat[i][j] = m.flmat[i][j];
                    ++j;
                }
                ++i;
            }
        } else {
            if (m.getCols() != 4) {
                throw new EuclidRuntimeException("must have 3 or 4 cols");
            }
            this.flmat = m.flmat;
        }
        this.trnsfrm = this.checkMatrix();
    }

    public Transform3(RealSquareMatrix m, Vector3 v) throws EuclidRuntimeException {
        this(m);
        if (m.getCols() == 3) {
            int i = 0;
            while (i < 3) {
                this.flmat[i][3] = v.flarray[i];
                ++i;
            }
        } else {
            throw new EuclidRuntimeException("must have 3 columns");
        }
    }

    /*
     * Unable to fully structure code
     */
    public Transform3(String opString) throws EuclidRuntimeException {
        block4: {
            super(4);
            this.trnsfrm = Type.ANY;
            ss = opString.split("\\s*,\\s*");
            if (ss.length != 3) {
                throw new EuclidRuntimeException("Must have 3 operators");
            }
            try {
                ParsedSymop.createTransform(ss);
                break block4;
            }
            catch (RuntimeException e) {
                i = 0;
                ** while (i < 3)
            }
lbl-1000:
            // 1 sources

            {
                s = ss[i];
                s = s.trim();
                this.analyzeOperator(opString, i, s);
                ++i;
                continue;
            }
        }
    }

    private void analyzeOperator(String opString, int i, String s) {
        StringTokenizer sst = new StringTokenizer(s, "+-", true);
        int ntok = sst.countTokens();
        double sign = 1.0;
        int j = 0;
        while (j < ntok) {
            String ss = sst.nextToken().trim();
            int idx = ss.indexOf("/");
            if (idx != -1) {
                String numerator = ss.substring(0, idx).trim();
                String denominator = ss.substring(idx + 1).trim();
                this.flmat[i][3] = sign * (double)Integer.parseInt(numerator) / (double)Integer.parseInt(denominator);
            } else if (ss.equalsIgnoreCase("x")) {
                this.flmat[i][0] = sign;
            } else if (ss.equalsIgnoreCase("y")) {
                this.flmat[i][1] = sign;
            } else if (ss.equalsIgnoreCase("z")) {
                this.flmat[i][2] = sign;
            } else if (ss.equals("-")) {
                sign = -1.0;
            } else if (ss.equals("+")) {
                sign = 1.0;
            } else if (!ss.trim().equals("")) {
                try {
                    this.flmat[i][3] = sign * (double)Integer.parseInt(ss);
                }
                catch (NumberFormatException nfe) {
                    SYSOUT.flush();
                    throw new EuclidRuntimeException("Bad string in symmetry: " + ss + " in " + opString);
                }
            }
            ++j;
        }
    }

    public Transform3 clone(Transform3 m) {
        Transform3 temp = new Transform3((RealSquareMatrix)m);
        temp.trnsfrm = m.trnsfrm;
        return temp;
    }

    Transform3 clone(RealSquareMatrix m) {
        Transform3 temp = new Transform3(m);
        temp.trnsfrm = this.checkMatrix();
        return temp;
    }

    public boolean isEqualTo(Transform3 m) {
        return super.isEqualTo(m) && this.trnsfrm == m.trnsfrm;
    }

    public Transform3 concatenate(Transform3 m2) {
        RealSquareMatrix temp = new RealSquareMatrix(this.multiply(m2));
        Transform3 temp1 = new Transform3(temp);
        temp1.trnsfrm = this.trnsfrm.i > m2.trnsfrm.i ? this.trnsfrm : m2.trnsfrm;
        return temp1;
    }

    public int setTransformationType(Type option) {
        RealSquareMatrix s3 = new RealSquareMatrix();
        if (option == Type.ROT_ORIG) {
            s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
            s3.orthonormalize();
            this.replaceSubMatrixData(0, 0, s3);
        } else if (option == Type.ROT_TRANS) {
            s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
            s3.orthonormalize();
            this.replaceSubMatrixData(0, 0, s3);
        } else if (option == Type.ROT_TRANS_SCALE) {
            s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
            double[] scale = s3.euclideanColumnLengths().getArray();
            double scale3 = Math.exp(Math.log(scale[0] * scale[1] * scale[2]) / 3.0);
            s3.orthonormalize();
            RealArray sc1 = new RealArray(3, scale3);
            RealSquareMatrix s = RealSquareMatrix.diagonal(sc1);
            s3 = s.multiply(s3);
            this.replaceSubMatrixData(0, 0, s3);
        } else if (option != Type.ROT_TRANS_SCALE_PERSP) {
            if (option == Type.ROT_TRANS_AXIAL_SCALE) {
                s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
                RealArray scale = s3.euclideanColumnLengths();
                s3.orthonormalize();
                RealSquareMatrix s = RealSquareMatrix.diagonal(scale);
                s3 = s.multiply(s3);
                this.replaceSubMatrixData(0, 0, s3);
            } else if (option != Type.ANY && option != Type.NULL) {
                return 1;
            }
        }
        this.trnsfrm = option;
        return 0;
    }

    public Type getTransformationType() {
        return this.trnsfrm;
    }

    public Type checkMatrix() {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
        RealArray c3 = this.extractColumnData(3);
        if (c3 != null && Real.isZero(c3.elementAt(0), Real.getEpsilon()) && Real.isZero(c3.elementAt(1), Real.getEpsilon()) && Real.isZero(c3.elementAt(2), Real.getEpsilon())) {
            return Type.NULL;
        }
        if (s3.isUnit()) {
            return Type.NULL;
        }
        if (s3.isUnitary()) {
            return Type.ROT_ORIG;
        }
        if (s3.isUnitary()) {
            return Type.ROT_TRANS;
        }
        if (s3.isOrthogonal()) {
            double[] scale = s3.euclideanColumnLengths().getArray();
            if (Real.isEqual(scale[0], scale[1]) && Real.isEqual(scale[1], scale[2])) {
                return Type.ROT_TRANS_SCALE;
            }
            return Type.ROT_TRANS_AXIAL_SCALE;
        }
        return Type.ANY;
    }

    public int getAxisAndAngle(Vector3 axis, Angle ang) {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
        s3.orthonormalize();
        int chirality = 1;
        if (s3.determinant() < 0.0) {
            s3.negative();
            chirality = -1;
        }
        double theta = Math.acos((s3.trace() - 1.0) * 0.5);
        double[][] mat = s3.getMatrix();
        double[] lmn = new double[3];
        if (Real.isEqual(theta, Math.PI) || Real.isEqual(theta, 0.0)) {
            lmn[0] = Math.sqrt((1.0 + mat[0][0]) * 0.5);
            if (Real.isZero(lmn[0], Real.getEpsilon())) {
                lmn[1] = mat[0][1] * 0.5 / lmn[0];
                lmn[2] = mat[0][2] * 0.5 / lmn[0];
            } else {
                lmn[1] = Math.sqrt((1.0 + mat[1][1]) * 0.5);
                lmn[2] = mat[1][2] / (2.0 * lmn[1]);
            }
        } else {
            double c = 1.0 / (2.0 * Math.sin(theta));
            lmn[0] = (mat[2][1] - mat[1][2]) * c;
            lmn[1] = (mat[0][2] - mat[2][0]) * c;
            lmn[2] = (mat[1][0] - mat[0][1]) * c;
        }
        ang.shallowCopy(new Angle(theta));
        System.arraycopy(lmn, 0, axis.getArray(), 0, 3);
        return chirality;
    }

    public Vector3 getTranslation() {
        return new Vector3(this.flmat[0][3], this.flmat[1][3], this.flmat[2][3]);
    }

    public void incrementTranslation(Vector3 dt) {
        double[] dArray = this.flmat[0];
        dArray[3] = dArray[3] + dt.flarray[0];
        double[] dArray2 = this.flmat[1];
        dArray2[3] = dArray2[3] + dt.flarray[1];
        double[] dArray3 = this.flmat[2];
        dArray3[3] = dArray3[3] + dt.flarray[2];
    }

    public void setTranslation(Vector3 t) {
        this.flmat[0][3] = t.flarray[0];
        this.flmat[1][3] = t.flarray[1];
        this.flmat[2][3] = t.flarray[2];
    }

    public Point3 getCentreOfRotation() {
        Point3 p = new Point3();
        RealSquareMatrix unit = new RealSquareMatrix(3);
        RealSquareMatrix temp = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
        unit = unit.subtract(temp);
        unit.transpose();
        RealArray t = new RealArray(this.getTranslation().getArray());
        p = new Point3(unit.multiply(t).getArray());
        return p;
    }

    public RealArray getScales() {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
        RealArray scales = s3.euclideanColumnLengths();
        return scales;
    }

    public RealSquareMatrix getRotationMatrix() {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 2, 0, 2));
        s3.normaliseByColumns();
        RealSquareMatrix s = s3;
        return s;
    }

    public String getCrystallographicString() {
        String s = "";
        int irow = 0;
        while (irow < 3) {
            s = String.valueOf(s) + this.trans(this.flmat[irow][3]);
            int jcol = 0;
            while (jcol < 3) {
                double f = this.flmat[irow][jcol];
                if (f > 0.1) {
                    s = String.valueOf(s) + "+" + oper[jcol];
                } else if (f < -0.1) {
                    s = String.valueOf(s) + "-" + oper[jcol];
                }
                ++jcol;
            }
            if (irow < 2) {
                s = String.valueOf(s) + ",";
            }
            ++irow;
        }
        return s;
    }

    private String trans(double dd) {
        int n = (int)Math.round(dd * 12.0);
        int d = 12;
        if (n % 2 == 0) {
            n /= 2;
            d /= 2;
        }
        if (n % 2 == 0) {
            n /= 2;
            d /= 2;
        }
        if (n % 3 == 0) {
            n /= 3;
            d /= 3;
        }
        String s = "";
        if (n != 0) {
            s = d == 1 ? "" + n : String.valueOf(s) + n + "/" + d;
        }
        return s;
    }

    public static void checkNotNull(Transform3 t) {
        if (t == null) {
            throw new EuclidRuntimeException("null transform");
        }
    }

    public static enum Type {
        NULL(1, "none"),
        ROT_ORIG(2, "rotation about origin"),
        ROT_TRANS(3, "rotation translation"),
        ROT_TRANS_SCALE(4, "rotation translation scale"),
        ROT_TRANS_AXIAL_SCALE(5, "rotation translation axial scale"),
        ROT_TRANS_SCALE_PERSP(6, "perspective"),
        ANY(7, "any");

        public int i;
        public String s;

        private Type(int i, String s) {
            this.i = i;
            this.s = s;
        }
    }
}

