/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.Plane3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class Point3
implements EuclidConstants {
    static final Logger LOG = Logger.getLogger(Point3.class);
    public static final double CRYSTALFRACTEPSILON = 0.001;
    protected double[] flarray = new double[3];

    public Point3() {
    }

    public Point3(double x, double y, double z) {
        this.flarray[0] = x;
        this.flarray[1] = y;
        this.flarray[2] = z;
    }

    public Point3(Point3 p) {
        System.arraycopy(p.flarray, 0, this.flarray, 0, 3);
    }

    public Point3(double[] f) throws EuclidRuntimeException {
        Util.check(f, 3);
        System.arraycopy(f, 0, this.flarray, 0, 3);
    }

    public Point3(Vector3 v) {
        System.arraycopy(v.flarray, 0, this.flarray, 0, 3);
    }

    public double[] getArray() {
        return this.flarray;
    }

    public void clear() {
        this.flarray[2] = 0.0;
        this.flarray[1] = 0.0;
        this.flarray[0] = 0.0;
    }

    public boolean isEqualTo(Point3 p) {
        return Real.isEqual(this.flarray, p.flarray, Real.getEpsilon());
    }

    public boolean isEqualTo(Point3 p, double eps) {
        return Real.isEqual(this.flarray, p.flarray, eps);
    }

    public boolean equalsCrystallographically(Point3 p) {
        if (p.flarray == null) {
            return false;
        }
        Point3 crystal = new Point3(this);
        crystal.normaliseCrystallographically();
        Point3 crystalP = new Point3(p);
        crystalP.normaliseCrystallographically();
        return Real.isEqual(crystalP.flarray, crystal.flarray, 0.001);
    }

    public Vector3 normaliseCrystallographically() {
        double[] arr = new double[3];
        int i = 0;
        while (i < 3) {
            double start = this.flarray[i];
            this.flarray[i] = Point3.normaliseCrystallographically(this.flarray[i]);
            arr[i] = Math.round(this.flarray[i] - start);
            ++i;
        }
        return new Vector3(arr);
    }

    private static double normaliseCrystallographically(double d) {
        while (d >= 1.0) {
            d -= 1.0;
        }
        while (d < 0.0) {
            d += 1.0;
        }
        return d;
    }

    public boolean isInvariant(Transform3 t3, boolean translate) {
        Point3 pNew = this.transform(t3);
        return translate ? pNew.equalsCrystallographically(this) : pNew.isEqualTo(this);
    }

    public Vector3 subtract(Point3 p2) {
        Vector3 v1 = new Vector3(this);
        int i = 0;
        while (i < 3) {
            int n = i;
            v1.flarray[n] = v1.flarray[n] - p2.flarray[i];
            ++i;
        }
        return v1;
    }

    public Point3 plus(Point3 p) {
        Point3 p1 = new Point3();
        int i = 0;
        while (i < 3) {
            p1.flarray[i] = this.flarray[i] + p.flarray[i];
            ++i;
        }
        return p1;
    }

    public void plusEquals(Point3 pt) {
        int i = 0;
        while (i < 3) {
            int n = i;
            this.flarray[n] = this.flarray[n] + pt.flarray[i];
            ++i;
        }
    }

    public Point3 plus(Vector3 v) {
        Point3 p1 = new Point3();
        int i = 0;
        while (i < 3) {
            p1.flarray[i] = this.flarray[i] + v.flarray[i];
            ++i;
        }
        return p1;
    }

    public void plusEquals(Vector3 v) {
        int i = 0;
        while (i < 3) {
            int n = i;
            this.flarray[n] = this.flarray[n] + v.flarray[i];
            ++i;
        }
    }

    public Point3 subtract(Vector3 v) {
        Point3 p1 = new Point3();
        int i = 0;
        while (i < 3) {
            p1.flarray[i] = this.flarray[i] - v.flarray[i];
            ++i;
        }
        return p1;
    }

    public void subtractEquals(Point3 pt) {
        int i = 0;
        while (i < 3) {
            int n = i;
            this.flarray[n] = this.flarray[n] - pt.flarray[i];
            ++i;
        }
    }

    public void subtractEquals(Vector3 vec3) {
        int i = 0;
        while (i < 3) {
            int n = i;
            this.flarray[n] = this.flarray[n] - vec3.flarray[i];
            ++i;
        }
    }

    public Point3 multiplyBy(double f) {
        Point3 p1 = new Point3();
        int i = 0;
        while (i < 3) {
            p1.flarray[i] = this.flarray[i] * f;
            ++i;
        }
        return p1;
    }

    public void multiplyEquals(double f) {
        int i = 2;
        while (i >= 0) {
            int n = i--;
            this.flarray[n] = this.flarray[n] * f;
        }
    }

    public void reflect() {
        this.flarray[0] = -this.flarray[0];
        this.flarray[1] = -this.flarray[1];
        this.flarray[2] = -this.flarray[2];
    }

    public Point3 divideBy(double f) {
        Point3 p1 = new Point3();
        int i = 0;
        while (i < 3) {
            p1.flarray[i] = this.flarray[i] / f;
            ++i;
        }
        return p1;
    }

    public void divideEquals(double f) {
        double f1 = 1.0 / f;
        int i = 2;
        while (i >= 0) {
            int n = i--;
            this.flarray[n] = this.flarray[n] * f1;
        }
    }

    public double elementAt(int n) throws EuclidRuntimeException {
        Util.check(n, 0, 2);
        return this.flarray[n];
    }

    public void setElementAt(int n, double d) throws EuclidRuntimeException {
        Util.check(n, 0, 2);
        this.flarray[n] = d;
    }

    public Point3 transform(Transform3 t) {
        RealArray col3 = new RealArray(4, 1.0);
        col3.setElements(0, this.flarray);
        RealArray result = t.multiply(col3);
        Point3 pout = new Point3(result.getSubArray(0, 2).getArray());
        return pout;
    }

    public void transformEquals(Transform3 t) {
        RealArray col3 = new RealArray(4, 1.0);
        col3.setElements(0, this.flarray);
        RealArray result = t.multiply(col3);
        System.arraycopy(result.getSubArray(0, 2).getArray(), 0, this.flarray, 0, 3);
    }

    public double getDistanceFromOrigin() {
        Vector3 v = new Vector3(this);
        return v.getLength();
    }

    public double getSquaredDistanceFromPoint(Point3 p2) {
        double d = this.flarray[0] - p2.flarray[0];
        double sqdDist = d * d;
        d = this.flarray[1] - p2.flarray[1];
        sqdDist += d * d;
        d = this.flarray[2] - p2.flarray[2];
        return sqdDist += d * d;
    }

    public double getDistanceFromPoint(Point3 p2) {
        Vector3 v = new Vector3(p2.subtract(this));
        return v.getLength();
    }

    public double distanceFromPlane(Plane3 pl) {
        return pl.getDistanceFromPoint(this);
    }

    public Point3 getClosestPointOnLine(Line3 l) {
        return l.getClosestPointTo(this);
    }

    public boolean isOnLine(Line3 l) {
        return l.containsPoint(this);
    }

    public boolean isOnPlane(Plane3 pl) {
        return pl.containsPoint(this);
    }

    public double distanceFromLine(Line3 l) {
        return l.getDistanceFromPoint(this);
    }

    public Point3 getMidPoint(Point3 p2) {
        Point3 p = new Point3();
        int i = 0;
        while (i < 3) {
            p.flarray[i] = (this.flarray[i] + p2.flarray[i]) / 2.0;
            ++i;
        }
        return p;
    }

    public static Angle getAngle(Point3 p1, Point3 p2, Point3 p3) {
        Vector3 v1 = p1.subtract(p2);
        return v1.isZero() ? null : v1.getAngleMadeWith(p3.subtract(p2));
    }

    public static Angle getTorsion(Point3 p1, Point3 p2, Point3 p3, Point3 p4) {
        Angle angle = null;
        Vector3 v23 = p3.subtract(p2);
        Vector3 v13a = p2.subtract(p1);
        Vector3 v13 = v13a.cross(v23);
        Vector3 v24 = v23.cross(p4.subtract(p3));
        v13.normalize();
        v24.normalize();
        double ang = v13.getAngleMadeWith(v24).getAngle();
        if (v13.getScalarTripleProduct(v24, v23) < 0.0) {
            ang = -ang;
        }
        angle = new Angle(ang);
        return angle;
    }

    public static Point3 calculateFromInternalCoordinates(Point3 p1, Point3 p2, Point3 p3, double length, Angle angle, Angle torsion) throws EuclidRuntimeException {
        Vector3 v32 = p2.subtract(p3);
        Vector3 v12 = p2.subtract(p1);
        Vector3 v13a = v12.cross(v32);
        Vector3 v13n = v13a.normalize();
        Vector3 v32n = v32.normalize();
        Vector3 v34 = v32n.multiplyBy(length);
        Transform3 t = new Transform3(v13n, angle);
        v34 = v34.transform(t);
        v32n = v32n.negative();
        Transform3 t1 = new Transform3(v32n, torsion);
        v34 = v34.transform(t1);
        Point3 p4 = p3.plus(v34);
        return p4;
    }

    public boolean isOrigin() {
        int i = 0;
        while (i < 3) {
            if (!Real.isZero(this.flarray[i], Real.getEpsilon())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return "(" + this.flarray[0] + "," + " " + this.flarray[1] + "," + " " + this.flarray[2] + ")";
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Point3)) {
            return false;
        }
        Point3 p3 = (Point3)that;
        return Real.isEqual(this.getArray(), p3.getArray(), 0.001);
    }

    public int hashCode() {
        int result = 17;
        int c = 1;
        long x = Double.doubleToLongBits(this.flarray[0]);
        c *= (int)(x ^ x >>> 32);
        long y = Double.doubleToLongBits(this.flarray[1]);
        c *= (int)(y ^ x >>> 32);
        long z = Double.doubleToLongBits(this.flarray[2]);
        return 37 * result + (c *= (int)(z ^ x >>> 32));
    }

    public static void main(String[] args) {
        Point3 one = new Point3(0.1, 0.2, 0.3);
        Point3 two = new Point3(0.1, 0.2, 0.5);
        if (one.equals(two)) {
            Util.println("are equal in state");
        }
        if (one == two) {
            Util.println("same object");
        }
    }
}

