/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.IntRange;
import org.xmlcml.euclid.Util;

public class IntSet
implements EuclidConstants {
    static final Logger LOG = Logger.getLogger(IntSet.class);
    private int[] array;
    private int nelem = 0;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    Set<Integer> set;
    public static Map<Integer, List<List<Integer>>> integerMap = new HashMap<Integer, List<List<Integer>>>();

    public IntSet() {
        this.initialise(0, 0, true);
    }

    public IntSet(int nelem) {
        this.nelem = nelem = nelem < 0 ? 0 : nelem;
        this.initialise(0, nelem, true);
    }

    public IntSet(int start, int end) {
        this.nelem = end - start + 1;
        if (this.nelem <= 0) {
            this.nelem = 0;
        }
        this.initialise(start, this.nelem, true);
    }

    public IntSet(IntSet is) {
        if (is != null) {
            this.array = is.array;
            System.arraycopy(is.array, 0, this.array, 0, this.nelem);
            this.nelem = is.nelem;
            this.min = is.min;
            this.max = is.max;
            this.set = new HashSet<Integer>();
            for (Integer ii : is.set) {
                this.set.add(ii);
            }
        }
    }

    public IntSet(int[] is) throws EuclidRuntimeException {
        this.nelem = is.length;
        this.initialise(0, this.nelem, false);
        int i = 0;
        int[] nArray = is;
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            int ii = nArray[n2];
            if (this.contains(ii)) {
                throw new EuclidRuntimeException("Duplicate value: " + i);
            }
            this.array[i++] = ii;
            this.set.add(ii);
            ++n2;
        }
    }

    public IntSet getSubscriptedIntSet(IntSet sub) throws EuclidRuntimeException {
        IntSet is = new IntSet(sub.size());
        int i = 0;
        while (i < sub.size()) {
            int j = sub.elementAt(i);
            if (j < 0 || j >= this.nelem) {
                throw new EuclidRuntimeException("sub index (" + j + ") too large for " + this.toString());
            }
            is.setElementAt(i, this.array[j]);
            ++i;
        }
        return is;
    }

    private void initialise(int start, int nelem, boolean addSet) {
        this.array = new int[nelem];
        this.set = new HashSet<Integer>();
        int nToAdd = nelem;
        int i = 0;
        while (i < nToAdd) {
            this.array[i] = start + i;
            if (addSet) {
                this.set.add(this.array[i]);
            }
            ++i;
        }
    }

    public boolean isEqualTo(IntSet is) {
        int i = 0;
        while (i < this.nelem) {
            if (this.array[i] != is.array[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] getElements() {
        if (this.nelem != this.array.length) {
            int[] temp = new int[this.nelem];
            System.arraycopy(this.array, 0, temp, 0, this.nelem);
            this.array = temp;
        }
        return this.array;
    }

    public void setMax(int max) throws EuclidRuntimeException {
        int i = 0;
        while (i < this.nelem) {
            if (this.array[i] > max) {
                throw new EuclidRuntimeException("element in set (" + this.array[i] + ") greater than new max (" + max + ")");
            }
            ++i;
        }
        this.max = max;
    }

    public void setMin(int min) {
        int i = 0;
        while (i < this.nelem) {
            if (this.array[i] < min) {
                throw new EuclidRuntimeException("element in set (" + this.array[i] + ") less than new max (" + this.max + ")");
            }
            ++i;
        }
        this.min = min;
    }

    public int size() {
        return this.nelem;
    }

    public boolean addElement(int value) throws EuclidRuntimeException {
        if (value < this.min || value > this.max) {
            throw new EuclidRuntimeException("value (" + value + ")outside range (" + this.min + "..." + this.max + ")");
        }
        if (this.set.contains(value)) {
            throw new EuclidRuntimeException("value already in set: " + value);
        }
        if (this.nelem >= this.array.length) {
            int nbuff = this.array.length == 0 ? 1 : this.array.length;
            while (this.nelem >= nbuff) {
                nbuff *= 2;
            }
            int[] temp = new int[nbuff];
            int i = 0;
            while (i < this.nelem) {
                temp[i] = this.array[i];
                ++i;
            }
            this.array = temp;
        }
        this.array[this.nelem++] = value;
        this.set.add(value);
        return true;
    }

    public boolean contains(int value) {
        return this.set.contains(value);
    }

    public int elementAt(int i) throws ArrayIndexOutOfBoundsException {
        if (i < 0 || i >= this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[i];
    }

    public IntArray getIntArray() {
        int[] temp = new int[this.nelem];
        System.arraycopy(this.array, 0, temp, 0, this.nelem);
        return new IntArray(temp);
    }

    public void sortAscending() {
        IntArray temp = this.getIntArray();
        temp.sortAscending();
        int i = 0;
        while (i < this.nelem) {
            this.array[i] = temp.array[i];
            ++i;
        }
    }

    public void addSet(IntSet is) throws EuclidRuntimeException {
        int i = 0;
        while (i < is.nelem) {
            int ii = is.elementAt(i);
            if (this.contains(ii)) {
                throw new EuclidRuntimeException("duplicate element " + ii);
            }
            this.addElement(ii);
            ++i;
        }
    }

    public IntSet intersectionWith(IntSet is) {
        IntSet ix = new IntSet();
        int i = 0;
        while (i < is.nelem) {
            int ii = is.elementAt(i);
            if (this.contains(ii)) {
                ix.addElement(ii);
            }
            ++i;
        }
        return ix;
    }

    public IntSet notIn(IntSet is) {
        IntSet ix = new IntSet();
        int i = 0;
        while (i < this.nelem) {
            int ii = this.elementAt(i);
            if (!is.contains(ii)) {
                ix.addElement(ii);
            }
            ++i;
        }
        return ix;
    }

    public void addRange(IntRange ir) {
        if (ir == null) {
            return;
        }
        int i = ir.getMin();
        while (i <= ir.getMax()) {
            this.addElement(i);
            ++i;
        }
    }

    public IntSet inverseMap() throws ArrayIndexOutOfBoundsException {
        IntSet temp = new IntSet(this.size());
        int i = 0;
        while (i < this.size()) {
            temp.setElementAt(this.elementAt(i), i);
            ++i;
        }
        return temp;
    }

    void setElementAt(int i, int value) throws ArrayIndexOutOfBoundsException {
        if (i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[i] = value;
    }

    public void debug() {
        int i = 0;
        while (i < this.nelem) {
            Util.print(" " + this.array[i]);
            ++i;
        }
        Util.println();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("(");
        int i = 0;
        while (i < this.nelem) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.array[i]);
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    private static List<Integer> copy(List<Integer> list) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (Integer ii : list) {
            newList.add(ii);
        }
        return newList;
    }

    public static List<int[]> getPermutations(Integer number) {
        ArrayList<int[]> intArrayList = new ArrayList<int[]>();
        List<List<Integer>> intListList = IntSet.getPermutations0(number);
        for (List<Integer> intList : intListList) {
            int size = intList.size();
            int[] ints = new int[size];
            int i = 0;
            while (i < size) {
                ints[i] = intList.get(i);
                ++i;
            }
            intArrayList.add(ints);
        }
        return intArrayList;
    }

    private static List<List<Integer>> getPermutations0(Integer number) {
        List<List<Integer>> listList = integerMap.get(number);
        if (listList == null) {
            listList = new ArrayList<List<Integer>>();
            if (number.equals(0)) {
                listList.add(new ArrayList());
            } else {
                List<List<Integer>> listListMinus = IntSet.getPermutations0(number - 1);
                for (List<Integer> listMinus : listListMinus) {
                    Integer ii = 0;
                    while (ii < number) {
                        List<Integer> copyList = IntSet.copy(listMinus);
                        copyList.add(ii, number);
                        listList.add(copyList);
                        ii = ii + 1;
                    }
                }
            }
            integerMap.put(number, listList);
        }
        return listList;
    }
}

