/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.RealSquareMatrix;

class Diagonalise
implements EuclidConstants {
    static final double ZERO = 0.0;
    static final double ONE = 1.0;
    static final double TWO = 2.0;
    static final double SQRT2 = Math.sqrt(2.0);

    Diagonalise() {
    }

    public static int vneigl(int order, double[] a, double[] eigval, double[] eigvec, EuclidRuntimeException illCond) throws EuclidRuntimeException {
        double sinx2 = 0.0;
        int m = 0;
        double anrmx = 0.0;
        int imr = 0;
        double thr = 0.0;
        double cosx = 0.0;
        double sinx = 0.0;
        double xxyy = 0.0;
        double cosx2 = 0.0;
        sinx2 = 0.0;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        m = 0;
        double x = 0.0;
        double y = 0.0;
        double range = 0.0;
        double anorm = 0.0;
        double sincs = 0.0;
        anrmx = 0.0;
        int ia = 0;
        int ij = 0;
        int ll = 0;
        int lm = 0;
        int iq = 0;
        int mm = 0;
        int jq = 0;
        int lq = 0;
        int mq = 0;
        int ind = 0;
        int ilq = 0;
        int imq = 0;
        int ilr = 0;
        imr = 0;
        thr = 0.0;
        RealSquareMatrix.LOG.info((Object)("O..." + order));
        if (order < 2) {
            throw new EuclidRuntimeException("order too small");
        }
        range = 1.0E-6f;
        iq = -order;
        j = 1;
        while (j <= order) {
            iq += order;
            i = 1;
            while (i <= order) {
                ij = iq + i;
                eigvec[ij] = 0.0;
                if (i - j == 0) {
                    eigvec[ij] = 1.0;
                }
                ++i;
            }
            ++j;
        }
        RealSquareMatrix.LOG.info((Object)("O " + order));
        anorm = 0.0;
        i = 1;
        while (i <= order) {
            j = i;
            while (j <= order) {
                if (i - j != 0) {
                    ia = i + (j * j - j) / 2;
                    anorm += a[ia] * a[ia];
                }
                ++j;
            }
            ++i;
        }
        if (anorm > 0.0) {
            anorm = Math.sqrt(anorm) * SQRT2;
            anrmx = anorm * range / (double)order;
            ind = 0;
            thr = anorm;
            do {
                thr /= (double)order;
                while (true) {
                    l = 1;
                    while (true) {
                        m = l + 1;
                        while (true) {
                            mq = (m * m - m) / 2;
                            lq = (l * l - l) / 2;
                            lm = l + mq;
                            if (Math.abs(a[lm]) - thr >= 0.0) {
                                ind = 1;
                                ll = l + lq;
                                mm = m + mq;
                                x = (a[ll] - a[mm]) * 0.5;
                                y = -a[lm] / Math.sqrt(a[lm] * a[lm] + x * x);
                                if (x < 0.0) {
                                    y = -y;
                                }
                                if ((xxyy = 1.0 - y * y) < 0.0) {
                                    xxyy = 0.0;
                                }
                                sinx = y / Math.sqrt((Math.sqrt(xxyy) + 1.0) * 2.0);
                                sinx2 = sinx * sinx;
                                cosx = Math.sqrt(1.0 - sinx2);
                                cosx2 = cosx * cosx;
                                sincs = sinx * cosx;
                                ilq = order * (l - 1);
                                imq = order * (m - 1);
                                Diagonalise.subroutine(order, a, ilq, imq, l, m, lq, mq, ll, lm, mm, sinx, cosx, eigval, eigvec, sincs, sinx2, cosx2);
                            }
                            if (m == order) break;
                            ++m;
                        }
                        if (l == order - 1) break;
                        ++l;
                    }
                    RealSquareMatrix.LOG.info((Object)("[" + l + "/" + order + "]"));
                    RealSquareMatrix.LOG.info((Object)("+" + l + "/" + ind));
                    if (ind != 1) break;
                    ind = 0;
                }
                RealSquareMatrix.LOG.info((Object)"====================broke");
            } while (!(thr - anrmx <= 0.0));
        }
        iq = -order;
        i = 1;
        while (i <= order) {
            iq += order;
            ll = i + (i * i - i) / 2;
            jq = order * (i - 2);
            j = i;
            while (j <= order) {
                jq += order;
                mm = j + (j * j - j) / 2;
                if (!(a[ll] - a[mm] >= 0.0)) {
                    x = a[ll];
                    a[ll] = a[mm];
                    a[mm] = x;
                    k = 1;
                    while (k <= order) {
                        ilr = iq + k;
                        imr = jq + k;
                        x = eigvec[ilr];
                        eigvec[ilr] = eigvec[imr];
                        eigvec[imr] = x;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return Diagonalise.eigtest(order, a, eigval, range);
    }

    private static int eigtest(int order, double[] a, double[] eigval, double range) {
        int rank = 0;
        int i = order;
        while (i >= 1) {
            eigval[i] = a[(i * i + i) / 2];
            if (eigval[i] < 0.0) break;
            if (eigval[i] < range) {
                RealSquareMatrix.LOG.info((Object)"SING");
                break;
            }
            ++rank;
            --i;
        }
        return rank;
    }

    static void subroutine(int order, double[] a, int ilq, int imq, int l, int m, int lq, int mq, int ll, int lm, int mm, double sinx, double cosx, double[] eigval, double[] eigvec, double sincs, double sinx2, double cosx2) {
        int i = 1;
        while (i <= order) {
            double x;
            int iq = (i * i - i) / 2;
            if (i != l) {
                int ivar2 = i - m;
                if (ivar2 != 0) {
                    int im = ivar2 < 0 ? i + mq : m + iq;
                    int il = i >= l ? l + iq : i + lq;
                    x = a[il] * cosx - a[im] * sinx;
                    a[im] = a[il] * sinx + a[im] * cosx;
                    a[il] = x;
                }
                int ilr = ilq + i;
                int imr = imq + i;
                x = eigvec[ilr] * cosx - eigvec[imr] * sinx;
                eigvec[imr] = eigvec[ilr] * sinx + eigvec[imr] * cosx;
                eigvec[ilr] = x;
            }
            x = a[lm] * 2.0 * sincs;
            double y = a[ll] * cosx2 + a[mm] * sinx2 - x;
            x = a[ll] * sinx2 + a[mm] * cosx2 + x;
            a[lm] = (a[ll] - a[mm]) * sincs + a[lm] * (cosx2 - sinx2);
            a[ll] = y;
            a[mm] = x;
            ++i;
        }
    }
}

