/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.string;

public class KnuthMorrisPrattAlgorithm {
    private final String needle;
    private final int[] stateTransitionTable;

    public KnuthMorrisPrattAlgorithm(String needle) {
        this.needle = needle;
        this.stateTransitionTable = new int[needle.length()];
        this.stateTransitionTable[0] = -1;
        int state = 0;
        for (int i = 1; i < needle.length(); ++i) {
            int transition = state;
            if (needle.charAt(transition) == needle.charAt(i)) {
                transition = this.stateTransitionTable[transition];
            }
            this.stateTransitionTable[i] = transition;
            if (needle.charAt(i) == needle.charAt(state)) {
                ++state;
                continue;
            }
            state = 0;
        }
    }

    public int execute(String haystack) {
        return this.execute(haystack, 0);
    }

    public int execute(String haystack, int index) {
        int state = 0;
        for (int i = index; i < haystack.length(); ++i) {
            if (haystack.charAt(i) == this.needle.charAt(state)) {
                if (++state != this.needle.length()) continue;
                return i - this.needle.length() + 1;
            }
            while ((state = this.stateTransitionTable[state]) >= 0 && haystack.charAt(i) != this.needle.charAt(state)) {
            }
            ++state;
        }
        return -1;
    }
}

