/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.tools;

import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.tools.AtomTool;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.molutil.ChemicalElement;

public class MoleculeTool {
    static final Logger LOG = Logger.getLogger((String)MoleculeTool.class.getName());

    public static double getAverageBondLength(CMLMolecule molecule, CMLElement.CoordinateType type, boolean omitHydrogens) {
        double bondSum = 0.0;
        int nBonds = 0;
        for (CMLBond bond : molecule.getBonds()) {
            if (omitHydrogens && ("H".equals(bond.getAtom(0).getElementType()) || "H".equals(bond.getAtom(1).getElementType()))) continue;
            try {
                double length = bond.calculateBondLength(type);
                if (Double.isNaN(length)) continue;
                LOG.trace((Object)("len " + length));
                bondSum += length;
                ++nBonds;
            }
            catch (RuntimeException runtimeException) {}
        }
        return nBonds == 0 || Double.isNaN(bondSum) || Real.isZero((double)bondSum, (double)1.0E-14) ? Double.NaN : bondSum / (double)nBonds;
    }

    public static void transform(CMLMolecule molecule, Transform2 t2) {
        for (CMLAtom atom : molecule.getAtoms()) {
            if (!atom.hasCoordinates(CMLElement.CoordinateType.TWOD)) continue;
            Real2 dd = new Real2(atom.getX2(), atom.getY2());
            dd.transformBy(t2);
            atom.setXY2(dd);
        }
    }

    public static void adjustHydrogenCountsToValency(CMLMolecule molecule, CMLAtom atom, CMLMolecule.HydrogenControl control) {
        if (atom.getHydrogenCountAttribute() == null) {
            int group = MoleculeTool.getHydrogenValencyGroup(atom);
            if (group == -1) {
                return;
            }
            if (group == -2) {
                return;
            }
            if (group < 4) {
                return;
            }
            int sumBo = MoleculeTool.getSumNonHydrogenBondOrder(molecule, atom);
            int fc = atom.getFormalChargeAttribute() == null ? 0 : atom.getFormalCharge();
            int nh = 8 - group - sumBo + fc;
            if (group == 4 && fc == 1) {
                nh -= 2;
            }
            atom.setHydrogenCount(nh);
            MoleculeTool.expandImplicitHydrogens(molecule, atom, control);
        }
    }

    public static int getHydrogenValencyGroup(CMLAtom atom) {
        int[] group = new int[]{1, 4, 5, 6, 7, 4, 5, 6, 7, 7, 7};
        int[] eneg0 = new int[]{0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1};
        int[] eneg1 = new int[]{0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1};
        int elNum = -1;
        try {
            String elType = atom.getElementType();
            elNum = CMLAtom.getCommonElementSerialNumber((String)elType);
            if (elNum == -1) {
                return -1;
            }
            if (eneg0[elNum] == 0) {
                return group[elNum];
            }
            List ligandList = atom.getLigandAtoms();
            for (CMLAtom lig : ligandList) {
                int ligElNum = CMLAtom.getCommonElementSerialNumber((String)lig.getElementType());
                if (ligElNum != -1 && eneg1[ligElNum] != 1) continue;
                return -2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("BUG " + e));
        }
        int g = elNum == -1 ? -1 : group[elNum];
        return g;
    }

    public static void expandImplicitHydrogens(CMLMolecule molecule, CMLAtom atom, CMLMolecule.HydrogenControl control) throws RuntimeException {
        if (control.equals((Object)CMLMolecule.HydrogenControl.USE_HYDROGEN_COUNT)) {
            return;
        }
        if (atom.getHydrogenCountAttribute() == null || atom.getHydrogenCount() == 0) {
            return;
        }
        int hydrogenCount = atom.getHydrogenCount();
        int currentHCount = 0;
        List ligandList = atom.getLigandAtoms();
        for (CMLAtom ligand : ligandList) {
            if (!ligand.getElementType().equals(ChemicalElement.AS.H.value)) continue;
            ++currentHCount;
        }
        if (control.equals((Object)CMLMolecule.HydrogenControl.NO_EXPLICIT_HYDROGENS) && currentHCount != 0) {
            return;
        }
        String id = atom.getId();
        for (int i = 0; i < hydrogenCount - currentHCount; ++i) {
            CMLAtom hatom = new CMLAtom(id + "_h" + (i + 1));
            molecule.addAtom(hatom);
            hatom.setElementType(ChemicalElement.AS.H.value);
            CMLBond bond = new CMLBond(atom, hatom);
            molecule.addBond(bond);
            bond.setOrder("1");
        }
    }

    public static int getSumNonHydrogenBondOrder(CMLMolecule molecule, CMLAtom atom) throws RuntimeException {
        float sumBo = 0.0f;
        List ligandList = atom.getLigandAtoms();
        for (CMLAtom ligand : ligandList) {
            if (ChemicalElement.AS.H.equals(ligand.getElementType())) continue;
            CMLBond bond = molecule.getBond(atom, ligand);
            if (bond == null) {
                throw new RuntimeException("Serious bug in getSumNonHydrogenBondOrder");
            }
            String bo = bond.getOrder();
            if (bo != null) {
                if (CMLBond.isSingle((String)bo)) {
                    sumBo = (float)((double)sumBo + 1.0);
                }
                if (CMLBond.isDouble((String)bo)) {
                    sumBo = (float)((double)sumBo + 2.0);
                }
                if (CMLBond.isTriple((String)bo)) {
                    sumBo = (float)((double)sumBo + 3.0);
                }
                if (!bo.equals("A")) continue;
                sumBo = (float)((double)sumBo + 1.4);
                continue;
            }
            sumBo = (float)((double)sumBo + 1.0);
        }
        return Math.round(sumBo);
    }

    public static void adjustHydrogenCountsToValency(CMLMolecule molecule, CMLMolecule.HydrogenControl control) {
        if (molecule.isMoleculeContainer()) {
            CMLElements molecules = molecule.getMoleculeElements();
            for (CMLMolecule mol : molecules) {
                MoleculeTool.adjustHydrogenCountsToValency(mol, control);
            }
        } else {
            List atoms = molecule.getAtoms();
            for (CMLAtom atom : atoms) {
                AtomTool.adjustHydrogenCountsToValency(atom, molecule, control);
            }
        }
    }

    public static void addCalculated3DCoordinatesForExistingHydrogens(CMLMolecule molecule) {
        List atomList = molecule.getAtoms();
        for (CMLAtom atom : atomList) {
            AtomTool.addCalculated3DCoordinatesForExistingHydrogens(atom);
        }
    }
}

