/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.tools;

import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.tools.AtomTool;
import org.xmlcml.cml.tools.MoleculeTool;
import org.xmlcml.molutil.ChemicalElement;

public class GeometryTool {
    static final Logger LOG = Logger.getLogger((String)GeometryTool.class.getName());

    public static void addCalculatedCoordinatesForHydrogens(CMLMolecule molecule, CMLElement.CoordinateType type, CMLMolecule.HydrogenControl control) {
        if (type.equals((Object)CMLElement.CoordinateType.CARTESIAN)) {
            GeometryTool.addCalculated3DCoordinatesForHydrogens(molecule, control);
        } else if (type.equals((Object)CMLElement.CoordinateType.TWOD)) {
            GeometryTool.addCalculated2DCoordinatesForHydrogens(molecule, control);
        } else {
            throw new RuntimeException("Add calculated coordinates for hydrogens: control not recognised: " + type);
        }
    }

    public static void addCalculated3DCoordinatesForHydrogens(CMLMolecule molecule, CMLMolecule.HydrogenControl control) {
        CMLElements molecules = molecule.getMoleculeElements();
        if (molecules.size() > 0) {
            for (CMLMolecule childMol : molecules) {
                GeometryTool.addCalculated3DCoordinatesForHydrogens(childMol, control);
            }
        } else {
            MoleculeTool.addCalculated3DCoordinatesForExistingHydrogens(molecule);
        }
    }

    @Deprecated
    public static void addCalculated2DCoordinatesForHydrogens(CMLMolecule molecule, CMLMolecule.HydrogenControl control) {
        block3: {
            double bondLength;
            block2: {
                CMLElements molecules = molecule.getMoleculeElements();
                if (molecules.size() <= 0) break block2;
                for (CMLMolecule childMolecule : molecules) {
                    GeometryTool.addCalculated2DCoordinatesForHydrogens(childMolecule, control);
                }
                break block3;
            }
            boolean omitHydrogens = true;
            if (!molecule.hasCoordinates(CMLElement.CoordinateType.TWOD, omitHydrogens) || Double.isNaN(bondLength = MoleculeTool.getAverageBondLength(molecule, CMLElement.CoordinateType.TWOD, omitHydrogens) * 0.75)) break block3;
            for (CMLAtom atom : molecule.getAtoms()) {
                if (ChemicalElement.AS.H.equals(atom.getElementType())) continue;
                AtomTool.calculateAndAddHydrogenCoordinates(atom, bondLength);
            }
        }
    }
}

