/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nu.xom.Attribute;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomSet;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.tools.AtomGeometry;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Vector2;
import org.xmlcml.euclid.Vector3;
import org.xmlcml.molutil.ChemicalElement;
import org.xmlcml.molutil.Molutils;

public class AtomTool {
    static final Logger LOG = Logger.getLogger((String)AtomTool.class.getName());
    static String[] elems = new String[]{ChemicalElement.AS.H.value, ChemicalElement.AS.C.value, ChemicalElement.AS.N.value, ChemicalElement.AS.O.value, ChemicalElement.AS.F.value, ChemicalElement.AS.Si.value, ChemicalElement.AS.P.value, ChemicalElement.AS.S.value, ChemicalElement.AS.Cl.value, ChemicalElement.AS.Br.value, ChemicalElement.AS.I.value};
    static int[] group = new int[]{1, 4, 5, 6, 7, 4, 5, 6, 7, 7, 7};
    static int[] eneg0 = new int[]{0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1};
    static int[] eneg1 = new int[]{0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1};
    private static Transform2 PI120 = new Transform2(new Angle(2.0943951023931953));
    private static Transform2 PI90 = new Transform2(new Angle(1.5707963267948966));
    private static Transform2 PI270 = new Transform2(new Angle(4.71238898038469));
    private static final Transform2 ROT90 = new Transform2(new Angle(1.5707963267948966));
    private static final double TWOPI3 = 2.0943951023931953;
    private static final double COS2PI3 = Math.cos(2.0943951023931953);
    private static final double SIN2PI3 = Math.sin(2.0943951023931953);
    private static final double ROOT3 = Math.sqrt(3.0);
    private static final double TETANG = 2.0 * Math.atan(Math.sqrt(2.0));
    private static final double TETANG0 = Math.PI - TETANG;
    private static final double TWOPI30 = 1.0471975511965979;
    private static double DTORAD = Math.PI / 180;

    public static void adjustHydrogenCountsToValency(CMLAtom atom, CMLMolecule molecule, CMLMolecule.HydrogenControl control) {
        if (atom.getHydrogenCountAttribute() == null) {
            int group = AtomTool.getHydrogenValencyGroup(atom);
            if (group == -1) {
                return;
            }
            if (group == -2) {
                return;
            }
            if (group < 4) {
                return;
            }
            int sumBo = AtomTool.getSumNonHydrogenBondOrder(atom);
            int fc = atom.getFormalChargeAttribute() == null ? 0 : atom.getFormalCharge();
            int nh = 8 - group - sumBo + fc;
            if (group == 4 && fc == 1) {
                nh -= 2;
            }
            if (nh < 0) {
                nh = 0;
            }
            atom.setHydrogenCount(nh);
        }
        AtomTool.expandImplicitHydrogens(atom, molecule, control);
    }

    public static int getHydrogenValencyGroup(CMLAtom atom) {
        int elNum = -1;
        try {
            String elType = atom.getElementType();
            elNum = AtomTool.getElemNumb(elType);
            if (elNum == -1) {
                return -1;
            }
            if (eneg0[elNum] == 0) {
                return group[elNum];
            }
            List ligands = atom.getLigandAtoms();
            for (CMLAtom ligand : ligands) {
                int ligElNum = AtomTool.getElemNumb(ligand.getElementType());
                if (ligElNum != -1 && eneg1[ligElNum] != 1) continue;
                return -2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("BUG " + e));
        }
        int g = elNum == -1 ? -1 : group[elNum];
        return g;
    }

    private static int getElemNumb(String elemType) {
        for (int i = 0; i < elems.length; ++i) {
            if (!elems[i].equals(elemType)) continue;
            return i;
        }
        return -1;
    }

    public static int getSumNonHydrogenBondOrder(CMLAtom atom) throws RuntimeException {
        float sumBo = 0.0f;
        List ligandList = atom.getLigandAtoms();
        List ligandBondList = atom.getLigandBonds();
        for (int i = 0; i < ligandList.size(); ++i) {
            CMLAtom ligand = (CMLAtom)ligandList.get(i);
            if (ChemicalElement.AS.H.equals(ligand.getElementType())) continue;
            CMLBond bond = (CMLBond)ligandBondList.get(i);
            String bo = bond.getOrder();
            if (bo != null) {
                if (CMLBond.isSingle((String)bo)) {
                    sumBo = (float)((double)sumBo + 1.0);
                }
                if (CMLBond.isDouble((String)bo)) {
                    sumBo = (float)((double)sumBo + 2.0);
                }
                if (CMLBond.isTriple((String)bo)) {
                    sumBo = (float)((double)sumBo + 3.0);
                }
                if (!bo.equals("A")) continue;
                sumBo = (float)((double)sumBo + 1.4);
                continue;
            }
            sumBo = (float)((double)sumBo + 1.0);
        }
        return Math.round(sumBo);
    }

    public static void expandImplicitHydrogens(CMLAtom atom, CMLMolecule molecule, CMLMolecule.HydrogenControl control) throws RuntimeException {
        if (CMLMolecule.HydrogenControl.USE_HYDROGEN_COUNT.equals((Object)control)) {
            return;
        }
        if (atom.getHydrogenCountAttribute() == null || atom.getHydrogenCount() == 0) {
            return;
        }
        int hydrogenCount = atom.getHydrogenCount();
        int currentHCount = 0;
        List ligandList = atom.getLigandAtoms();
        for (CMLAtom ligand : ligandList) {
            if (!ligand.getElementType().equals(ChemicalElement.AS.H.value)) continue;
            ++currentHCount;
        }
        if (CMLMolecule.HydrogenControl.NO_EXPLICIT_HYDROGENS.equals((Object)control) && currentHCount != 0) {
            return;
        }
        String id = atom.getId();
        List bonds = atom.getLigandBonds();
        Angle wedgeAngle = null;
        Angle hatchAngle = null;
        double bondLength = 0.0;
        ArrayList<Angle> otherAngles = new ArrayList<Angle>();
        for (CMLBond bond : bonds) {
            if (bond.getBondStereo() != null && bond.getBondStereo().getValue().equals("W") && bond.getAtom(0) == atom) {
                wedgeAngle = new Angle(Math.atan2(bond.getAtom(1).getY2() - atom.getY2(), bond.getAtom(1).getX2() - atom.getX2()), Angle.Units.RADIANS);
                bondLength = (bond.getAtom(1).getY2() - atom.getY2()) * (bond.getAtom(1).getY2() - atom.getY2()) + (bond.getAtom(1).getX2() - atom.getX2()) * (bond.getAtom(1).getX2() - atom.getX2());
                continue;
            }
            if (bond.getBondStereo() != null && bond.getBondStereo().getValue().equals("H") && bond.getAtom(0) == atom) {
                hatchAngle = new Angle(Math.atan2(bond.getAtom(1).getY2() - atom.getY2(), bond.getAtom(1).getX2() - atom.getX2()), Angle.Units.RADIANS);
                bondLength = (bond.getAtom(1).getY2() - atom.getY2()) * (bond.getAtom(1).getY2() - atom.getY2()) + (bond.getAtom(1).getX2() - atom.getX2()) * (bond.getAtom(1).getX2() - atom.getX2());
                continue;
            }
            if (bond.getAtom(0) == atom) {
                otherAngles.add(new Angle(Math.atan2(bond.getAtom(1).getY2() - atom.getY2(), bond.getAtom(1).getX2() - atom.getX2()), Angle.Units.RADIANS));
                continue;
            }
            otherAngles.add(new Angle(Math.atan2(bond.getAtom(0).getY2() - atom.getY2(), bond.getAtom(0).getX2() - atom.getX2()), Angle.Units.RADIANS));
        }
        bondLength = Math.sqrt(bondLength);
        for (int i = 0; i < hydrogenCount - currentHCount; ++i) {
            CMLAtom hatom = new CMLAtom(id + "_h" + (i + 1));
            molecule.addAtom(hatom);
            hatom.setElementType(ChemicalElement.AS.H.value);
            CMLBond bond = new CMLBond(atom, hatom);
            molecule.addBond(bond);
            bond.setOrder("S");
            if (hatchAngle == null ^ wedgeAngle == null) {
                CMLBondStereo s = new CMLBondStereo();
                s.setXMLContent(hatchAngle != null ? "W" : "H");
                bond.setBondStereo(s);
                Angle baseBondAngle = hatchAngle != null ? hatchAngle : (wedgeAngle != null ? wedgeAngle : (Angle)otherAngles.get(2));
                Angle diff1 = baseBondAngle.subtract((Angle)otherAngles.get(0));
                Angle diff2 = baseBondAngle.subtract((Angle)otherAngles.get(1));
                diff1.setRange(Angle.Range.UNLIMITED);
                diff2.setRange(Angle.Range.UNLIMITED);
                Angle newAngle = Math.abs(diff1.getRadian()) < Math.abs(diff2.getRadian()) ? ((Angle)otherAngles.get(0)).plus(baseBondAngle).multiplyBy(0.5) : ((Angle)otherAngles.get(1)).plus(baseBondAngle).multiplyBy(0.5);
                AtomTool.positionAtomRelatively(atom, hatom, newAngle, bondLength);
                continue;
            }
            if (hatchAngle == null && wedgeAngle == null) {
                if (atom.getXY2() == null) continue;
                hatom.setXY2(atom.getXY2().plus(new Real2(1, 1)));
                continue;
            }
            if (hatchAngle == null || wedgeAngle == null) continue;
            otherAngles.add(wedgeAngle);
            otherAngles.add(hatchAngle);
            Collections.sort(otherAngles, new Comparator<Angle>(){

                @Override
                public int compare(Angle o1, Angle o2) {
                    return o1.lessThan(o2) ? -1 : 1;
                }
            });
            Angle largestAngle = new Angle(0.0);
            Angle newAngle = null;
            for (int angle = 0; angle < otherAngles.size() - 1; ++angle) {
                Angle diff;
                if (otherAngles.get(angle) == wedgeAngle && otherAngles.get(angle + 1) == hatchAngle || otherAngles.get(angle) == hatchAngle && otherAngles.get(angle + 1) == wedgeAngle || !(diff = ((Angle)otherAngles.get(angle + 1)).subtract((Angle)otherAngles.get(angle))).greaterThan(largestAngle)) continue;
                largestAngle = diff;
                newAngle = ((Angle)otherAngles.get(angle)).plus((Angle)otherAngles.get(angle + 1)).multiplyBy(0.5);
            }
            Angle diff = ((Angle)otherAngles.get(0)).subtract((Angle)otherAngles.get(otherAngles.size() - 1)).plus(new Angle(360.0, Angle.Units.DEGREES));
            if (diff.greaterThan(largestAngle)) {
                largestAngle = diff;
                newAngle = ((Angle)otherAngles.get(otherAngles.size() - 1)).plus((Angle)otherAngles.get(0)).multiplyBy(0.5).plus(new Angle(180.0, Angle.Units.DEGREES));
            }
            AtomTool.positionAtomRelatively(atom, hatom, newAngle, bondLength);
        }
    }

    private static void positionAtomRelatively(CMLAtom atom, CMLAtom hatom, Angle newAngle, double bondLength) {
        double yDiff;
        double xDiff;
        if (newAngle.isEqualTo(Math.PI, 1.0E-7)) {
            xDiff = -bondLength;
            yDiff = 0.0;
        } else if (newAngle.isEqualTo(1.5707963267948966, 1.0E-7)) {
            xDiff = 0.0;
            yDiff = bondLength;
        } else if (newAngle.isEqualTo(0.0, 1.0E-7)) {
            xDiff = bondLength;
            yDiff = 0.0;
        } else if (newAngle.isEqualTo(-1.5707963267948966, 1.0E-7)) {
            xDiff = 0.0;
            yDiff = -bondLength;
        } else if (newAngle.isEqualTo(-Math.PI, 1.0E-7)) {
            xDiff = -bondLength;
            yDiff = 0.0;
        } else {
            double ratio = Math.tan(newAngle.getRadian());
            xDiff = Math.sqrt(bondLength * bondLength / (1.0 + ratio * ratio));
            if (newAngle.greaterThan(1.5707963267948966) && newAngle.lessThan(4.71238898038469)) {
                xDiff *= -1.0;
            }
            yDiff = xDiff * ratio;
        }
        hatom.setXY2(atom.getXY2().plus(new Real2(xDiff, yDiff)));
    }

    public void addCalculatedCoordinatesForHydrogens(CMLAtom atom, CMLElement.CoordinateType type, double bondLength) {
        if (!CMLElement.CoordinateType.TWOD.equals((Object)type)) {
            if (CMLElement.CoordinateType.CARTESIAN.equals((Object)type)) {
                throw new RuntimeException("CARTESIAN H coords nyi");
            }
            throw new RuntimeException("THREED H coords nyi");
        }
        AtomTool.calculateAndAddHydrogenCoordinates(atom, bondLength);
    }

    public static void calculateAndAddHydrogenCoordinates(CMLAtom atom, double bondLength) {
        List ligandHydrogenList = atom.getLigandHydrogenAtoms();
        List ligandList = atom.getLigandAtoms();
        ArrayList<CMLAtom> nonHydrogenLigandHydrogenList = new ArrayList<CMLAtom>();
        for (CMLAtom ligand : ligandList) {
            if (ChemicalElement.AS.H.equals(ligand.getElementType())) continue;
            nonHydrogenLigandHydrogenList.add(ligand);
        }
        List<Object> vectorList = new ArrayList();
        try {
            vectorList = AtomTool.addCoords(atom, nonHydrogenLigandHydrogenList, ligandHydrogenList, bondLength);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot add Hydrogen ", (Throwable)e);
        }
        if (vectorList.size() != 0) {
            if (vectorList.size() != ligandHydrogenList.size()) {
                LOG.error((Object)("vectorList (" + vectorList.size() + ") != ligandHydrogenList (" + ligandHydrogenList.size() + ")"));
            } else {
                Real2 xy2 = atom.getXY2();
                for (int i = 0; i < ligandHydrogenList.size(); ++i) {
                    ((CMLAtom)ligandHydrogenList.get(i)).setXY2(xy2.plus((Real2)vectorList.get(i)));
                }
            }
        }
    }

    private static void addCoords(CMLAtom atom, List<Vector3> vector3List, List<CMLAtom> hydrogenLigandList) {
        Point3 atomxyz3 = atom.getXYZ3();
        for (int i = 0; i < vector3List.size(); ++i) {
            Point3 xyz3 = atomxyz3.plus(vector3List.get(i));
            hydrogenLigandList.get(i).setXYZ3(xyz3);
        }
    }

    private static List<Vector2> addCoords(CMLAtom atom, List<CMLAtom> ligandList, List<CMLAtom> hydrogenList, double bondLength) {
        ArrayList<Vector2> vectorList = new ArrayList<Vector2>();
        if (hydrogenList.size() != 0) {
            if (ligandList.size() == 0) {
                if (hydrogenList.size() == 1) {
                    vectorList.add(new Vector2(0.0, bondLength));
                } else if (hydrogenList.size() == 2) {
                    vectorList.add(new Vector2(0.0, bondLength));
                    vectorList.add(new Vector2(0.0, -bondLength));
                } else if (hydrogenList.size() == 3) {
                    vectorList.add(new Vector2(0.0, bondLength));
                    vectorList.add(new Vector2(bondLength * Math.sqrt(0.75), -bondLength * 0.5));
                    vectorList.add(new Vector2(-bondLength * Math.sqrt(0.75), -bondLength * 0.5));
                } else if (hydrogenList.size() == 4) {
                    vectorList.add(new Vector2(0.0, bondLength));
                    vectorList.add(new Vector2(0.0, -bondLength));
                    vectorList.add(new Vector2(bondLength, 0.0));
                    vectorList.add(new Vector2(-bondLength, 0.0));
                }
            } else if (ligandList.size() == 1) {
                Vector2 ligandVector = new Vector2(ligandList.get(0).getXY2().subtract(atom.getXY2()));
                ligandVector = new Vector2(ligandVector.getUnitVector().multiplyBy(-bondLength));
                if (hydrogenList.size() == 1) {
                    vectorList.add(new Vector2((Real2)ligandVector));
                } else if (hydrogenList.size() == 2) {
                    Vector2 vector = new Vector2(ligandVector.multiplyBy(-1.0));
                    vector.transformBy(PI120);
                    vectorList.add(new Vector2((Real2)vector));
                    vector.transformBy(PI120);
                    vectorList.add(new Vector2((Real2)vector));
                } else if (hydrogenList.size() == 3) {
                    Vector2 vector = new Vector2((Real2)ligandVector);
                    vectorList.add(new Vector2((Real2)vector));
                    vector.transformBy(PI90);
                    vectorList.add(new Vector2((Real2)vector));
                    vector = new Vector2((Real2)ligandVector);
                    vector.transformBy(PI270);
                    vectorList.add(new Vector2((Real2)vector));
                }
            } else if (ligandList.size() == 2) {
                boolean nearlyLinear;
                Vector2 ligandVector0 = new Vector2(ligandList.get(0).getXY2().subtract(atom.getXY2()));
                ligandVector0 = new Vector2(ligandVector0.getUnitVector());
                Vector2 ligandVector1 = new Vector2(ligandList.get(1).getXY2().subtract(atom.getXY2()));
                ligandVector1 = new Vector2(ligandVector1.getUnitVector());
                Angle angle = ligandVector0.getAngleMadeWith(ligandVector1);
                angle.setRange(Angle.Range.SIGNED);
                Vector2 bisectVector = null;
                boolean bl = nearlyLinear = Math.abs(angle.getRadian()) > 2.827433388230814;
                if (nearlyLinear) {
                    bisectVector = new Vector2(ligandVector0.getUnitVector());
                    bisectVector.transformBy(ROT90);
                    bisectVector.multiplyBy(bondLength);
                } else {
                    bisectVector = new Vector2(ligandVector0.plus((Real2)ligandVector1));
                    bisectVector = new Vector2(bisectVector.getUnitVector());
                    bisectVector = new Vector2(bisectVector.multiplyBy(-bondLength));
                }
                if (hydrogenList.size() == 1) {
                    Vector2 vector = new Vector2((Real2)bisectVector);
                    vector = new Vector2(vector.multiplyBy(1.0));
                    vectorList.add(vector);
                } else if (hydrogenList.size() == 2) {
                    if (nearlyLinear) {
                        vectorList.add(new Vector2((Real2)bisectVector));
                        vectorList.add(new Vector2(bisectVector.multiplyBy(-1.0)));
                    } else {
                        Angle halfAngle = new Angle(1.5707963267948966 - Math.abs(angle.getRadian() * 0.5));
                        Transform2 t2 = new Transform2(halfAngle);
                        Vector2 vector = new Vector2((Real2)bisectVector);
                        vector.transformBy(t2);
                        vectorList.add(vector);
                        t2 = new Transform2(halfAngle.multiplyBy(-1.0));
                        vector = new Vector2((Real2)bisectVector);
                        vector.transformBy(t2);
                        vectorList.add(vector);
                    }
                }
            } else if (ligandList.size() == 3) {
                int i;
                Vector2[] vectors = new Vector2[3];
                Vector2 bisectVector = null;
                for (i = 0; i < 3; ++i) {
                    vectors[i] = new Vector2(ligandList.get(i).getXY2().subtract(atom.getXY2()));
                    bisectVector = bisectVector == null ? vectors[i] : new Vector2(bisectVector.plus((Real2)vectors[i]));
                }
                bisectVector = new Vector2(bisectVector.multiplyBy(-1.0));
                try {
                    bisectVector = new Vector2(bisectVector.getUnitVector().multiplyBy(vectors[0].getLength() * 0.7));
                    for (i = 0; i < 3; ++i) {
                        Angle angle = bisectVector.getAngleMadeWith(vectors[i]);
                        angle.setRange(Angle.Range.SIGNED);
                        double angleR = Math.abs(angle.getRadian());
                        if (!(angleR < 0.2)) continue;
                        bisectVector = new Vector2((Real2)vectors[(i + 1) % 3]);
                        bisectVector = new Vector2(bisectVector.multiplyBy(-1.0));
                        break;
                    }
                }
                catch (EuclidRuntimeException e) {
                    bisectVector = vectors[0];
                    bisectVector = new Vector2((Real2)bisectVector);
                }
                if (hydrogenList.size() == 1) {
                    vectorList.add(new Vector2((Real2)bisectVector));
                }
            }
        }
        return vectorList;
    }

    public static void addCalculated3DCoordinatesForExistingHydrogens(CMLAtom atom) {
        Double length = 1.6;
        if (ChemicalElement.AS.C.equals(atom.getElementType())) {
            length = 1.08;
        } else if (ChemicalElement.AS.N.equals(atom.getElementType())) {
            length = 1.03;
        } else if (ChemicalElement.AS.O.equals(atom.getElementType())) {
            length = 0.96;
        }
        if (length != null) {
            AtomTool.addCalculated3DCoordinatesForExistingHydrogens(atom, length);
            AtomTool.removeHydrogenCountAttribute(atom);
        }
    }

    public static void removeHydrogenCountAttribute(CMLAtom atom) {
        Attribute att = atom.getAttribute("hydrogenCount");
        if (att != null) {
            att.detach();
        }
    }

    public static void addCalculated3DCoordinatesForExistingHydrogens(CMLAtom atom, double length) {
        List<CMLAtom> nonHydrogenLigandList = AtomTool.getNonHydrogenLigandList(atom);
        List<CMLAtom> hydrogenLigandList = AtomTool.getHydrogenLigandList(atom);
        int nonhCount = nonHydrogenLigandList.size();
        int hCount = hydrogenLigandList.size();
        int coordNumber = nonhCount + hCount;
        ArrayList<Vector3> vector3List = new ArrayList();
        if (nonhCount == 0) {
            vector3List = AtomTool.addCoords0(atom, nonHydrogenLigandList, hydrogenLigandList, length);
        } else if (nonhCount == 1) {
            AtomTool.addCoords1(atom, nonHydrogenLigandList, hydrogenLigandList, length);
        } else if (nonhCount == 2) {
            AtomTool.addCoords2(atom, nonHydrogenLigandList, hydrogenLigandList, length);
        } else if (nonhCount == 3) {
            AtomTool.addCoords3(atom, nonHydrogenLigandList, hydrogenLigandList, length);
        }
        AtomTool.addCoords(atom, vector3List, hydrogenLigandList);
    }

    private static List<Vector3> addCoords0(CMLAtom atom, List<CMLAtom> nonHydrogenLigandList, List<CMLAtom> hydrogenLigandList, double length) {
        ArrayList<Vector3> vector3List = new ArrayList<Vector3>();
        Vector3 vector0 = new Vector3(0.0, 0.0, length);
        String elementType = atom.getElementType();
        if (hydrogenLigandList.size() != 0) {
            if (hydrogenLigandList.size() == 1) {
                vector3List.add(vector0);
            } else if (hydrogenLigandList.size() == 2) {
                vector3List.add(vector0);
                double angle = Math.PI;
                if (ChemicalElement.AS.O.equals(elementType)) {
                    angle = 104.0 * DTORAD;
                }
                vector3List.add(new Vector3(0.0, length * Math.sin(angle), length * Math.cos(angle)));
            } else if (hydrogenLigandList.size() == 3) {
                vector3List.add(vector0);
                vector3List.add(new Vector3(0.0, length * COS2PI3, -length * SIN2PI3));
                vector3List.add(new Vector3(0.0, length * COS2PI3, length * SIN2PI3));
            } else if (hydrogenLigandList.size() == 4) {
                vector3List.add(new Vector3(length / ROOT3, length / ROOT3, length / ROOT3));
                vector3List.add(new Vector3(-length / ROOT3, length / ROOT3, -length / ROOT3));
                vector3List.add(new Vector3(length / ROOT3, -length / ROOT3, -length / ROOT3));
                vector3List.add(new Vector3(-length / ROOT3, -length / ROOT3, length / ROOT3));
            }
        }
        return vector3List;
    }

    private static List<Vector3> addCoords1(CMLAtom atom, List<CMLAtom> nonHydrogenLigandList, List<CMLAtom> hydrogenLigandList, double length) {
        List<Vector3> vector3List = new ArrayList<Vector3>();
        String elementType = atom.getElementType();
        CMLAtomSet atomSet = null;
        if (hydrogenLigandList.size() != 0) {
            if (hydrogenLigandList.size() == 1) {
                AtomGeometry atomGeometry = AtomGeometry.LINEAR;
                if (ChemicalElement.AS.O.equals(elementType)) {
                    atomGeometry = AtomGeometry.TETRAHEDRAL;
                }
                if (ChemicalElement.AS.N.equals(elementType)) {
                    atomGeometry = AtomGeometry.TETRAHEDRAL;
                }
                atomSet = AtomTool.calculate3DCoordinatesForLigands(atom, atomGeometry, length, 1.0471975511965979);
            } else if (hydrogenLigandList.size() == 2) {
                atomSet = AtomTool.calculate3DCoordinatesForLigands(atom, AtomGeometry.TRIGONAL, length, 1.0471975511965979);
            } else if (hydrogenLigandList.size() == 3) {
                atomSet = AtomTool.calculate3DCoordinatesForLigands(atom, AtomGeometry.TETRAHEDRAL, length, TETANG0);
            }
        }
        if (atomSet != null) {
            vector3List = AtomTool.getVectorList(atom, atomSet);
        }
        return vector3List;
    }

    private static List<Vector3> addCoords2(CMLAtom atom, List<CMLAtom> nonHydrogenLigandList, List<CMLAtom> hydrogenLigandList, double length) {
        CMLAtomSet atomSet = null;
        List<Vector3> vector3List = new ArrayList<Vector3>();
        if (hydrogenLigandList.size() != 0) {
            if (hydrogenLigandList.size() == 1) {
                atomSet = AtomTool.calculate3DCoordinatesForLigands(atom, AtomGeometry.TRIGONAL, length, 2.0943951023931953);
            } else if (hydrogenLigandList.size() == 2) {
                atomSet = AtomTool.calculate3DCoordinatesForLigands(atom, AtomGeometry.TETRAHEDRAL, length, 2.0 * TETANG);
            }
        }
        if (atomSet != null) {
            vector3List = AtomTool.getVectorList(atom, atomSet);
        }
        return vector3List;
    }

    private static List<Vector3> addCoords3(CMLAtom atom, List<CMLAtom> nonHydrogenLigandList, List<CMLAtom> hydrogenLigandList, double length) {
        List<Vector3> vector3List = new ArrayList<Vector3>();
        CMLAtomSet atomSet = null;
        if (hydrogenLigandList.size() != 0 && hydrogenLigandList.size() == 1) {
            atomSet = AtomTool.calculate3DCoordinatesForLigands(atom, AtomGeometry.TETRAHEDRAL, length, TETANG0);
        }
        if (atomSet != null) {
            vector3List = AtomTool.getVectorList(atom, atomSet);
        }
        return vector3List;
    }

    private static List<Vector3> getVectorList(CMLAtom atom, CMLAtomSet atomSet) {
        ArrayList<Vector3> vectorList = new ArrayList<Vector3>();
        for (CMLAtom atom1 : atomSet.getAtoms()) {
            Point3 xyz31 = atom1.getXYZ3();
            Vector3 vector3 = xyz31.subtract(atom.getXYZ3());
            vectorList.add(vector3);
        }
        return vectorList;
    }

    public static List<CMLAtom> getNonHydrogenLigandList(CMLAtom atom) {
        ArrayList<CMLAtom> newLigandList = new ArrayList<CMLAtom>();
        List ligandList = atom.getLigandAtoms();
        for (CMLAtom ligand : ligandList) {
            if (ChemicalElement.AS.H.equals(ligand.getElementType())) continue;
            newLigandList.add(ligand);
        }
        return newLigandList;
    }

    public static List<CMLAtom> getHydrogenLigandList(CMLAtom atom) {
        List ligands = atom.getLigandAtoms();
        ArrayList<CMLAtom> hatoms = new ArrayList<CMLAtom>();
        for (CMLAtom ligand : ligands) {
            if (!ChemicalElement.AS.H.equals(ligand.getElementType())) continue;
            hatoms.add(ligand);
        }
        return hatoms;
    }

    public static CMLAtomSet calculate3DCoordinatesForLigands(CMLAtom atom, AtomGeometry geometry, double length, double angle) throws RuntimeException {
        Point3 cPoint;
        Point3 bPoint;
        CMLAtomSet noCoordsLigandsAS = new CMLAtomSet();
        if (atom.getX3Attribute() == null) {
            return noCoordsLigandsAS;
        }
        Point3 thisPoint = atom.getXYZ3();
        CMLAtomSet coordsLigandsAS = new CMLAtomSet();
        List ligandList = atom.getLigandAtoms();
        for (CMLAtom ligandAtom : ligandList) {
            if (ligandAtom.getX3Attribute() == null) {
                noCoordsLigandsAS.addAtom(ligandAtom);
                continue;
            }
            coordsLigandsAS.addAtom(ligandAtom);
        }
        int nWithoutCoords = noCoordsLigandsAS.size();
        int nWithCoords = coordsLigandsAS.size();
        if (geometry.equals((Object)AtomGeometry.DEFAULT)) {
            geometry = AtomGeometry.getGeometry(atom.getLigandAtoms().size());
        }
        if (nWithCoords > 3) {
            CMLAtomSet emptyAS = new CMLAtomSet();
            return emptyAS;
        }
        if (nWithoutCoords == 0) {
            return noCoordsLigandsAS;
        }
        ArrayList<Point3> newPoints = null;
        List coordAtoms = coordsLigandsAS.getAtoms();
        List noCoordAtoms = noCoordsLigandsAS.getAtoms();
        if (nWithCoords == 0) {
            newPoints = Molutils.calculate3DCoordinates0((Point3)thisPoint, (int)geometry.getIntValue(), (double)length);
        } else if (nWithCoords == 1) {
            CMLAtom bAtom = (CMLAtom)coordAtoms.get(0);
            Object jAtom = null;
            List bLigandList = bAtom.getLigandAtoms();
            for (CMLAtom cMLAtom : bLigandList) {
            }
            newPoints = Molutils.calculate3DCoordinates1((Point3)thisPoint, (Point3)bAtom.getXYZ3(), (Point3)(jAtom != null ? jAtom.getXYZ3() : null), (int)geometry.getIntValue(), (double)length, (double)angle);
        } else if (nWithCoords == 2) {
            bPoint = ((CMLAtom)coordAtoms.get(0)).getXYZ3();
            cPoint = ((CMLAtom)coordAtoms.get(1)).getXYZ3();
            newPoints = Molutils.calculate3DCoordinates2((Point3)thisPoint, (Point3)bPoint, (Point3)cPoint, (int)geometry.getIntValue(), (double)length, (double)angle);
        } else if (nWithCoords == 3) {
            bPoint = ((CMLAtom)coordAtoms.get(0)).getXYZ3();
            cPoint = ((CMLAtom)coordAtoms.get(1)).getXYZ3();
            Point3 dPoint = ((CMLAtom)coordAtoms.get(2)).getXYZ3();
            newPoints = new ArrayList<Point3>(1);
            newPoints.add(Molutils.calculate3DCoordinates3((Point3)thisPoint, (Point3)bPoint, (Point3)cPoint, (Point3)dPoint, (double)length));
        }
        int np = Math.min(noCoordsLigandsAS.size(), newPoints.size());
        for (int i = 0; i < np; ++i) {
            ((CMLAtom)noCoordAtoms.get(i)).setXYZ3((Point3)newPoints.get(i));
        }
        return noCoordsLigandsAS;
    }
}

