/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;

public class CDXUtil
implements CDXConstants {
    private static Logger LOG = Logger.getLogger(CDXUtil.class);
    private static final String ID_START = "x";

    public static int getUINT8(byte b) {
        return b < 0 ? b + 3840 : b;
    }

    public static byte setUINT8(int l) throws IllegalArgumentException {
        byte bb = (byte)(l > 127 ? l - 256 : l);
        return bb;
    }

    public static int getINT8(byte b) {
        return b;
    }

    public static byte setINT8(int l) throws IllegalArgumentException {
        byte bb = (byte)(l % 256);
        return bb;
    }

    public static int getUINT16(byte[] b) throws IllegalArgumentException {
        return CDXUtil.getUINT16(b, 0);
    }

    public static int getUINT16(byte[] b, int offset) throws IllegalArgumentException {
        if (b.length == offset + 1) {
            return CDXUtil.getUINT8(b[offset]);
        }
        int ii = 0;
        for (int i = 1 + offset; i >= offset; --i) {
            ii *= 256;
            int bb = b[i] < 0 ? b[i] + 256 : b[i];
            ii += bb;
        }
        return ii;
    }

    public static byte[] setUINT16(int l) throws IllegalArgumentException {
        byte[] bb = new byte[2];
        int i = l / 256;
        bb[1] = (byte)(i > 127 ? i - 256 : i);
        bb[0] = (byte)((l %= 256) > 127 ? l - 256 : l);
        return bb;
    }

    static int getINT16(byte[] b) {
        return CDXUtil.getINT16(b, 0);
    }

    static int getINT16(byte[] b, int offset) {
        int sh = CDXUtil.getUINT16(b, offset);
        return sh > 32768 ? sh - 65535 - 1 : sh;
    }

    static int getUINT16(byte b0, byte b1) {
        byte[] bb = new byte[]{b0, b1};
        return CDXUtil.getUINT16(bb);
    }

    static int getINT16(byte b0, byte b1) {
        byte[] bb = new byte[]{b0, b1};
        return CDXUtil.getINT16(bb);
    }

    static long getUINT32(byte[] b, int offset) throws IllegalArgumentException {
        if (b.length == 1 + offset) {
            return CDXUtil.getUINT8(b[offset]);
        }
        if (b.length == 2 + offset) {
            return CDXUtil.getUINT16(b, offset);
        }
        if (b.length < 4 + offset) {
            throw new IllegalArgumentException("getUINT32 arg length: " + b.length + "/" + offset);
        }
        int[] bb = new int[4];
        for (int i = 0; i < 4; ++i) {
            int bbx = b[i + offset];
            bb[i] = bbx < 0 ? bbx + 256 : bbx;
        }
        long ii = bb[0] + 256 * bb[1] + 65536 * bb[2] + 0x1000000 * bb[3];
        return ii;
    }

    static byte[] setUINT32(long l) throws IllegalArgumentException {
        byte[] bb = new byte[4];
        long i = l / 0x1000000L;
        bb[3] = (byte)(i > 127L ? i - 256L : i);
        i = (l %= 0x1000000L) / 65536L;
        bb[2] = (byte)(i > 127L ? i - 256L : i);
        i = (l %= 65536L) / 256L;
        bb[1] = (byte)(i > 127L ? i - 256L : i);
        bb[0] = (byte)((l %= 256L) > 127L ? l - 256L : l);
        return bb;
    }

    static long getUINT32(byte[] b) throws IllegalArgumentException {
        return CDXUtil.getUINT32(b, 0);
    }

    static int getINT32(byte[] b, int offset) {
        long sh = CDXUtil.getUINT32(b, offset);
        return sh > Integer.MIN_VALUE ? (int)(sh - 0x100000000L) : (int)sh;
    }

    static int getINT32(byte[] b) {
        return CDXUtil.getINT32(b, 0);
    }

    static int getINT32(byte b0, byte b1, byte b2, byte b3) {
        byte[] bb = new byte[]{b0, b1, b2, b3};
        return CDXUtil.getINT32(bb);
    }

    static double getFLOAT64(byte[] bytes, int offset) {
        long accum = 0L;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(bytes[offset++] & 0xFF) << shiftBy;
        }
        return Double.longBitsToDouble(accum);
    }

    static byte[] setFLOAT64(double d) {
        long l = Double.doubleToLongBits(d);
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(l % 256L);
            l >>= 8;
        }
        return b;
    }

    static String getEscapedAsciiString(byte[] bytes, int offset) {
        StringBuffer sb = new StringBuffer();
        int ff00 = Integer.parseInt("ff00", 16);
        for (int i = offset; i < bytes.length; ++i) {
            char ch = (char)bytes[i];
            if (Character.isWhitespace(ch) || ch > ' ' && ch < '\u007f') {
                sb.append(ch);
                continue;
            }
            if (ch > ff00) {
                ch = (char)(ch - ff00);
                sb.append("{{" + ch + "}}");
                continue;
            }
            sb.append("{{" + ch + "}}");
        }
        return sb.toString();
    }

    static String getAsciiString(byte[] bytes, int offset) {
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < bytes.length; ++i) {
            char ch = (char)bytes[i];
            if (ch < '\u0000') {
                ch = (char)(ch + 256);
            }
            if (!Character.isWhitespace(ch) && (ch <= ' ' || ch >= '\u007f')) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String trimFloat(double d) {
        StringBuffer sb = new StringBuffer();
        sb.append(d);
        int l = sb.length();
        if (sb.indexOf(".") != -1) {
            while (sb.charAt((l = sb.length()) - 1) == '0') {
                sb.deleteCharAt(l - 1);
            }
            l = sb.length();
            if (sb.charAt(l - 1) == '.') {
                sb.deleteCharAt(l - 1);
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        CDXUtil.testFloat();
    }

    private static void testFloat() {
        double[] d = new double[]{0.0, 10.0, 255.0, 256.0, 1000.0, 100000.0, 0.5, 0.001, -123.45};
        for (int i = 0; i < d.length; ++i) {
            byte[] b = CDXUtil.setFLOAT64(d[i]);
            String s = "" + d[i] + " => ";
            for (int j = 0; j < 8; ++j) {
                String ss = Integer.toHexString(b[j]);
                s = s + " " + (ss.length() == 8 ? ss.substring(6, 8) : ss);
            }
            double dd = CDXUtil.getFLOAT64(b, 0);
            LOG.trace((Object)(s + " => " + dd));
        }
    }

    public static String toXHex(int iProp) {
        return ID_START + Integer.toHexString(iProp);
    }

    public static String ensureXMLID(String value) {
        char c = value.charAt(0);
        if (c != '_' && !Character.isLetter(c)) {
            value = ID_START + value;
        }
        return value;
    }

    public static String ensureNumericID(String value) {
        if (value.startsWith(ID_START)) {
            value = value.substring(1);
        }
        return value;
    }
}

