/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.euclid.Util;

public class CDXText
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXText.class);
    public static final int CODE = 32774;
    public static final String NAME = "Text";
    public static final String CDXNAME = "t";
    private String text = null;

    public CDXText() {
        super(32774, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXText(this);
    }

    public CDXText(CDXText old) {
        super(old);
    }

    static int[] unpackStyleRunString(String s) {
        int[] ii = null;
        if (s != null) {
            String ss = s;
            if (ss.startsWith("[[") && ss.endsWith("]]")) {
                ii = Util.splitToIntArray((String)(ss = ss.substring("[[".length(), ss.length() - "]]".length())), (String)" ");
                if (ii.length != 5) {
                    throw new RuntimeException("Bad font string; " + s);
                }
            } else {
                throw new RuntimeException("Bad font string: " + s);
            }
        }
        return ii;
    }

    static int getFontIndexFromTempText(String s) {
        return CDXText.unpackStyleRunString(s)[1];
    }

    static int getTypeFaceFromTempText(String s) {
        return CDXText.unpackStyleRunString(s)[2];
    }

    static int getSizeFromTempText(String s) {
        return CDXText.unpackStyleRunString(s)[3];
    }

    static int getColorIndexFromTempText(String s) {
        return CDXText.unpackStyleRunString(s)[4];
    }

    public void addFontInfoFromTempText() {
        int idx1;
        String t = this.getAttributeValue("temp_Text");
        if (t != null && !t.equals("") && (idx1 = t.lastIndexOf("]]")) != -1) {
            int idx0 = t.lastIndexOf("]][[");
            t = idx0 == -1 ? t : t.substring(idx0 + "]]".length());
            idx1 = t.lastIndexOf("]]");
            t = t.substring(0, idx1 + "]]".length());
            this.addAttribute(new Attribute("fontIndex", "" + CDXText.getFontIndexFromTempText(t)));
            this.addAttribute(new Attribute("typeFace", "" + CDXText.getTypeFaceFromTempText(t)));
            this.addAttribute(new Attribute("size", "" + CDXText.getSizeFromTempText(t)));
            this.addAttribute(new Attribute("color", "" + CDXText.getColorIndexFromTempText(t)));
        }
    }

    @Override
    public void process2CML(CMLElement cmlNode) {
        this.addLabelToCMLElement(cmlNode);
    }

    String getLabelTextFromTextTempAndSquareBrackets() {
        int idx;
        String vv = this.query("./@temp_Text").get(0).getValue();
        while (vv.startsWith("[[") && (idx = vv.indexOf("]]")) != -1) {
            vv = vv.substring(idx + 2);
        }
        return vv;
    }

    void addLabelToCMLElement(CMLElement element) {
        CMLLabel label = new CMLLabel();
        label.setDictRef("cdx:label");
        String vv = this.getLabelTextFromTextTempAndSquareBrackets();
        this.copyAttributesTo((CMLElement)label);
        label.setCMLValue(vv);
        element.appendChild((Node)label);
    }

    @Override
    public String getString() {
        return "[" + this.text + "]";
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

