/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.components.CDXUtil;

public class CDXRectangle
implements CDXConstants {
    static Logger LOG = Logger.getLogger(CDXRectangle.class);
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int VERTICAL = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int HORIZONTAL = 12;
    public static final int ANYWHERE = 15;
    int x0;
    int x1;
    int y0;
    int y1;
    double xx0;
    double xx1;
    double yy0;
    double yy1;

    public CDXRectangle() {
    }

    public CDXRectangle(String rectS) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(rectS);
        if (st.countTokens() != 4) {
            throw new IllegalArgumentException("Bad rect string: " + rectS);
        }
        try {
            int y0 = Integer.parseInt(st.nextToken());
            int x0 = Integer.parseInt(st.nextToken());
            int y1 = Integer.parseInt(st.nextToken());
            int x1 = Integer.parseInt(st.nextToken());
            this.init(x0, x1, y0, y1);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad rect string: " + rectS);
        }
    }

    public CDXRectangle(int x0, int x1, int y0, int y1) {
        this.init(x0, x1, y0, y1);
    }

    private void init(int x0a, int x1a, int y0a, int y1a) {
        this.x0 = x0a;
        this.x1 = x1a;
        this.y0 = y0a;
        this.y1 = y1a;
        this.yy0 = (double)this.y0 / 65536.0;
        this.yy1 = (double)this.y1 / 65536.0;
        this.xx0 = (double)this.x0 / 65536.0;
        this.xx1 = (double)this.x1 / 65536.0;
        this.xx0 = (double)((int)(10000.0 * this.xx0)) / 10000.0;
        this.xx1 = (double)((int)(10000.0 * this.xx1)) / 10000.0;
        this.yy0 = (double)((int)(10000.0 * this.yy0)) / 10000.0;
        this.yy1 = (double)((int)(10000.0 * this.yy1)) / 10000.0;
    }

    String getAttributeValue() {
        return "" + CDXUtil.trimFloat(this.xx0) + " " + CDXUtil.trimFloat(this.yy0) + " " + CDXUtil.trimFloat(this.xx1) + " " + CDXUtil.trimFloat(this.yy1);
    }

    public String toString() {
        return "" + CDXUtil.trimFloat(this.xx0) + "/" + CDXUtil.trimFloat(this.yy0) + "," + CDXUtil.trimFloat(this.xx1) + "/" + CDXUtil.trimFloat(this.yy1);
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

