/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.chemdraw.components.CDXGraphic;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXUtil;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.element.CMLSpectator;

public class CDXReactionStep
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXReactionStep.class);
    public static final int CODE = 32782;
    public static final String NAME = "ReactionStep";
    public static final String CDXNAME = "step";

    public CDXReactionStep() {
        super(32782, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXReactionStep(this);
    }

    public CDXReactionStep(CDXObject old) {
        super(old);
    }

    void getProductsAndReactants() {
    }

    private String[] processAttributes(String attName) {
        String prefix;
        String[] s = new String[]{};
        String att = this.getAttributeValue(attName);
        String string = prefix = attName.equals("reactionStepArrows") ? "g" : "m";
        if (att != null) {
            int i = 0;
            StringTokenizer st = new StringTokenizer(att, " ");
            s = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                s[i++] = prefix + st.nextToken();
                LOG.info((Object)s[i - 1]);
            }
        }
        return s;
    }

    CMLReaction convertToCMLReaction() {
        CMLReaction reaction = new CMLReaction();
        this.copyAttributesTo((CMLElement)reaction);
        return reaction;
    }

    @Override
    public void process2CML(CMLElement cmlNode) {
        Attribute reactionStepReactants = null;
        Attribute reactionStepProducts = null;
        Attribute reactionStepArrows = null;
        Attribute reactionStepObjectsAboveArrow = null;
        Attribute reactionStepObjectsBelowArrow = null;
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute attribute = this.getAttribute(i);
            if (attribute.getLocalName().equals("ReactionStepReactants")) {
                reactionStepReactants = attribute;
                continue;
            }
            if (attribute.getLocalName().equals("ReactionStepProducts")) {
                reactionStepProducts = attribute;
                continue;
            }
            if (attribute.getLocalName().equals("ReactionStepArrows")) {
                reactionStepArrows = attribute;
                continue;
            }
            if (attribute.getLocalName().equals("ReactionStepObjectsAboveArrow")) {
                reactionStepObjectsAboveArrow = attribute;
                continue;
            }
            if (attribute.getLocalName().equals("ReactionStepObjectsBelowArrow")) {
                reactionStepObjectsBelowArrow = attribute;
                continue;
            }
            if (attribute.getLocalName().equals("ReactionStepPlusses") || attribute.getLocalName().equals("ReactionStepAtomMap") || attribute.getLocalName().equals("ReactionStepAtomMapManual") || attribute.getLocalName().equals("ReactionStepAtomMapAuto")) {
                LOG.error((Object)("Cannot process " + attribute.getLocalName()));
                continue;
            }
            if (attribute.getLocalName().equals("id")) continue;
            throw new RuntimeException("Unknown attribute on step: " + attribute.getLocalName());
        }
        CMLReaction reaction = new CMLReaction();
        cmlNode.appendChild((Node)reaction);
        List<CMLMolecule> reactantMoleculeRefs = this.getMoleculeRefsFromId(reactionStepReactants);
        for (CMLMolecule cMLMolecule : reactantMoleculeRefs) {
            reaction.addReactant(cMLMolecule);
        }
        List<CMLMolecule> productMoleculeRefs = this.getMoleculeRefsFromId(reactionStepProducts);
        for (CMLMolecule productMoleculeRef : productMoleculeRefs) {
            reaction.addProduct(productMoleculeRef);
        }
        CDXGraphic cDXGraphic = this.getArrowsTargetNoop(reactionStepArrows);
        this.addSpectatorRef(reactionStepObjectsAboveArrow, reaction);
        this.addSpectatorRef(reactionStepObjectsBelowArrow, reaction);
    }

    public static void processReactionStep(CMLReaction reaction) {
        CDXReactionStep.resolveRefs(reaction.getReactantList().getMolecules());
        CDXReactionStep.resolveRefs(reaction.getProductList().getMolecules());
        CDXReactionStep.resolveSpectatorRefs(reaction.getSpectatorList().getMolecules());
    }

    private static void resolveRefs(List<CMLMolecule> molecules) {
        for (CMLMolecule molecule : molecules) {
            String ref = molecule.getAttributeValue("ref");
            ref = CDXUtil.ensureNumericID(ref);
            Nodes moleculeNodes = molecule.query("//cml:molecule[@*[local-name()='group' and contains(concat(' ', ., ' '), ' " + ref + " ')]]", CMLConstants.CML_XPATH);
            if (moleculeNodes.size() == 0) {
                LOG.warn((Object)("Cannot find molecule ref: " + ref));
                molecule.setTitle("UNRESOLVED");
                continue;
            }
            CMLElement element = (CMLElement)moleculeNodes.get(0);
            CMLMolecule oldMolecule = (CMLMolecule)element;
            molecule.setTitle("RESOLVED");
        }
    }

    private void addSpectatorRef(Attribute attribute, CMLReaction reaction) {
        String refValue = this.getObjectsTextRef(attribute);
        if (refValue != null) {
            String[] refs;
            for (String ref : refs = refValue.split(" ")) {
                CMLSpectator spectator = new CMLSpectator();
                spectator.addAttribute(new Attribute("ref", ref));
                spectator.addAttribute(new Attribute("type", attribute.getLocalName()));
                reaction.addSpectator(spectator);
            }
        }
    }

    private CDXGraphic getArrowsTargetNoop(Attribute attribute) {
        return null;
    }

    private String getObjectsTextRef(Attribute attribute) {
        return CDXReactionStep.getXMLID(attribute);
    }

    private static void resolveSpectatorRefs(List<CMLMolecule> spectators) {
        for (CMLMolecule spectator : spectators) {
            String ref = CDXUtil.ensureNumericID(spectator.getAttributeValue("ref"));
            String[] refs = ref.split(" ");
            Nodes nodes = spectator.query("//*[@id='" + ref + "']");
            if (nodes.size() == 0) {
                throw new RuntimeException("Cannot find spectator ref: " + ref);
            }
            String text = null;
            if (nodes.get(0) instanceof CMLLabel) {
                CMLLabel label = (CMLLabel)nodes.get(0);
                text = label.getCMLValue();
            }
            spectator.setTitle(text);
        }
    }

    private List<CMLMolecule> getMoleculeRefsFromId(Attribute reactionStepAttribute) {
        String idd = CDXReactionStep.getXMLID(reactionStepAttribute);
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        if (idd != null) {
            String[] ids;
            for (String id : ids = idd.split(" ")) {
                CMLMolecule molecule = new CMLMolecule();
                molecule.setRef(id);
                moleculeList.add(molecule);
            }
        }
        return moleculeList;
    }

    private static String getXMLID(Attribute attribute) {
        return attribute == null ? null : CDXUtil.ensureXMLID(attribute.getValue());
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

