/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.Hashtable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.components.CDXDataType;
import org.xmlcml.cml.chemdraw.components.CDXUtil;
import org.xmlcml.cml.chemdraw.components.IntValue;
import org.xmlcml.cml.chemdraw.components._CDXBoolean;
import org.xmlcml.cml.chemdraw.components._CDXBooleanImplied;
import org.xmlcml.cml.chemdraw.components._CDXColorTable;
import org.xmlcml.cml.chemdraw.components._CDXCoordinate;
import org.xmlcml.cml.chemdraw.components._CDXCurvePoints;
import org.xmlcml.cml.chemdraw.components._CDXDate;
import org.xmlcml.cml.chemdraw.components._CDXElementList;
import org.xmlcml.cml.chemdraw.components._CDXFontStyle;
import org.xmlcml.cml.chemdraw.components._CDXFontTable;
import org.xmlcml.cml.chemdraw.components._CDXObjectID;
import org.xmlcml.cml.chemdraw.components._CDXObjectIDArray;
import org.xmlcml.cml.chemdraw.components._CDXObjectIDArrayWithCounts;
import org.xmlcml.cml.chemdraw.components._CDXPoint2D;
import org.xmlcml.cml.chemdraw.components._CDXPoint3D;
import org.xmlcml.cml.chemdraw.components._CDXRectangle;
import org.xmlcml.cml.chemdraw.components._CDXRepresentsProperty;
import org.xmlcml.cml.chemdraw.components._CDXString;
import org.xmlcml.cml.chemdraw.components._FLOAT64;
import org.xmlcml.cml.chemdraw.components._INT16;
import org.xmlcml.cml.chemdraw.components._INT16ListWithCounts;
import org.xmlcml.cml.chemdraw.components._INT32;
import org.xmlcml.cml.chemdraw.components._INT8;
import org.xmlcml.cml.chemdraw.components._UINT16;
import org.xmlcml.cml.chemdraw.components._UINT32;
import org.xmlcml.cml.chemdraw.components._UINT8;
import org.xmlcml.cml.chemdraw.components._Unformatted;

public class CDXProperty
implements CDXConstants {
    static Logger LOG = Logger.getLogger(CDXProperty.class);
    protected static Hashtable<String, CDXProperty> propTable;
    protected static Hashtable<String, CDXProperty> cdxTable;
    protected int code;
    private String fullName;
    private String cdxName;
    private String alias;
    protected String dataTypeS;
    protected IntValue[] enumeration;
    protected Double scale = null;
    protected byte[] bytes;
    protected CDXDataType dataType;

    static void makeProperty(int code, String fullName, String cdxName, String dataTypeS) {
        CDXProperty prop = new CDXProperty(code, fullName, cdxName, dataTypeS);
        CDXProperty.createAndIndex(prop);
    }

    static void makeProperty(int code, String fullName, String cdxName, String dataTypeS, IntValue[] enumeration, String alias) {
        CDXProperty prop = new CDXProperty(code, fullName, cdxName, dataTypeS);
        prop.setEnumeration(enumeration);
        if (alias != null && !alias.equals("")) {
            prop.setAlias(alias);
        }
        CDXProperty.createAndIndex(prop);
    }

    static void makeProperty(int code, String fullName, String cdxName, String dataTypeS, Double scale) {
        CDXProperty prop = new CDXProperty(code, fullName, cdxName, dataTypeS);
        prop.setScale(scale);
        CDXProperty.createAndIndex(prop);
    }

    static void makeProperty(int code, String fullName, String cdxName, String dataTypeS, IntValue[] enumeration) {
        CDXProperty.makeProperty(code, fullName, cdxName, dataTypeS, enumeration, "");
    }

    static void createAndIndex(CDXProperty prop) {
        propTable.put("" + prop.code, prop);
        if (cdxTable == null) {
            cdxTable = new Hashtable();
        }
        cdxTable.put(prop.getCDXName(), prop);
    }

    public CDXProperty() {
    }

    public CDXProperty(CDXProperty prop) {
        this(prop.code, prop.fullName, prop.cdxName, prop.dataTypeS);
        this.enumeration = prop.enumeration;
        this.scale = prop.scale;
        this.alias = prop.alias;
    }

    public CDXProperty(int code, String name, String cdxName, String dataTypeS) {
        this.init(code, name, cdxName, dataTypeS);
    }

    private void init(int code, String name, String cdxName, String dataTypeS) {
        this.code = code;
        this.fullName = name;
        this.cdxName = cdxName;
        this.dataTypeS = dataTypeS;
    }

    private static CDXProperty getProperty(String propS) {
        return propTable.get(propS);
    }

    private static CDXProperty getPropertyByCDXName(String cdxName) {
        return cdxTable.get(cdxName);
    }

    static CDXProperty createProperty(String propS) {
        CDXProperty prop = CDXProperty.getProperty(propS);
        return prop == null ? null : new CDXProperty(prop);
    }

    static CDXProperty createPropertyByCDXName(String cdxName) {
        CDXProperty prop = CDXProperty.getPropertyByCDXName(cdxName);
        return new CDXProperty(prop);
    }

    String getDataTypeString() {
        return this.dataType == null ? null : this.dataType.toString();
    }

    void substituteValues() {
        if (this.cdxName.equals("DoublePosition")) {
            // empty if block
        }
        if (this.enumeration != null) {
            if (this.dataType.num == null || !(this.dataType.num instanceof Integer)) {
                LOG.error((Object)"Expected integer value");
            } else {
                int idx = (Integer)this.dataType.num;
                String newValue = null;
                for (int i = 0; i < this.enumeration.length; ++i) {
                    if (this.enumeration[i].ii != idx) continue;
                    newValue = this.enumeration[i].s;
                    break;
                }
                if (newValue == null) {
                    LOG.error((Object)("Cannot find enum: " + idx + " for " + this.cdxName));
                } else {
                    this.dataType.s = newValue;
                    LOG.debug((Object)("enum: " + newValue));
                }
            }
        } else if (this.scale != null) {
            double ss = this.scale;
            if (this.dataType.num == null) {
                LOG.error((Object)"Expected number for scale");
            } else if (this.dataType.num instanceof Integer) {
                Integer ii = (Integer)this.dataType.num;
                int is = ii;
                this.dataType.num = (int)((double)is * ss);
                this.dataType.s = "" + ii;
            } else if (this.dataType.num instanceof Long) {
                Long ll = (Long)this.dataType.num;
                long ls = ll;
                this.dataType.num = (long)((double)ls * ss);
                this.dataType.s = "" + ll;
            } else if (this.dataType.num instanceof Double) {
                Double dd = (Double)this.dataType.num;
                double dx = dd;
                this.dataType.num = dx * ss;
                this.dataType.s = "" + dx;
            }
        }
    }

    public void processAlias() {
        if (this.alias != null) {
            this.cdxName = this.alias;
        }
    }

    String setBytes(byte[] bytes) {
        if (this.dataTypeS.equals("CDXBoolean")) {
            this.dataType = new _CDXBoolean(bytes, this);
        } else if (this.dataTypeS.equals("CDXBooleanImplied")) {
            this.dataType = new _CDXBooleanImplied(bytes, this);
        } else if (this.dataTypeS.equals("CDXCurvePoints")) {
            this.dataType = new _CDXCurvePoints(bytes, this);
        } else if (this.dataTypeS.equals("CDXColorTable")) {
            this.dataType = new _CDXColorTable(bytes, this);
        } else if (this.dataTypeS.equals("CDXCoordinate")) {
            this.dataType = new _CDXCoordinate(bytes, this);
        } else if (this.dataTypeS.equals("CDXDate")) {
            this.dataType = new _CDXDate(bytes, this);
        } else if (this.dataTypeS.equals("CDXElementList")) {
            this.dataType = new _CDXElementList(bytes, this);
        } else if (this.dataTypeS.equals("CDXFontStyle")) {
            this.dataType = new _CDXFontStyle(bytes, this);
        } else if (this.dataTypeS.equals("CDXFontTable")) {
            this.dataType = new _CDXFontTable(bytes, this);
        } else if (this.dataTypeS.equals("CDXObjectID")) {
            this.dataType = new _CDXObjectID(bytes, this);
        } else if (this.dataTypeS.equals("CDXObjectIDArray")) {
            this.dataType = new _CDXObjectIDArray(bytes, this);
        } else if (this.dataTypeS.equals("CDXObjectIDArrayWithCounts")) {
            this.dataType = new _CDXObjectIDArrayWithCounts(bytes, this);
        } else if (this.dataTypeS.equals("CDXPoint2D")) {
            this.dataType = new _CDXPoint2D(bytes, this);
        } else if (this.dataTypeS.equals("CDXPoint3D")) {
            this.dataType = new _CDXPoint3D(bytes, this);
        } else if (this.dataTypeS.equals("CDXRectangle")) {
            this.dataType = new _CDXRectangle(bytes, this);
        } else if (this.dataTypeS.equals("CDXRepresentsProperty")) {
            this.dataType = new _CDXRepresentsProperty(bytes, this);
        } else if (this.dataTypeS.equals("CDXString")) {
            this.dataType = new _CDXString(bytes, this);
        } else if (this.dataTypeS.equals("FLOAT64")) {
            this.dataType = new _FLOAT64(bytes, this);
        } else if (this.dataTypeS.equals("INT8")) {
            this.dataType = new _INT8(bytes, this);
        } else if (this.dataTypeS.equals("INT16")) {
            this.dataType = new _INT16(bytes, this);
        } else if (this.dataTypeS.equals("INT16ListWithCounts")) {
            this.dataType = new _INT16ListWithCounts(bytes, this);
        } else if (this.dataTypeS.equals("INT32")) {
            this.dataType = new _INT32(bytes, this);
        } else if (this.dataTypeS.equals("UINT8")) {
            this.dataType = new _UINT8(bytes, this);
        } else if (this.dataTypeS.equals("UINT16")) {
            this.dataType = new _UINT16(bytes, this);
        } else if (this.dataTypeS.equals("UINT32")) {
            this.dataType = new _UINT32(bytes, this);
        } else if (this.dataTypeS.equals("Unformatted")) {
            this.dataType = new _Unformatted(bytes, this);
        } else {
            throw new RuntimeException("Unknown data type: " + this.dataTypeS);
        }
        String ss = this.dataType.toString();
        LOG.debug((Object)(">" + ss));
        return ss;
    }

    public String getCDXName() {
        String nn = this.cdxName.equals("not used") ? this.fullName : this.cdxName;
        return nn;
    }

    void setNames(String name) {
        this.cdxName = name;
        this.fullName = name;
    }

    void setValue(String s) {
        if (this.dataTypeS.equals("CDXString")) {
            this.setBytes(s.getBytes());
        } else if (this.dataTypeS.equals("Unformatted")) {
            this.setBytes(s.getBytes());
        } else {
            throw new RuntimeException("Cannot set string value for property with dataType: " + this.dataTypeS);
        }
    }

    void setValue(int i) {
        byte[] bb;
        if (this.dataTypeS.equals("UINT8")) {
            bb = new byte[]{CDXUtil.setUINT8(i)};
        } else if (this.dataTypeS.equals("UINT16")) {
            bb = CDXUtil.setUINT16(i);
        } else {
            throw new RuntimeException("Cannot set int value for property with dataType: " + this.dataTypeS);
        }
        this.setBytes(bb);
    }

    void setValue(long l) {
        byte[] bb;
        if (this.dataTypeS.equals("UINT32")) {
            bb = CDXUtil.setUINT32(l);
        } else if (this.dataTypeS.equals("CDXObjectID")) {
            bb = CDXUtil.setUINT32(l);
        } else {
            throw new RuntimeException("Cannot set long value for property with dataType: " + this.dataTypeS);
        }
        this.setBytes(bb);
    }

    void setValue(double d) {
        if (!this.dataTypeS.equals("FLOAT64")) {
            throw new RuntimeException("Cannot set double value for property with dataType: " + this.dataTypeS);
        }
        byte[] bb = CDXUtil.setFLOAT64(d);
        this.setBytes(bb);
    }

    private void setScale(Double scale) {
        this.scale = scale;
    }

    private void setAlias(String alias) {
        this.alias = alias;
    }

    private void setEnumeration(IntValue[] e) {
        this.enumeration = new IntValue[e.length];
        for (int i = 0; i < e.length; ++i) {
            this.enumeration[i] = new IntValue(e[i]);
        }
    }

    public String toString() {
        return this.getCDXName();
    }

    static void makeProperties() {
        if (propTable == null) {
            propTable = new Hashtable();
            CDXProperty.makeProperties0();
        }
    }

    private static void makeProperties0() {
        CDXProperty.makeProperty(0, "EndObject", "EndObject", "CDXString");
        CDXProperty.makeProperty(1, "CreationUserName", "CreationUserName", "CDXString");
        CDXProperty.makeProperty(2, "CreationDate", "CreationDate", "CDXDate");
        CDXProperty.makeProperty(3, "CreationProgram", "CreationProgram", "CDXString");
        CDXProperty.makeProperty(4, "ModificationUserName", "ModificationUserName", "CDXString");
        CDXProperty.makeProperty(5, "ModificationDate", "ModificationDate", "CDXDate");
        CDXProperty.makeProperty(6, "ModificationProgram", "ModificationProgram", "CDXString");
        CDXProperty.makeProperty(8, "Name", "Name", "CDXString");
        CDXProperty.makeProperty(9, "Comment", "Comment", "CDXString");
        CDXProperty.makeProperty(10, "ZOrder", "Z", "INT16");
        CDXProperty.makeProperty(11, "RegistryNumber", "RegistryNumber", "CDXString");
        CDXProperty.makeProperty(12, "RegistryAuthority", "RegistryAuthority", "CDXString");
        CDXProperty.makeProperty(14, "RepresentsProperty", "RepresentsProperty", "CDXRepresentsProperty");
        CDXProperty.makeProperty(15, "IgnoreWarnings", "IgnoreWarnings", "CDXBooleanImplied");
        CDXProperty.makeProperty(16, "ChemicalWarning", "Warning", "CDXString");
        CDXProperty.makeProperty(17, "Visible", "Visible", "CDXBoolean");
        CDXProperty.makeProperty(18, "SupersededBy", "SupersededBy", "CDXString");
        CDXProperty.makeProperty(19, "Unknown13", "Unknopwn13", "CDXString");
        CDXProperty.makeProperty(256, "FontTable", "fonttable", "CDXFontTable");
        CDXProperty.makeProperty(512, "2DPosition", "p", "CDXPoint2D");
        CDXProperty.makeProperty(513, "3DPosition", "xyz", "CDXPoint3D");
        CDXProperty.makeProperty(514, "2DExtent", "extent", "CDXPoint2D");
        CDXProperty.makeProperty(515, "3DExtent", "extent3D", "CDXPoint3D");
        CDXProperty.makeProperty(516, "BoundingBox", "BoundingBox", "CDXRectangle");
        CDXProperty.makeProperty(517, "RotationAngle", "RotationAngle", "INT32", 1.52587890625E-5);
        CDXProperty.makeProperty(518, "BoundsInParent", "BoundsInParent", "CDXRectangle");
        CDXProperty.makeProperty(519, "3DHead", "Head3D", "CDXPoint3D");
        CDXProperty.makeProperty(520, "3DTail", "Tail3D", "CDXPoint3D");
        CDXProperty.makeProperty(521, "TopLeft", "TopLeft", "CDXPoint2D");
        CDXProperty.makeProperty(522, "TopRight", "TopRight", "CDXPoint2D");
        CDXProperty.makeProperty(523, "BottomRight", "BottomRight", "CDXPoint2D");
        CDXProperty.makeProperty(524, "BottomLeft", "BottomLeft", "CDXPoint2D");
        CDXProperty.makeProperty(525, "3DCenter", "Center3D", "CDXPoint3D");
        CDXProperty.makeProperty(526, "3DMajorAxisEnd", "MajorAxisEnd3D", "CDXPoint3D");
        CDXProperty.makeProperty(527, "3DMinorAxisEnd", "MinorAxisEnd3D", "CDXPoint3D");
        CDXProperty.makeProperty(768, "ColorTable", "colortable", "CDXColorTable");
        CDXProperty.makeProperty(769, "ForegroundColor", "color", "UINT16");
        CDXProperty.makeProperty(770, "BackgroundColor", "bgcolor", "INT16");
        IntValue[] NODE_TABLE = new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "Element"), new IntValue(2, "ElementList"), new IntValue(3, "ElementListNickname"), new IntValue(4, "Nickname"), new IntValue(5, "Fragment"), new IntValue(6, "Formula"), new IntValue(7, "GenericNickname"), new IntValue(8, "AnonymousAlternativeGroup"), new IntValue(9, "NamedAlternativeGroup"), new IntValue(10, "MultiAttachment"), new IntValue(11, "VariableAttachment"), new IntValue(12, "ExternalConnectionPoint"), new IntValue(13, "LinkNode")};
        CDXProperty.makeProperty(1024, "Node_Table", "NodeTable", "INT16", NODE_TABLE, "NodeType");
        IntValue[] LABEL_TABLE = new IntValue[]{new IntValue(0, "Auto"), new IntValue(1, "Left"), new IntValue(2, "Center"), new IntValue(3, "Right"), new IntValue(4, "Above"), new IntValue(5, "Below")};
        CDXProperty.makeProperty(1025, "Node_LabelDisplay", "LabelDisplay", "INT8", LABEL_TABLE);
        CDXProperty.makeProperty(1026, "Node_Element", "Element", "INT16");
        CDXProperty.makeProperty(1027, "Atom_ElementList", "ElementList", "CDXElementList");
        CDXProperty.makeProperty(1028, "Atom_Formula", "Formula", "CDXFormula");
        CDXProperty.makeProperty(1056, "Atom_Isotope", "Isotope", "INT16");
        CDXProperty.makeProperty(1057, "Atom_Charge", "Charge", "INT8");
        CDXProperty.makeProperty(1058, "Atom_Radical", "Radical", "UINT8", new IntValue[]{new IntValue(0, "None"), new IntValue(1, "Singlet"), new IntValue(2, "Doublet"), new IntValue(3, "Triplet")});
        CDXProperty.makeProperty(1059, "Atom_RestrictFreeSites", "FreeSites", "UINT8");
        CDXProperty.makeProperty(1060, "Atom_RestrictImplicitHydrogens", "ImplicitHydrogens", "CDXBooleanImplied");
        CDXProperty.makeProperty(1061, "Atom_RestrictRingBondCount", "RingBondCount", "INT8", new IntValue[]{new IntValue(-1, "Unspecified"), new IntValue(0, "NoRingBonds"), new IntValue(1, "AsDrawn"), new IntValue(2, "SimpleRing"), new IntValue(3, "Fusion"), new IntValue(3, "Fusion")});
        CDXProperty.makeProperty(1062, "Atom_RestrictUnsaturatedBonds", "UnsaturatedBonds", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "MustBeAbsent"), new IntValue(2, "MustBePresent")});
        CDXProperty.makeProperty(1063, "Atom_RestrictRxnChange", "RxnChange", "CDXBooleanImplied");
        CDXProperty.makeProperty(1064, "Atom_RestrictRxnStereo", "RxnStereo", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "Inversion"), new IntValue(2, "Retention")});
        CDXProperty.makeProperty(1065, "Atom_AbnormalValence", "AbnormalValence", "CDXBooleanImplied");
        CDXProperty.makeProperty(1067, "Atom_NumHydrogens", "NumHydrogens", "UINT16");
        CDXProperty.makeProperty(1070, "Atom_HDot", "HDot", "CDXBooleanImplied");
        CDXProperty.makeProperty(1071, "Atom_HDash", "HDash", "CDXBooleanImplied");
        CDXProperty.makeProperty(1072, "Atom_Geometry", "Geometry", "INT8", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "1"), new IntValue(2, "Linear"), new IntValue(3, "Bent"), new IntValue(4, "TrigonalPlanar"), new IntValue(5, "TrigonalPyramidal"), new IntValue(6, "SquarePlanar"), new IntValue(7, "Tetrahedral"), new IntValue(8, "TrigonalBipyramidal"), new IntValue(9, "SquarePyramidal"), new IntValue(10, "5"), new IntValue(11, "Octahedral"), new IntValue(12, "6"), new IntValue(13, "7"), new IntValue(14, "8"), new IntValue(15, "9"), new IntValue(16, "10")});
        CDXProperty.makeProperty(1073, "Atom_BondOrdering", "BondOrdering", "CDXObjectIDArray");
        CDXProperty.makeProperty(1074, "Node_Attachments", "Attachments", "CDXObjectIDArrayWithCounts");
        CDXProperty.makeProperty(1075, "Atom_GenericNickname", "GenericNickname", "CDXString");
        CDXProperty.makeProperty(1076, "Atom_AltGroupID", "AltGroupID", "CDXObjectID");
        CDXProperty.makeProperty(1077, "Atom_RestrictSubstituentsUpTo", "SubstituentsUpTo", "UINT8");
        CDXProperty.makeProperty(1078, "Atom_RestrictSubstituentsExactly", "SubstituentsExactly", "UINT8");
        CDXProperty.makeProperty(1079, "Atom_CIPStereochemistry", "AS", "INT8", new IntValue[]{new IntValue(0, "U"), new IntValue(1, "N"), new IntValue(2, "R"), new IntValue(3, "S"), new IntValue(4, "r"), new IntValue(5, "s"), new IntValue(6, "u")});
        CDXProperty.makeProperty(1080, "Atom_Translation", "Translation", "INT8", new IntValue[]{new IntValue(0, "Equal"), new IntValue(1, "Broad"), new IntValue(2, "Narrow"), new IntValue(3, "Any")});
        CDXProperty.makeProperty(1081, "Atom_AtomNumber", "AtomNumber", "CDXString");
        CDXProperty.makeProperty(1082, "Atom_ShowQuery", "ShowAtomQuery", "CDXBoolean");
        CDXProperty.makeProperty(1083, "Atom_ShowStereo", "ShowAtomStereo", "CDXBoolean");
        CDXProperty.makeProperty(1084, "Atom_ShowAtomNumber", "ShowAtomNumber", "CDXBoolean");
        CDXProperty.makeProperty(1085, "Atom_LinkCountLow", "LinkCountLow", "INT16");
        CDXProperty.makeProperty(1086, "Atom_LinkCountHigh", "LinkCountHigh", "INT16");
        CDXProperty.makeProperty(1087, "Atom_IsotopicAbundance", "IsotopicAbundance", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "Any"), new IntValue(2, "Natural"), new IntValue(3, "Enriched"), new IntValue(4, "Deficient")});
        CDXProperty.makeProperty(1088, "Atom_ExternalConnectionType", "ExternalConnectionType", "INT8");
        CDXProperty.makeProperty(1089, "Atom_GenericList", "GenericList", "CDXGenericList");
        CDXProperty.makeProperty(1090, "Atom_ShowTerminalCarbonLabels", "ShowTerminalCarbonLabels", "CDXBooleanImplied");
        CDXProperty.makeProperty(1091, "Atom_ShowNonTerminalCarbonLabels", "ShowNonTerminalCarbonLabels", "CDXBooleanImplied");
        CDXProperty.makeProperty(1092, "Atom_HideImplicitHydrogens", "HideImplicitHydrogens", "CDXBooleanImplied");
        CDXProperty.makeProperty(1093, "Atom_ShowEnhancedStereo", "ShowAtomEnhancedStereo", "CDXBoolean");
        CDXProperty.makeProperty(1094, "Atom_EnhancedStereoType", "EnhancedStereoType", "UINT8");
        CDXProperty.makeProperty(1095, "Atom_EnhancedStereoGroupNum", "EnhancedStereoGroupNum", "UINT16");
        CDXProperty.makeProperty(1096, "NewProp448", "NewProp448", "Unformatted");
        CDXProperty.makeProperty(1280, "Mole_Racemic", "Racemic", "CDXBoolean");
        CDXProperty.makeProperty(1281, "Mole_Absolute", "Absolute", "CDXBoolean");
        CDXProperty.makeProperty(1282, "Mole_Relative", "Relative", "CDXBoolean");
        CDXProperty.makeProperty(1283, "Mole_Formula", "Formula", "CDXFormula");
        CDXProperty.makeProperty(1284, "Mole_Weight", "Weight", "FLOAT64");
        CDXProperty.makeProperty(1285, "Frag_ConnectionOrder", "ConnectionOrder", "CDXObjectIDArray");
        CDXProperty.makeProperty(1536, "Bond_Order", "Order", "INT16", new IntValue[]{new IntValue(65535, "Unspecified"), new IntValue(1, "1"), new IntValue(2, "2"), new IntValue(4, "3"), new IntValue(8, "4"), new IntValue(16, "5"), new IntValue(32, "6"), new IntValue(64, "0.5"), new IntValue(128, "1.5"), new IntValue(256, "2.5"), new IntValue(512, "3.5"), new IntValue(1024, "4.5"), new IntValue(2048, "5.5"), new IntValue(4096, "dative"), new IntValue(8192, "ionic"), new IntValue(16384, "hydrogen"), new IntValue(32768, "threecenter")});
        CDXProperty.makeProperty(1537, "Bond_Display", "Display", "INT16", new IntValue[]{new IntValue(0, "Solid"), new IntValue(1, "Dash"), new IntValue(2, "Hash"), new IntValue(3, "WedgedHashBegin"), new IntValue(4, "WedgedHashEnd"), new IntValue(5, "Bold"), new IntValue(6, "WedgeBegin"), new IntValue(7, "WedgeEnd"), new IntValue(8, "Wavy"), new IntValue(9, "HollowWedgeBegin"), new IntValue(10, "HollowWedgeEnd"), new IntValue(11, "WavyWedgeBegin"), new IntValue(12, "WavyWedgeEnd"), new IntValue(13, "Dot"), new IntValue(14, "DashDot")});
        CDXProperty.makeProperty(1538, "Bond_Display2", "Display2", "INT8", new IntValue[]{new IntValue(0, "Solid"), new IntValue(1, "Dash"), new IntValue(2, "Hash"), new IntValue(3, "WedgedHashBegin"), new IntValue(4, "WedgedHashEnd"), new IntValue(5, "Bold"), new IntValue(6, "WedgeBegin"), new IntValue(7, "WedgeEnd"), new IntValue(8, "Wavy"), new IntValue(9, "HollowWedgeBegin"), new IntValue(10, "HollowWedgeEnd"), new IntValue(11, "WavyWedgeBegin"), new IntValue(12, "WavyWedgeEnd"), new IntValue(13, "Dot"), new IntValue(14, "DashDot")});
        CDXProperty.makeProperty(1539, "Bond_DoublePosition", "DoublePosition", "INT16", new IntValue[]{new IntValue(0, "Center"), new IntValue(1, "Right"), new IntValue(2, "Left"), new IntValue(256, "Center"), new IntValue(257, "Right"), new IntValue(258, "Left")});
        CDXProperty.makeProperty(1540, "Bond_Begin", "B", "CDXObjectID");
        CDXProperty.makeProperty(1541, "Bond_End", "E", "CDXObjectID");
        CDXProperty.makeProperty(1542, "Bond_RestrictTopology", "Topology", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "Ring"), new IntValue(2, "Chain"), new IntValue(3, "RingOrChain")});
        CDXProperty.makeProperty(1543, "Bond_RestrictRxnParticipation", "RxnParticipation", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "ReactionCenter"), new IntValue(2, "MakeOrBreak"), new IntValue(3, "ChangeType"), new IntValue(4, "MakeAndChange"), new IntValue(5, "NotReactionCenter"), new IntValue(6, "NoChange"), new IntValue(7, "Unmapped")});
        CDXProperty.makeProperty(1544, "Bond_BeginAttach", "BeginAttach", "UINT8");
        CDXProperty.makeProperty(1545, "Bond_EndAttach", "EndAttach", "UINT8");
        CDXProperty.makeProperty(1546, "Bond_CIPStereochemistry", "BS", "INT8", new IntValue[]{new IntValue(0, "U"), new IntValue(1, "N"), new IntValue(2, "E"), new IntValue(3, "Z")});
        CDXProperty.makeProperty(1547, "Bond_BondOrdering", "BondCircularOrdering", "CDXObjectIDArray");
        CDXProperty.makeProperty(1548, "Bond_ShowQuery", "ShowBondQuery", "CDXBoolean");
        CDXProperty.makeProperty(1549, "Bond_ShowStereo", "ShowBondStereo", "CDXBoolean");
        CDXProperty.makeProperty(1550, "Bond_CrossingBonds", "CrossingBonds", "CDXObjectIDArray");
        CDXProperty.makeProperty(1551, "Bond_ShowRxn", "ShowBondRxn", "CDXBoolean");
        CDXProperty.makeProperty(1792, "Text", "temp_Text", "CDXString");
        CDXProperty.makeProperty(1793, "Justification", "Justification", "INT8", new IntValue[]{new IntValue(-1, "Right"), new IntValue(0, "Left"), new IntValue(1, "Center"), new IntValue(2, "Full"), new IntValue(3, "Above"), new IntValue(4, "Below"), new IntValue(5, "Auto")});
        CDXProperty.makeProperty(1794, "LineHeight", "LineHeight", "UINT16");
        CDXProperty.makeProperty(1795, "WordWrapWidth", "WordWrapWidth", "INT16");
        CDXProperty.makeProperty(1796, "LineStarts", "LineStarts", "INT16ListWithCounts");
        CDXProperty.makeProperty(1797, "LabelAlignment", "LabelAlignment", "INT8", new IntValue[]{new IntValue(0, "Auto"), new IntValue(1, "Left"), new IntValue(2, "Center"), new IntValue(3, "Right"), new IntValue(4, "Above"), new IntValue(5, "Below"), new IntValue(6, "Best")});
        CDXProperty.makeProperty(1798, "LabelLineHeight", "LabelLineHeight", "INT16");
        CDXProperty.makeProperty(1799, "CaptionLineHeight", "CaptionLineHeight", "INT16");
        CDXProperty.makeProperty(1800, "InterpretChemically", "InterpretChemically", "CDXBoolean");
        CDXProperty.makeProperty(2048, "MacPrintInfo", "MacPrintInfo", "Unformatted");
        CDXProperty.makeProperty(2049, "WinPrintInfo", "WinPrintInfo", "Unformatted");
        CDXProperty.makeProperty(2050, "PrintMargins", "PrintMargins", "CDXRectangle");
        CDXProperty.makeProperty(2051, "ChainAngle", "ChainAngle", "INT32", 1.52587890625E-5);
        CDXProperty.makeProperty(2052, "BondSpacing", "BondSpacing", "INT16", 0.1);
        CDXProperty.makeProperty(2053, "BondLength", "BondLength", "CDXCoordinate");
        CDXProperty.makeProperty(2054, "BoldWidth", "BoldWidth", "CDXCoordinate");
        CDXProperty.makeProperty(2055, "LineWidth", "LineWidth", "CDXCoordinate");
        CDXProperty.makeProperty(2056, "MarginWidth", "MarginWidth", "CDXCoordinate");
        CDXProperty.makeProperty(2057, "HashSpacing", "HashSpacing", "CDXCoordinate");
        CDXProperty.makeProperty(2058, "LabelStyle", "LabelStyle", "CDXFontStyle");
        CDXProperty.makeProperty(2059, "CaptionStyle", "CaptionStyle", "CDXFontStyle");
        CDXProperty.makeProperty(2060, "CaptionJustification", "CaptionJustification", "INT8", new IntValue[]{new IntValue(-1, "Right"), new IntValue(0, "Left"), new IntValue(1, "Center"), new IntValue(2, "Full"), new IntValue(3, "Above"), new IntValue(4, "Below"), new IntValue(5, "Auto")});
        CDXProperty.makeProperty(2061, "FractionalWidths", "FractionalWidths", "CDXBooleanImplied");
        CDXProperty.makeProperty(2062, "Magnification", "Magnification", "INT16", 0.1);
        CDXProperty.makeProperty(2063, "WidthPages", "WidthPages", "INT16");
        CDXProperty.makeProperty(2064, "HeightPages", "HeightPages", "INT16");
        CDXProperty.makeProperty(2065, "DrawingSpaceTable", "DrawingSpace", "INT8", new IntValue[]{new IntValue(0, "Pages"), new IntValue(1, "Poster")}, "DrawingSpaceType");
        CDXProperty.makeProperty(2066, "DrawingSpaceWidth", "Width", "CDXCoordinate");
        CDXProperty.makeProperty(2067, "DrawingSpaceHeight", "Height", "CDXCoordinate");
        CDXProperty.makeProperty(2068, "PageOverlap", "PageOverlap", "CDXCoordinate");
        CDXProperty.makeProperty(2069, "Header", "Header", "CDXString");
        CDXProperty.makeProperty(2070, "HeaderPosition", "HeaderPosition", "CDXCoordinate");
        CDXProperty.makeProperty(2071, "Footer", "Footer", "CDXString");
        CDXProperty.makeProperty(2072, "FooterPosition", "FooterPosition", "CDXCoordinate");
        CDXProperty.makeProperty(2073, "PrintTrimMarks", "PrintTrimMarks", "CDXBooleanImplied");
        CDXProperty.makeProperty(2074, "LabelStyleFont", "LabelFont", "INT16");
        CDXProperty.makeProperty(2075, "CaptionStyleFont", "CaptionFont", "INT16");
        CDXProperty.makeProperty(2076, "LabelStyleSize", "LabelSize", "INT16");
        CDXProperty.makeProperty(2077, "CaptionStyleSize", "CaptionSize", "INT16");
        CDXProperty.makeProperty(2078, "LabelStyleFace", "LabelFace", "INT16");
        CDXProperty.makeProperty(2079, "CaptionStyleFace", "CaptionFace", "INT16");
        CDXProperty.makeProperty(2080, "LabelStyleColor", "LabelColor", "INT16");
        CDXProperty.makeProperty(2081, "CaptionStyleColor", "CaptionColor", "INT16");
        CDXProperty.makeProperty(2082, "BondSpacingAbs", "BondSpacingAbs", "CDXCoordinate");
        CDXProperty.makeProperty(2083, "LabelJustification", "LabelJustification", "INT8", new IntValue[]{new IntValue(-1, "Right"), new IntValue(0, "Left"), new IntValue(1, "Center"), new IntValue(2, "Full"), new IntValue(3, "Above"), new IntValue(4, "Below"), new IntValue(5, "Auto")});
        CDXProperty.makeProperty(2084, "FixInplaceExtent", "FixInPlaceExtent", "CDXPoint2D");
        CDXProperty.makeProperty(2085, "Side", "Side", "UINT16", new IntValue[]{new IntValue(0, "undefined"), new IntValue(1, "top"), new IntValue(2, "left"), new IntValue(3, "bottom"), new IntValue(4, "right")});
        CDXProperty.makeProperty(2086, "FixInplaceGap", "FixInPlaceGap", "CDXPoint2D");
        CDXProperty.makeProperty(2087, "CartridgeData", "CartridgeData", "Unformatted");
        CDXProperty.makeProperty(2088, "NewProp828", "NewProp828", "Unformatted");
        CDXProperty.makeProperty(2089, "NewProp829", "NewProp829", "Unformatted");
        CDXProperty.makeProperty(2090, "NewProp82a", "NewProp82a", "Unformatted");
        CDXProperty.makeProperty(2304, "Window_IsZoomed", "WindowIsZoomed", "CDXBooleanImplied");
        CDXProperty.makeProperty(2305, "Window_Position", "WindowPosition", "CDXPoint2D");
        CDXProperty.makeProperty(2306, "Window_Size", "WindowSize", "CDXPoint2D");
        CDXProperty.makeProperty(2560, "Graphic_Table", "GraphicTable", "INT16", new IntValue[]{new IntValue(0, "Undefined"), new IntValue(1, "Line"), new IntValue(2, "Arc"), new IntValue(3, "Rectangle"), new IntValue(4, "Oval"), new IntValue(5, "Orbital"), new IntValue(6, "Bracket"), new IntValue(7, "Symbol")}, "GraphicType");
        CDXProperty.makeProperty(2561, "Line_Table", "LineTable", "INT8", new IntValue[]{new IntValue(0, "Solid"), new IntValue(1, "Dashed"), new IntValue(2, "Bold"), new IntValue(4, "Wavy")}, "LineType");
        CDXProperty.makeProperty(2562, "Arrow_Table", "ArrowTable", "INT8", new IntValue[]{new IntValue(0, "NoHead"), new IntValue(1, "HalfHead"), new IntValue(2, "FullHead"), new IntValue(4, "Resonance"), new IntValue(8, "Equilibrium"), new IntValue(16, "Hollow"), new IntValue(32, "RetroSynthetic")}, "ArrowType");
        CDXProperty.makeProperty(2563, "Rectangle_Table", "RectangleTable", "INT16", new IntValue[]{new IntValue(0, "Plain"), new IntValue(1, "RoundEdge"), new IntValue(2, "Shadow"), new IntValue(4, "Shaded"), new IntValue(8, "Filled"), new IntValue(16, "Dashed"), new IntValue(32, "Bold")}, "RectangleType");
        CDXProperty.makeProperty(2564, "Oval_Table", "OvalTable", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "Circle"), new IntValue(2, "Shaded"), new IntValue(4, "Filled"), new IntValue(8, "Dashed"), new IntValue(16, "Bold"), new IntValue(32, "Shadowed")}, "OvalType");
        CDXProperty.makeProperty(2565, "Orbital_Table", "OrbitalTable", "INT16", new IntValue[]{new IntValue(0, "s"), new IntValue(1, "oval"), new IntValue(2, "lobe"), new IntValue(3, "p"), new IntValue(4, "hybridPlus"), new IntValue(5, "hybridMinus"), new IntValue(6, "dz2Plus"), new IntValue(7, "dz2Minus"), new IntValue(8, "dxy dxy"), new IntValue(256, "sShaded"), new IntValue(257, "ovalShaded"), new IntValue(258, "lobeShaded"), new IntValue(259, "pShaded"), new IntValue(512, "sFilled"), new IntValue(513, "ovalFilled"), new IntValue(514, "lobeFilled"), new IntValue(515, "pFilled"), new IntValue(516, "hybridPlusFilled"), new IntValue(517, "hybridMinusFilled"), new IntValue(518, "dz2PlusFilled"), new IntValue(519, "dz2MinusFilled"), new IntValue(520, "dxyFilled")}, "OrbitalType");
        CDXProperty.makeProperty(2566, "Bracket_Table", "BracketTable", "INT16", new IntValue[]{new IntValue(0, "RoundPair"), new IntValue(1, "SquarePair"), new IntValue(2, "CurlyPair"), new IntValue(3, "Square"), new IntValue(4, "Curly"), new IntValue(5, "Round")}, "BracketType");
        CDXProperty.makeProperty(2567, "Symbol_Table", "SymbolTable", "INT16", new IntValue[]{new IntValue(0, "LonePair"), new IntValue(1, "Electron"), new IntValue(2, "RadicalCation"), new IntValue(3, "RadicalAnion"), new IntValue(4, "CirclePlus"), new IntValue(5, "CircleMinus"), new IntValue(6, "Dagger"), new IntValue(7, "DoubleDagger"), new IntValue(8, "Plus"), new IntValue(9, "Minus"), new IntValue(10, "Racemic"), new IntValue(11, "Absolute"), new IntValue(12, "Relative")}, "SymbolType");
        CDXProperty.makeProperty(2568, "Curve_Table", "CurveTable", "INT16", new IntValue[]{new IntValue(1, "1"), new IntValue(2, "2"), new IntValue(4, "4"), new IntValue(8, "8"), new IntValue(16, "16"), new IntValue(24, "24"), new IntValue(32, "32"), new IntValue(64, "64"), new IntValue(128, "128"), new IntValue(256, "256"), new IntValue(512, "512"), new IntValue(0, "0")}, "CurveType");
        CDXProperty.makeProperty(2592, "Arrow_HeadSize", "HeadSize", "INT16");
        CDXProperty.makeProperty(2593, "Arc_AngularSize", "AngularSize", "INT16", 0.1);
        CDXProperty.makeProperty(2594, "Bracket_LipSize", "LipSize", "INT16");
        CDXProperty.makeProperty(2595, "Curve_Points", "CurvePoints", "CDXCurvePoints");
        CDXProperty.makeProperty(2596, "Bracket_Usage", "BracketUsage", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "Unused1"), new IntValue(2, "Unused2"), new IntValue(3, "SRU"), new IntValue(4, "Monomer"), new IntValue(5, "Mer"), new IntValue(6, "Copolymer"), new IntValue(7, "CopolymerAlternating"), new IntValue(8, "CopolymerRandom"), new IntValue(9, "CopolymerBlock"), new IntValue(10, "Crosslink"), new IntValue(11, "Graft"), new IntValue(12, "Modification"), new IntValue(13, "Component"), new IntValue(14, "MixtureUnordered"), new IntValue(15, "MixtureOrdered"), new IntValue(16, "MultipleGroup"), new IntValue(17, "Generic"), new IntValue(18, "Anypolymer")});
        CDXProperty.makeProperty(2597, "Polymer_RepeatPattern", "PolymerRepeatPattern", "INT8", new IntValue[]{new IntValue(0, "HeadToTail"), new IntValue(1, "HeadToHead"), new IntValue(2, "EitherUnknown")});
        CDXProperty.makeProperty(2598, "Polymer_FlipTable", "PolymerFlipTable", "INT8", new IntValue[]{new IntValue(0, "Unspecified"), new IntValue(1, "NoFlip"), new IntValue(2, "Flip")});
        CDXProperty.makeProperty(2599, "BracketedObjects", "BracketedObjectIDs", "CDXObjectIDArray");
        CDXProperty.makeProperty(2600, "Bracket_RepeatCount", "RepeatCount", "FLOAT64");
        CDXProperty.makeProperty(2601, "Bracket_ComponentOrder", "ComponentOrder", "INT16");
        CDXProperty.makeProperty(2602, "Bracket_SRULabel", "SRULabel", "CDXString");
        CDXProperty.makeProperty(2603, "Bracket_GraphicID", "GraphicID", "CDXObjectID");
        CDXProperty.makeProperty(2604, "Bracket_BondID", "BondID", "CDXObjectID");
        CDXProperty.makeProperty(2605, "Bracket_InnerAtomID", "InnerAtomID", "CDXObjectID");
        CDXProperty.makeProperty(2606, "Curve_Points3D", "CurvePoints3D", "CDXCurvePoints3D");
        CDXProperty.makeProperty(2607, "Arrowhead_Type", "ArrowheadType", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "Solid")});
        CDXProperty.makeProperty(2608, "Arrowhead_CenterSize", "ArrowheadCenterSize", "UINT16");
        CDXProperty.makeProperty(2609, "Arrowhead_Width", "ArrowheadWidth", "UINT16");
        CDXProperty.makeProperty(2610, "ShadowSize", "ShadowSize", "UINT16");
        CDXProperty.makeProperty(2611, "Arrow_ShaftSpacing", "ArrowShaftSpacing", "UINT16");
        CDXProperty.makeProperty(2612, "Arrow_EquilibriumRatio", "ArrowEquilibriumRatio", "UINT16");
        CDXProperty.makeProperty(2613, "Arrow_ArrowHead_Head", "ArrowheadHead", "INT16", new IntValue[]{new IntValue(0, "None"), new IntValue(2, "Full")});
        CDXProperty.makeProperty(2614, "Arrow_ArrowHead_Tail", "ArrowHeadTail", "INT16");
        CDXProperty.makeProperty(2615, "Fill_Type", "FillType", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "None")});
        CDXProperty.makeProperty(2616, "Curve_Spacing", "CurveSpacing", "UINT16");
        CDXProperty.makeProperty(2617, "Closed", "Closed", "CDXBoolean");
        CDXProperty.makeProperty(2618, "Arrow_Dipole", "Dipole", "CDXBoolean");
        CDXProperty.makeProperty(2619, "Arrow_NoGo", "NoGo", "INT8");
        CDXProperty.makeProperty(2620, "CornerRadius", "CornerRadius", "INT16");
        CDXProperty.makeProperty(2621, "Frame_Type", "FrameType", "INT16");
        CDXProperty.makeProperty(2656, "Picture_Edition", "Edition", "Unformatted");
        CDXProperty.makeProperty(2657, "Picture_EditionAlias", "EditionAlias", "Unformatted");
        CDXProperty.makeProperty(2658, "MacPICT", "MacPICT", "Unformatted");
        CDXProperty.makeProperty(2659, "WindowsMetafile", "WindowsMetafile", "Unformatted");
        CDXProperty.makeProperty(2660, "OLEObject", "OLEObject", "Unformatted");
        CDXProperty.makeProperty(2661, "EnhancedMetafile", "EnhancedMetafile", "Unformatted");
        CDXProperty.makeProperty(2670, "GIF", "GIF", "Unformatted");
        CDXProperty.makeProperty(2671, "TIFF", "TIFF", "Unformatted");
        CDXProperty.makeProperty(2672, "PNG", "PNG", "Unformatted");
        CDXProperty.makeProperty(2673, "JPEG", "JPEG", "Unformatted");
        CDXProperty.makeProperty(2674, "BMP", "BMP", "Unformatted");
        CDXProperty.makeProperty(2688, "Spectrum_XSpacing", "XSpacing", "FLOAT64");
        CDXProperty.makeProperty(2689, "Spectrum_XLow", "XLow", "FLOAT64");
        CDXProperty.makeProperty(2690, "Spectrum_XTable", "XTable", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "Wavenumbers"), new IntValue(2, "Microns"), new IntValue(3, "Hertz"), new IntValue(4, "MassUnits"), new IntValue(5, "PartsPerMillion"), new IntValue(6, "Other")}, "SpectrumXType");
        CDXProperty.makeProperty(2691, "Spectrum_YTable", "YTable", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "Absorbance"), new IntValue(2, "Transmittance"), new IntValue(3, "PercentTransmittance"), new IntValue(4, "Other"), new IntValue(5, "ArbitraryUnits")}, "SpectrumYType");
        CDXProperty.makeProperty(2692, "Spectrum_XAxisLabel", "XAxisLabel", "CDXString");
        CDXProperty.makeProperty(2693, "Spectrum_YAxisLabel", "YAxisLabel", "CDXString");
        CDXProperty.makeProperty(2694, "Spectrum_DataPoint", "not used", "FLOAT64");
        CDXProperty.makeProperty(2695, "Spectrum_Class", "Class", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "Chromatogram"), new IntValue(2, "Infrared"), new IntValue(3, "UVVis"), new IntValue(4, "XRayDiffraction"), new IntValue(5, "MassSpectrum"), new IntValue(6, "NMR"), new IntValue(7, "Raman"), new IntValue(8, "Fluorescence"), new IntValue(9, "Atomic")});
        CDXProperty.makeProperty(2696, "Spectrum_YLow", "YLow", "FLOAT64");
        CDXProperty.makeProperty(2697, "Spectrum_YScale", "YScale", "FLOAT64");
        CDXProperty.makeProperty(2720, "TLC_OriginFraction", "OriginFraction", "FLOAT64");
        CDXProperty.makeProperty(2721, "TLC_SolventFrontFraction", "SolventFrontFraction", "FLOAT64");
        CDXProperty.makeProperty(2722, "TLC_ShowOrigin", "ShowOrigin", "CDXBoolean");
        CDXProperty.makeProperty(2723, "TLC_ShowSolventFront", "ShowSolventFront", "CDXBoolean");
        CDXProperty.makeProperty(2724, "TLC_ShowBorders", "ShowBorders", "CDXBoolean");
        CDXProperty.makeProperty(2725, "TLC_ShowSideTicks", "ShowSideTicks", "CDXBoolean");
        CDXProperty.makeProperty(2736, "TLC_Rf", "Rf", "FLOAT64");
        CDXProperty.makeProperty(2737, "TLC_Tail", "Tail", "CDXCoordinate");
        CDXProperty.makeProperty(2738, "TLC_ShowRf", "ShowRf", "FLOAT64");
        CDXProperty.makeProperty(2816, "NamedAlternativeGroup_TextFrame", "TextFrame", "CDXRectangle");
        CDXProperty.makeProperty(2817, "NamedAlternativeGroup_GroupFrame", "GroupFrame", "CDXRectangle");
        CDXProperty.makeProperty(2818, "NamedAlternativeGroup_Valence", "Valence", "INT16");
        CDXProperty.makeProperty(2944, "GeometricFeature", "GeometricFeature", "INT8", new IntValue[]{new IntValue(0, "Undefined"), new IntValue(1, "PointFromPointPointDistance"), new IntValue(2, "PointFromPointPointPercentage"), new IntValue(3, "PointFromPointNormalDistance"), new IntValue(4, "LineFromPoints"), new IntValue(5, "PlaneFromPoints"), new IntValue(6, "PlaneFromPointLine"), new IntValue(7, "CentroidFromPoints"), new IntValue(8, "NormalFromPointPlane")});
        CDXProperty.makeProperty(2945, "RelationValue", "RelationValue", "FLOAT64");
        CDXProperty.makeProperty(2946, "BasisObjects", "BasisObjects", "CDXObjectIDArray");
        CDXProperty.makeProperty(2947, "ConstraintTable", "ConstraintTable", "INT8", new IntValue[]{new IntValue(0, "Undefined"), new IntValue(1, "Distance"), new IntValue(2, "Anglee"), new IntValue(3, "ExclusionSphere")});
        CDXProperty.makeProperty(2948, "ConstraintMin", "ConstraintMin", "FLOAT64");
        CDXProperty.makeProperty(2949, "ConstraintMax", "ConstraintMax", "FLOAT64");
        CDXProperty.makeProperty(2950, "IgnoreUnconnectedAtoms", "IgnoreUnconnectedAtoms", "CDXBooleanImplied");
        CDXProperty.makeProperty(2951, "DihedralIsChiral", "DihedralIsChiral", "CDXBooleanImplied");
        CDXProperty.makeProperty(2952, "PointIsDirected", "PointIsDirected", "CDXBooleanImplied");
        CDXProperty.makeProperty(2992, "ChemicalPropertyType", "ChemicalPropertyType", "UINT32");
        CDXProperty.makeProperty(2993, "ChemicalPropertyDisplayID", "ChemicalPropertyDisplayID", "CDXObjectID");
        CDXProperty.makeProperty(2994, "ChemicalPropertyIsActive", "ChemicalPropertyIsActive", "CDXBoolean");
        CDXProperty.makeProperty(3072, "ReactionStep_Atom_Map", "ReactionStepAtomMap", "CDXObjectIDArray");
        CDXProperty.makeProperty(3073, "ReactionStep_Reactants", "ReactionStepReactants", "CDXObjectIDArray");
        CDXProperty.makeProperty(3074, "ReactionStep_Products", "ReactionStepProducts", "CDXObjectIDArray");
        CDXProperty.makeProperty(3075, "ReactionStep_Plusses", "ReactionStepPlusses", "CDXObjectIDArray");
        CDXProperty.makeProperty(3076, "ReactionStep_Arrows", "ReactionStepArrows", "CDXObjectIDArray");
        CDXProperty.makeProperty(3077, "ReactionStep_ObjectsAboveArrow", "ReactionStepObjectsAboveArrow", "CDXObjectIDArray");
        CDXProperty.makeProperty(3078, "ReactionStep_ObjectsBelowArrow", "ReactionStepObjectsBelowArrow", "CDXObjectIDArray");
        CDXProperty.makeProperty(3079, "ReactionStep_Atom_Map_Manual", "ReactionStepAtomMapManual", "CDXObjectIDArray");
        CDXProperty.makeProperty(3080, "ReactionStep_Atom_Map_Auto", "ReactionStepAtomMapAuto", "CDXObjectIDArray");
        CDXProperty.makeProperty(3328, "ObjectTag_Table", "TagTable", "INT16", new IntValue[]{new IntValue(0, "Unknown"), new IntValue(1, "Double"), new IntValue(2, "Long"), new IntValue(3, "String")});
        CDXProperty.makeProperty(3331, "ObjectTag_Tracking", "Tracking", "CDXBoolean");
        CDXProperty.makeProperty(3332, "ObjectTag_Persistent", "Persistent", "CDXBoolean");
        CDXProperty.makeProperty(3333, "ObjectTag_Value", "Value", "varies");
        CDXProperty.makeProperty(3334, "Positioning", "PositioningTable", "INT8", new IntValue[]{new IntValue(0, "auto"), new IntValue(1, "angle"), new IntValue(2, "offset"), new IntValue(3, "absolute")});
        CDXProperty.makeProperty(3335, "PositioningAngle", "PositioningAngle", "INT32", 1.52587890625E-5);
        CDXProperty.makeProperty(3336, "PositioningOffset", "PositioningOffset", "CDXPoint2D");
        CDXProperty.makeProperty(3584, "Sequence_Identifier", "SequenceIdentifier", "CDXString");
        CDXProperty.makeProperty(3840, "CrossReference_Container", "CrossReferenceContainer", "CDXString");
        CDXProperty.makeProperty(3841, "CrossReference_Document", "CrossReferenceDocument", "CDXString");
        CDXProperty.makeProperty(3842, "CrossReference_Identifier", "CrossReferenceIdentifier", "CDXString");
        CDXProperty.makeProperty(3843, "CrossReference_Sequence", "CrossReferenceSequence", "CDXString");
        CDXProperty.makeProperty(4096, "Template_PaneHeight", "PaneHeight", "CDXCoordinate");
        CDXProperty.makeProperty(4097, "Template_NumRows", "NumRows", "INT16");
        CDXProperty.makeProperty(4098, "Template_NumColumns", "NumColumns", "INT16");
        CDXProperty.makeProperty(4352, "Group_Integral", "Integral", "CDXBoolean");
        CDXProperty.makeProperty(8176, "SplitterPositions", "SplitterPositions", "CDXObjectIDArray");
        CDXProperty.makeProperty(8177, "PageDefinition", "PageDefinition", "INT8", new IntValue[]{new IntValue(0, "Undefined"), new IntValue(1, "Center"), new IntValue(2, "TL4"), new IntValue(3, "IDTerm"), new IntValue(4, "FlushLeft"), new IntValue(5, "FlushRight"), new IntValue(6, "Reaction1"), new IntValue(7, "Reaction2"), new IntValue(8, "MulticolumnTL4"), new IntValue(9, "MulticolumnNonTL4"), new IntValue(10, "UserDefined")});
        CDXProperty.makeProperty(52719, "id", "id", "CDXObjectID");
        CDXProperty.makeProperty(52718, "charset", "charset", "Unformatted");
        CDXProperty.makeProperty(52717, "font", "name", "Unformatted");
        CDXProperty.makeProperty(52716, "r", "r", "FLOAT64");
        CDXProperty.makeProperty(52715, "g", "g", "FLOAT64");
        CDXProperty.makeProperty(52714, "b", "b", "FLOAT64");
        CDXProperty.makeProperty(52713, "fontindex", "fontindex", "UINT16");
        CDXProperty.makeProperty(52712, "fontsize", "fontsize", "UINT16");
        CDXProperty.makeProperty(52711, "fontface", "fontface", "UINT16");
        CDXProperty.makeProperty(52710, "fontcolor", "fontcolor", "UINT16");
    }

    public String getCdxName() {
        return this.cdxName;
    }

    public int getCode() {
        return this.code;
    }

    public CDXDataType getDataType() {
        return this.dataType;
    }

    public String getFullName() {
        return this.fullName;
    }

    static {
        LOG.setLevel(Level.INFO);
        propTable = null;
        cdxTable = new Hashtable();
    }
}

