/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.components.CDXUtil;

public class CDXPoint3D
implements CDXConstants {
    static Logger LOG = Logger.getLogger(CDXPoint3D.class);
    int x;
    int y;
    int z;
    double xx;
    double yy;
    double zz;

    public CDXPoint3D() {
    }

    public CDXPoint3D(String point) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(point);
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("Bad point string: " + point + "/");
        }
        try {
            int z0 = Integer.parseInt(st.nextToken());
            int y0 = Integer.parseInt(st.nextToken());
            int x0 = Integer.parseInt(st.nextToken());
            this.init(x0, y0, z0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad point string: " + point);
        }
    }

    public CDXPoint3D(int x, int y, int z) {
        this.init(x, y, z);
    }

    private void init(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.zz = (double)z / 65536.0;
        this.yy = (double)y / 65536.0;
        this.xx = (double)x / 65536.0;
        this.xx = (double)((int)(100.0 * this.xx)) / 100.0;
        this.yy = (double)((int)(100.0 * this.yy)) / 100.0;
        this.zz = (double)((int)(100.0 * this.zz)) / 100.0;
    }

    void setFloatValue(String point) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(point);
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("Bad point string: " + point);
        }
        try {
            this.xx = new Double(st.nextToken());
            this.yy = new Double(st.nextToken());
            this.zz = new Double(st.nextToken());
            this.x = (int)(this.xx / 65536.0);
            this.y = (int)(this.yy / 65536.0);
            this.z = (int)(this.zz / 65536.0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad point string: " + point);
        }
    }

    String getAttributeValue() {
        return "" + CDXUtil.trimFloat(this.zz) + " " + CDXUtil.trimFloat(this.yy) + " " + CDXUtil.trimFloat(this.xx);
    }

    double getX3() {
        return this.xx;
    }

    double getY3() {
        return this.yy;
    }

    double getZ3() {
        return this.zz;
    }

    public String toString() {
        return "" + CDXUtil.trimFloat(this.xx) + "/" + CDXUtil.trimFloat(this.yy) + "/" + CDXUtil.trimFloat(this.zz);
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

