/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.components.CDXUtil;

public class CDXPoint2D
implements CDXConstants {
    static Logger LOG = Logger.getLogger(CDXPoint2D.class);
    int x;
    int y;
    double xx;
    double yy;

    public CDXPoint2D() {
    }

    public CDXPoint2D(String point) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(point);
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Bad point string: " + point + "/");
        }
        try {
            int y0 = Integer.parseInt(st.nextToken());
            int x0 = Integer.parseInt(st.nextToken());
            this.init(x0, y0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad point string: " + point);
        }
    }

    public CDXPoint2D(int x, int y) {
        this.init(x, y);
    }

    private void init(int x, int y) {
        this.x = x;
        this.y = y;
        this.yy = (double)y / 65536.0;
        this.xx = (double)x / 65536.0;
        this.xx = (double)((int)(10000.0 * this.xx)) / 10000.0;
        this.yy = (double)((int)(10000.0 * this.yy)) / 10000.0;
    }

    void setFloatValue(String point) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(point);
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Bad point string: " + point);
        }
        try {
            this.xx = new Double(st.nextToken());
            this.yy = new Double(st.nextToken());
            this.x = (int)(this.xx / 65536.0);
            this.y = (int)(this.yy / 65536.0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad point string: " + point);
        }
    }

    String getAttributeValue() {
        return "" + CDXUtil.trimFloat(this.xx) + " " + CDXUtil.trimFloat(this.yy);
    }

    double getX2() {
        return this.xx;
    }

    double getY2() {
        return this.yy;
    }

    public String toString() {
        return "" + CDXUtil.trimFloat(this.xx) + "/" + CDXUtil.trimFloat(this.yy);
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

