/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import nu.xom.Node;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.components.BlockManager;
import org.xmlcml.cml.chemdraw.components.CDXList;
import org.xmlcml.cml.chemdraw.components.CDXML;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXProperty;
import org.xmlcml.cml.chemdraw.components.CDXUtil;
import org.xmlcml.cml.chemdraw.components.ChemdrawRuntimeException;

public class CDXParser
implements CDXConstants {
    private static Logger LOG = Logger.getLogger(CDXParser.class);
    private static byte[] HEADER;
    private int depth;
    private byte[] bytes = new byte[0];
    private Stack<CDXObject> objectStack;
    private CDXObject parsedObject;
    int byteCount = 0;
    private BlockManager blockManager;
    private boolean emptyStack = false;
    private int lastHeader;
    private static int BLOCKLEN;
    private static int MAXTRIES;

    public int getByteCount() {
        return this.byteCount;
    }

    public CDXParser() {
        this.init();
    }

    private void init() {
        CDXObject.makeObjects();
        CDXProperty.makeProperties();
    }

    public void parseCDX(byte[] bytes) throws IOException {
        this.bytes = bytes;
        this.parseCDX();
    }

    public void parseCDX(InputStream is) throws IOException {
        this.bytes = IOUtils.toByteArray((InputStream)is);
        this.parseCDX();
    }

    private void parseCDX() throws IOException {
        this.makeBlocks(this.bytes);
        this.objectStack = new Stack();
        this.emptyStack = false;
        this.parseBlocks();
    }

    private void makeBlocks(byte[] bytes) {
        this.blockManager = new BlockManager();
        this.blockManager.setBytes(bytes);
    }

    private void parseBlocks() {
        LOG.debug((Object)"parseBlocks");
        this.parsedObject = new CDXList();
        this.parsedObject.setParser(this);
        this.byteCount = 0;
        this.lastHeader = 0;
        while (this.readHeader()) {
            LOG.debug((Object)("Header: " + this.byteCount + "/" + Integer.toHexString(this.byteCount)));
            this.startElement(new CDXML(), 0, null);
            this.depth = 0;
            while (this.byteCount < this.bytes.length) {
                try {
                    this.readPropertyOrObject();
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    LOG.error((Object)("Array problem: " + aioobe));
                }
                if (this.byteCount != this.bytes.length) continue;
                LOG.debug((Object)"Reached end? ");
                break;
            }
            this.endElement();
        }
    }

    private boolean readHeader() {
        LOG.debug((Object)"readHeader");
        boolean ok = true;
        int headerCount = 0;
        while (true) {
            byte headerByte;
            byte currentByte;
            if (this.byteCount >= this.bytes.length) {
                LOG.trace((Object)("ran off end: " + this.byteCount));
                ok = false;
                break;
            }
            if ((currentByte = this.bytes[this.byteCount++]) == (headerByte = HEADER[headerCount++])) {
                if (headerCount != HEADER.length) continue;
                this.lastHeader = this.byteCount;
                headerCount = 0;
                break;
            }
            headerCount = 0;
        }
        int start = this.byteCount;
        for (int i = 0; i < 16; ++i) {
            byte b;
            if (this.byteCount >= this.bytes.length) {
                ok = false;
                break;
            }
            if ((b = this.bytes[this.byteCount++]) == 0 || b == -128 && this.byteCount - start == 12) continue;
            LOG.trace((Object)("non-zero byte (" + b + ") in CDX header (16 zeros expected) at: " + this.byteCount + "/" + Integer.toHexString(this.byteCount)));
        }
        if (this.byteCount != this.lastHeader) {
            // empty if block
        }
        return ok;
    }

    private CDXObject startElement(CDXObject object, int id, byte[] bytes) {
        LOG.debug((Object)("Start CDXElement " + this.byteCount + "/" + Integer.toHexString(this.byteCount)));
        object.setId(id);
        if (bytes != null) {
            CDXProperty prop = CDXProperty.createPropertyByCDXName("id");
            prop.setBytes(bytes);
            object.addProperty(prop);
        }
        if (this.parsedObject != null) {
            this.objectStack.push(this.parsedObject);
            this.parsedObject.appendChild((Node)object);
        } else {
            LOG.error((Object)"NULL obj BUG");
        }
        this.parsedObject = object;
        this.parsedObject.setParser(this);
        return this.parsedObject;
    }

    void endElement() {
        LOG.debug((Object)"endElement");
        this.parsedObject.endElement();
        if (this.objectStack.isEmpty()) {
            LOG.debug((Object)"Empty stack...");
            this.emptyStack = true;
        } else {
            this.parsedObject = this.objectStack.pop();
        }
    }

    private void readPropertyOrObject() {
        byte[] b;
        LOG.trace((Object)"=== READ PROPERTY OR OBJECT ==");
        if (this.depth > 10) {
            LOG.error((Object)"Excessive depth - probable misread; attempt recovery");
            this.byteCount = this.lastHeader + 16;
            return;
        }
        ++this.depth;
        if ((b = new byte[]{this.bytes[this.byteCount++], this.bytes[this.byteCount++]})[0] == 0 && b[1] == 0) {
            this.endElement();
        } else if ((b[1] & 0x80) == 0) {
            this.processProperty(b);
        } else {
            this.processObject(b);
        }
        --this.depth;
    }

    private void processProperty(byte[] bb) {
        LOG.debug((Object)"processProperty");
        int iProp = CDXUtil.getUINT16(bb);
        String propS = "" + iProp;
        boolean unknown = false;
        CDXProperty prop = CDXProperty.createProperty(propS);
        LOG.debug((Object)("PROP: " + propS + " (" + CDXUtil.toXHex(iProp) + ")" + (prop == null ? null : prop.getFullName())));
        if (prop == null) {
            LOG.error((Object)("UNKNOWN PROP : " + propS + "(" + CDXUtil.toXHex(iProp) + ")) at byte " + this.byteCount + "/" + Integer.toHexString(this.byteCount) + " in " + bb.length));
            throw new ChemdrawRuntimeException("UNKNOWN PROP");
        }
        LOG.trace((Object)("PROPERTY ... " + prop.getCDXName()));
        if (prop != null) {
            prop.processAlias();
        }
        byte[] b = new byte[]{this.bytes[this.byteCount++], this.bytes[this.byteCount++]};
        int length = CDXUtil.getUINT16(b);
        LOG.trace((Object)("Reading Property of length: " + length));
        if (length == 0) {
            return;
        }
        byte[] bs = new byte[length];
        for (int i = 0; i < length; ++i) {
            if (this.byteCount >= this.bytes.length) {
                LOG.error((Object)("?Premature EOF after " + this.byteCount + "bytes; reading " + length));
                prop = null;
                throw new RuntimeException("Abort ChemDraw parsing");
            }
            bs[i] = this.bytes[this.byteCount++];
        }
        LOG.trace((Object)("BYTE " + this.byteCount + " (" + CDXUtil.toXHex(this.byteCount) + ")"));
        if (prop == null) {
            return;
        }
        LOG.trace((Object)("Reading Property: " + prop.getCDXName() + "/" + Integer.toHexString(iProp)));
        String value = "";
        try {
            if ("objecttag".equals(this.parsedObject.codeName.cdxName)) {
                LOG.trace((Object)"objecttag");
            }
            value = prop.setBytes(bs);
            LOG.trace((Object)("VALUE " + value));
            this.parsedObject.addProperty(prop);
            prop.substituteValues();
        }
        catch (IllegalArgumentException iae) {
            LOG.error((Object)("misread? " + value + "/" + propS + "(" + Integer.toHexString(iProp) + ") /" + prop.getCDXName() + "/" + iae + " at byteCount: " + this.byteCount + "; recover to next header"));
            this.byteCount = this.lastHeader + 16;
            throw new RuntimeException("Cannot recover from misparse");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error((Object)("Premature EOF? " + this.byteCount + " recover to next header"));
            this.byteCount = this.lastHeader + 16;
            throw new RuntimeException("Premature EOF?");
        }
        catch (Exception cde) {
            LOG.error((Object)("misread? " + value + "/" + propS + "(" + Integer.toHexString(iProp) + ") /" + prop.getCDXName() + "/" + cde + " at byteCount: " + this.byteCount + "; recover to next header"));
            this.byteCount = this.lastHeader + 16;
            throw new RuntimeException("Cannot recover from misparse");
        }
        if (unknown) {
            LOG.trace((Object)("Read unknown Property: " + prop.getCDXName()));
        }
        LOG.trace((Object)("ByteCount " + this.byteCount));
    }

    private void processObject(byte[] bb) {
        LOG.debug((Object)"processObject");
        int iObj = CDXUtil.getUINT16(bb);
        CDXObject obj = CDXObject.newCDXObject(iObj);
        if (obj == null) {
            LOG.error((Object)("UNKNOWN OBJ: " + iObj + " " + Integer.toHexString(iObj) + "; try recovery to next header"));
            this.byteCount = this.lastHeader + 16;
        } else if (obj.codeName.equals("unknown")) {
            LOG.trace((Object)("UNKNOWN: " + iObj));
        }
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = this.bytes[this.byteCount++];
        }
        if (obj == null) {
            return;
        }
        int id = (int)CDXUtil.getUINT32(b);
        this.startElement(obj, id, b);
        if (this.parsedObject.codeName.cdxName.equals("unknown")) {
            LOG.trace((Object)("UNKN " + iObj));
        }
        LOG.debug((Object)("Element: " + this.parsedObject.codeName.cdxName));
        this.readPropertyOrObject();
    }

    public CDXObject getParsedObject() {
        return this.parsedObject;
    }

    static {
        LOG.setLevel(Level.INFO);
        HEADER = new byte[]{86, 106, 67, 68, 48, 49, 48, 48, 4, 3, 2, 1};
        BLOCKLEN = 256;
        MAXTRIES = 3;
    }
}

