/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.chemdraw.CDXML2CMLProcessor;
import org.xmlcml.cml.chemdraw.components.CDXGroup;
import org.xmlcml.cml.chemdraw.components.CDXObject;

public class CDXPage
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXPage.class);
    public static final int CODE = 32769;
    public static final String NAME = "Page";
    public static final String CDXNAME = "page";

    public CDXPage() {
        super(32769, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXPage(this);
    }

    public CDXPage(CDXObject old) {
        super(old);
    }

    @Override
    public void process2CML(CMLElement element) {
        this.processContents(element);
    }

    void processGroups(CMLElement element) throws RuntimeException {
        Nodes nodes = this.query("./group");
        LOG.info((Object)("Group count: " + nodes.size()));
        for (int i = 0; i < nodes.size(); ++i) {
            CDXGroup group = (CDXGroup)nodes.get(i);
            for (int j = 0; j < group.getChildElements().size(); ++j) {
                CDXObject obj = (CDXObject)group.getChildElements().get(j);
                if (obj instanceof CDXPage) {
                    LOG.warn((Object)"Page nested in group");
                } else if (obj instanceof CDXGroup) {
                    LOG.warn((Object)"Group nested in group");
                }
                obj.process2CML(element);
                element.appendChild((Node)obj);
            }
            group.detach();
        }
    }

    protected void processContents(CMLElement element) throws RuntimeException {
        this.flattenTopLevelGroups(element);
        this.processGroups(element);
        this.processGraphics(element);
        this.processTexts(element);
        this.processFragmentsContainingUnspecfiedNodes(element);
        this.processFragmentsContainingFragmentNodes(element);
        this.processMoleculeFragments(element);
        CDXML2CMLProcessor.createMoleculeList(element);
        CDXML2CMLProcessor.addLabelsToMolecules(element);
        this.processReactions(element);
        this.processLeftOvers(element);
    }

    private void flattenTopLevelGroups(CMLElement element) {
        Nodes groups = this.query("//*[not(self::group)]/group");
        LOG.info((Object)("Found " + groups.size() + " groups to flatten"));
        for (int i = 0; i < groups.size(); ++i) {
            CDXGroup group = (CDXGroup)groups.get(i);
            group.flatten(this);
        }
    }

    @Override
    public String getString() {
        return "[..page..]";
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

