/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.IllegalCharacterDataException;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.CDXML2CMLProcessor;
import org.xmlcml.cml.chemdraw.components.BoundingBox;
import org.xmlcml.cml.chemdraw.components.CDXArrow;
import org.xmlcml.cml.chemdraw.components.CDXBond;
import org.xmlcml.cml.chemdraw.components.CDXBracketAttachment;
import org.xmlcml.cml.chemdraw.components.CDXBracketedGroup;
import org.xmlcml.cml.chemdraw.components.CDXColorTable;
import org.xmlcml.cml.chemdraw.components.CDXCurve;
import org.xmlcml.cml.chemdraw.components.CDXFontTable;
import org.xmlcml.cml.chemdraw.components.CDXFragment;
import org.xmlcml.cml.chemdraw.components.CDXGeometry;
import org.xmlcml.cml.chemdraw.components.CDXGraphic;
import org.xmlcml.cml.chemdraw.components.CDXGroup;
import org.xmlcml.cml.chemdraw.components.CDXList;
import org.xmlcml.cml.chemdraw.components.CDXML;
import org.xmlcml.cml.chemdraw.components.CDXNode;
import org.xmlcml.cml.chemdraw.components.CDXObjectTag;
import org.xmlcml.cml.chemdraw.components.CDXPage;
import org.xmlcml.cml.chemdraw.components.CDXParser;
import org.xmlcml.cml.chemdraw.components.CDXPoint2D;
import org.xmlcml.cml.chemdraw.components.CDXProperty;
import org.xmlcml.cml.chemdraw.components.CDXReactionScheme;
import org.xmlcml.cml.chemdraw.components.CDXReactionStep;
import org.xmlcml.cml.chemdraw.components.CDXText;
import org.xmlcml.cml.chemdraw.components.CodeName;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLReaction;

public class CDXObject
extends Element
implements CDXConstants {
    static Logger LOG = Logger.getLogger(CDXObject.class);
    static Hashtable<String, CDXObject> objTable;
    static Hashtable<String, CDXObject> nameTable;
    private CDXParser parser;
    static int CODE;
    static String NAME;
    static String CDXNAME;
    protected CodeName codeName;
    protected String id;
    protected BoundingBox bbox;
    private CDXPoint2D p;
    private Vector<CDXProperty> propVector;
    private CDXML2CMLProcessor cdxmlObject = null;

    void setParser(CDXParser parser) {
        this.parser = parser;
    }

    public Element copy() {
        return new CDXObject(this);
    }

    static void makeObjects() {
        if (objTable == null) {
            objTable = new Hashtable();
        }
        if (nameTable == null) {
            nameTable = new Hashtable();
        }
        try {
            CDXObject.makeObject(32768, new CDXML());
            CDXObject.makeObject(32769, new CDXPage());
            CDXObject.makeObject(32770, new CDXGroup());
            CDXObject.makeObject(32771, new CDXFragment());
            CDXObject.makeObject(32772, new CDXNode());
            CDXObject.makeObject(32773, new CDXBond());
            CDXObject.makeObject(32774, new CDXText());
            CDXObject.makeObject(32775, new CDXGraphic());
            CDXObject.makeObject(32776, new CDXCurve());
            CDXObject.makeObject(new CDXObject(32777, "EmbeddedO", "embeddedo"));
            CDXObject.makeObject(new CDXObject(32778, "NamedAlternativeGroup", "altgroup"));
            CDXObject.makeObject(new CDXObject(32779, "TemplateGrid", "templategrid"));
            CDXObject.makeObject(new CDXObject(32780, "RegistryNumber", "regnum"));
            CDXObject.makeObject(32781, new CDXReactionScheme());
            CDXObject.makeObject(32782, new CDXReactionStep());
            CDXObject.makeObject(new CDXObject(32784, "Spectrum", "spectrum"));
            CDXObject.makeObject(32785, new CDXObjectTag());
            CDXObject.makeObject(new CDXObject(32787, "Sequence", "sequence"));
            CDXObject.makeObject(new CDXObject(32788, "CrossReference", "crossreference"));
            CDXObject.makeObject(new CDXObject(32789, "Splitter", "splitter"));
            CDXObject.makeObject(new CDXObject(32790, "Table", "table"));
            CDXObject.makeObject(32791, new CDXBracketedGroup());
            CDXObject.makeObject(32792, new CDXBracketAttachment());
            CDXObject.makeObject(new CDXObject(32793, "CrossingBond", "crossingbond"));
            CDXObject.makeObject(new CDXObject(32800, "Border", "border"));
            CDXObject.makeObject(32801, new CDXGeometry());
            CDXObject.makeObject(new CDXObject(32802, "Constraint", "constraint"));
            CDXObject.makeObject(new CDXObject(32803, "TLCPlate", "tlcplate"));
            CDXObject.makeObject(new CDXObject(32804, "TLCLane", "tlclane"));
            CDXObject.makeObject(new CDXObject(32805, "TLCSpot", "tlcspot"));
            CDXObject.makeObject(new CDXObject(32806, "ChemicalProperty", "chemicalproperty"));
            CDXObject.makeObject(32807, new CDXArrow());
            CDXObject.makeObject(256, new CDXFontTable());
            CDXObject.makeObject(768, new CDXColorTable());
            CDXObject.makeObject(new CDXObject(14, "kCDXProp_RepresentsProperty", "represent"));
            CDXObject.makeObject(new CDXObject(33876, "Style", "s"));
            CDXObject.makeObject(new CDXObject(33878, "Color", "color"));
            CDXObject.makeObject(new CDXObject(33880, "Font", "font"));
            CDXObject.makeObject(32921, new CDXList());
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error((Object)("Cannot initialize " + t));
        }
    }

    private static CDXObject getObject(int code) {
        CDXObject cdxObject = objTable.get("" + code);
        LOG.debug((Object)("name: " + (cdxObject == null ? null : cdxObject.codeName.cdxName)));
        if (cdxObject == null || cdxObject.codeName.cdxName.equals("unknown")) {
            LOG.debug((Object)("unknown: " + code + "/" + Integer.toHexString(code)));
        }
        return cdxObject == null ? cdxObject : cdxObject;
    }

    private static void makeObject(CDXObject object) {
        objTable.put("" + object.codeName.code, object);
        String name = object.codeName.cdxName;
        if (name == null) {
            throw new RuntimeException("NULL NAME " + object.getClass().getName() + " .. " + object.getLocalName());
        }
        nameTable.put(name, object);
    }

    private static void makeObject(int code, CDXObject obj) {
        CDXObject.makeObject(obj);
        if (code != obj.codeName.code) {
            new Exception().printStackTrace();
            LOG.error((Object)("Codes do not agree: " + code + "/" + Integer.toHexString(code) + " != " + obj.codeName.code + "/" + Integer.toHexString(obj.codeName.code) + "(" + obj.getClass().getName() + ")"));
        }
    }

    protected CDXObject(int code, String name, String cdxName) {
        super(cdxName);
        this.codeName = new CodeName(code, name, cdxName);
    }

    public CDXObject(CDXObject element) {
        super(element.getLocalName());
        this.codeName = element.codeName;
        CMLElement.copyAttributesFromTo((Element)element, (Element)this);
        CMLElement.copyChildrenFromTo((Element)element, (Element)this);
    }

    private CDXObject(String tagName) {
        super(tagName);
        this.init();
    }

    private void init() {
    }

    static CDXObject newCDXObject(int code) {
        String name;
        CDXObject obj = null;
        CDXObject refObj = CDXObject.getObject(code);
        String string = name = refObj == null ? "object" : refObj.codeName.cdxName;
        if (code == 32807) {
            obj = new CDXArrow();
        } else if (code == 32773) {
            obj = new CDXBond();
        } else if (code == 32792) {
            obj = new CDXBracketAttachment();
        } else if (code == 32791) {
            obj = new CDXBracketedGroup();
        } else if (code == 768) {
            obj = new CDXColorTable();
        } else if (code == 32776) {
            obj = new CDXCurve();
        } else if (code == 32768) {
            obj = new CDXML();
        } else if (code == 256) {
            obj = new CDXFontTable();
        } else if (code == 32771) {
            obj = new CDXFragment();
        } else if (code == 32801) {
            obj = new CDXGeometry();
        } else if (code == 32775) {
            obj = new CDXGraphic();
        } else if (code == 32770) {
            obj = new CDXGroup();
        } else if (code == 32772) {
            obj = new CDXNode();
        } else if (code == 32785) {
            obj = new CDXObjectTag();
        } else if (code == 32769) {
            obj = new CDXPage();
        } else if (code == 32781) {
            obj = new CDXReactionScheme();
        } else if (code == 32782) {
            obj = new CDXReactionStep();
        } else if (code == 32774) {
            obj = new CDXText();
        } else {
            obj = new CDXObject(name);
            throw new RuntimeException("Unknown CDX name, code = " + name + ", " + code + "/" + Integer.toHexString(code));
        }
        return obj;
    }

    protected void copyAttributesTo(CMLElement element) {
        if (element == null) {
            throw new RuntimeException("null element to copy to");
        }
        String id = element.getId();
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute att = this.getAttribute(i);
            String attName = att.getLocalName();
            String attVal = att.getValue();
            if (!attName.equals("id")) {
                Attribute newAtt = new Attribute("cdx:" + attName, "http://www.xml-cml/namespaces/cdx", attVal);
                element.addAttribute(newAtt);
                continue;
            }
            if (!attName.equals("id") || id != null) continue;
            element.setId(attVal);
        }
    }

    public void setChemDrawConverterRecursively(CDXML2CMLProcessor cdxmlObject) {
        this.cdxmlObject = cdxmlObject;
        Elements childElements = this.getChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            if (!(childElements.get(i) instanceof CDXObject)) continue;
            ((CDXObject)childElements.get(i)).setChemDrawConverterRecursively(cdxmlObject);
        }
    }

    protected void writeLog(Level level, String s) {
        LOG.debug((Object)s);
    }

    void addProperty(CDXProperty prop) {
        if (this.propVector == null) {
            this.propVector = new Vector();
        }
        this.propVector.addElement(prop);
        String name = prop.getCDXName();
        try {
            this.setAttribute(name, prop.getDataTypeString());
        }
        catch (IllegalCharacterDataException ice) {
            if (name.equals("MacPrintInfo")) {
                LOG.warn((Object)ice.getMessage());
            }
            throw ice;
        }
    }

    private void processAttributes() {
        if (this.propVector != null) {
            for (int i = 0; i < this.propVector.size(); ++i) {
                CDXProperty prop = this.propVector.elementAt(i);
                String name = prop.getCDXName();
                if (name == null) continue;
                String value = prop.getDataTypeString();
                if (value != null) {
                    if (Character.isDigit(name.charAt(0))) {
                        name = "_" + name;
                    }
                    try {
                        this.setAttribute(name, value);
                        continue;
                    }
                    catch (IllegalCharacterDataException ice) {
                        if (name.equals("MacPrintInfo")) continue;
                        throw ice;
                    }
                }
                if (name.equals("LabelFont") || name.equals("LabelFace") || name.equals("LabelSize") || name.equals("LabelColor") || name.equals("CaptionFont") || name.equals("CaptionColor") || name.equals("CaptionSize")) continue;
                throw new RuntimeException("null attVal for " + name);
            }
        }
    }

    void endElement() {
        if (this.propVector != null) {
            CDXProperty[] propArray = this.propVector.toArray(new CDXProperty[0]);
            for (int i = 0; i < propArray.length; ++i) {
                CDXProperty prop = propArray[i];
                String name = prop.getCDXName().trim();
                String value = prop.getDataTypeString();
                if (name.equals("BoundingBox")) {
                    this.processBoundingBox(value);
                    continue;
                }
                if (name.equals("p")) {
                    this.processPoint(value);
                    continue;
                }
                if (name.equals("Text")) {
                    this.processText(value);
                    this.propVector.remove(prop);
                    continue;
                }
                if (name.equals("fonttable")) {
                    this.processFontTable(value);
                    this.propVector.remove(prop);
                    continue;
                }
                if (name.equals("colortable")) {
                    this.processColorTable(value);
                    this.propVector.remove(prop);
                    continue;
                }
                if (!name.trim().endsWith("Style")) continue;
                this.processStyle(name, value);
                this.propVector.remove(prop);
            }
            this.processAttributes();
        }
        this.id = "" + this.getAttributeValue("id");
        this.setAttribute("id", this.id);
        this.removeAttribute("Text");
        this.removeAttribute("fonttable");
        this.removeAttribute("colortable");
        this.removeAttribute("fontStyle");
        this.removeAttribute("LabelStyle");
        this.removeAttribute("CaptionStyle");
        this.cleanBugs();
    }

    private void cleanBugs() {
        Nodes cdxNodes = this.query("//*[local-name()='geometry']");
        for (int i = 0; i < cdxNodes.size(); ++i) {
            if (!(cdxNodes.get(i) instanceof CDXObject)) continue;
            ((CDXObject)cdxNodes.get(i)).fixBugs();
        }
    }

    protected void fixBugs() {
    }

    private void processBoundingBox(String value) {
        BoundingBox bbox = new BoundingBox();
        bbox.setFloatValue(value);
        this.setBoundingBox(bbox);
    }

    private void processPoint(String value) {
        CDXPoint2D point = new CDXPoint2D();
        point.setFloatValue(value);
        this.setPoint2D(point);
    }

    private void processText(String value) {
        int i;
        int idx = value.lastIndexOf("]]");
        Vector<int[]> v = new Vector<int[]>();
        while (value.startsWith("[[")) {
            idx = value.indexOf("]]");
            String vv = value.substring(2, idx);
            value = value.substring(idx + 2);
            StringTokenizer st = new StringTokenizer(vv, " ");
            int[] temp = new int[5];
            for (int i2 = 0; i2 < 5; ++i2) {
                temp[i2] = Integer.parseInt(st.nextToken());
            }
            v.add(temp);
        }
        int nrun = v.size();
        int[] start = new int[nrun];
        for (i = 0; i < nrun; ++i) {
            start[i] = ((int[])v.elementAt(i))[0];
        }
        for (i = 0; i < nrun; ++i) {
            int[] temp = (int[])v.elementAt(i);
            int font = temp[1];
            int face = temp[2];
            int size = temp[3];
            int color = temp[4];
            CDXObject s = new CDXObject("s");
            this.appendChild((Node)s);
            this.processFont(font, face, size, color, s);
            String vv = "";
            vv = i < nrun - 1 ? value.substring(start[i], start[i + 1]) : value.substring(start[i]);
            s.appendChild((Node)new Text(vv));
        }
    }

    private void processFont(int font, int face, int size, int color, CDXObject s) {
        CDXProperty fontProp = CDXProperty.createPropertyByCDXName("fontindex");
        fontProp.setNames("font");
        s.addProperty(fontProp);
        fontProp.setValue(font);
        s.setAttribute("font", "" + font);
        this.setFontFace(face, s);
        this.setFontSize(size, s);
        this.setFontColor(color, s);
    }

    private void setFontFace(int face, CDXObject s) {
        if (face != 0) {
            CDXProperty faceProp = CDXProperty.createPropertyByCDXName("fontface");
            faceProp.setNames("face");
            s.addProperty(faceProp);
            faceProp.setValue(face);
        }
    }

    private void setFontSize(int size, CDXObject s) {
        if (size != 0) {
            CDXProperty sizeProp = CDXProperty.createPropertyByCDXName("fontsize");
            sizeProp.setNames("size");
            s.addProperty(sizeProp);
            sizeProp.setValue(size);
            s.setAttribute("size", "" + size);
        }
    }

    private void setFontColor(int color, CDXObject s) {
        if (color != 0) {
            CDXProperty colorProp = CDXProperty.createPropertyByCDXName("fontcolor");
            colorProp.setNames("color");
            s.addProperty(colorProp);
            colorProp.setValue(color);
            s.setAttribute("color", "" + color);
        }
    }

    private void processFontTable(String value) {
        CDXFontTable fontTable = new CDXFontTable();
        this.appendChild((Node)fontTable);
        StringTokenizer st = new StringTokenizer(value, ";");
        while (st.hasMoreTokens()) {
            CDXObject font = new CDXObject("font");
            fontTable.appendChild((Node)font);
            String ss = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(ss, "/");
            try {
                CDXProperty idProp = CDXProperty.createPropertyByCDXName("id");
                idProp.setValue(Long.parseLong(st1.nextToken()));
                font.addProperty(idProp);
                CDXProperty charsetProp = CDXProperty.createPropertyByCDXName("charset");
                charsetProp.setValue(st1.nextToken());
                font.addProperty(charsetProp);
                CDXProperty fontProp = CDXProperty.createPropertyByCDXName("name");
                fontProp.setValue(st1.nextToken());
                font.addProperty(fontProp);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn((Object)("bad string? :" + e));
            }
        }
    }

    private void processColorTable(String value) {
        CDXColorTable colorTable = new CDXColorTable();
        this.appendChild((Node)colorTable);
        StringTokenizer st = new StringTokenizer(value, ";");
        while (st.hasMoreTokens()) {
            CDXObject color = new CDXObject("color");
            colorTable.appendChild((Node)color);
            String ss = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(ss, " ");
            try {
                CDXProperty rProp = CDXProperty.createPropertyByCDXName("r");
                rProp.setValue((double)Integer.parseInt(st1.nextToken()) / 65535.0);
                color.addProperty(rProp);
                CDXProperty gProp = CDXProperty.createPropertyByCDXName("g");
                gProp.setValue((double)Integer.parseInt(st1.nextToken()) / 65535.0);
                color.addProperty(gProp);
                CDXProperty bProp = CDXProperty.createPropertyByCDXName("b");
                bProp.setValue((double)Integer.parseInt(st1.nextToken()) / 65535.0);
                color.addProperty(bProp);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn((Object)("bad string? :" + e));
            }
        }
    }

    private void processStyle(String name, String value) {
        String foo = name.substring(0, name.length() - "Style".length());
        StringTokenizer st = new StringTokenizer(value, " ");
        int font = Integer.parseInt(st.nextToken());
        int face = Integer.parseInt(st.nextToken());
        int size = Integer.parseInt(st.nextToken());
        int color = Integer.parseInt(st.nextToken());
        try {
            CDXProperty fontProp = CDXProperty.createPropertyByCDXName("fontindex");
            fontProp.setNames(foo + "Font");
            this.addProperty(fontProp);
            fontProp.setValue(font);
            CDXProperty faceProp = CDXProperty.createPropertyByCDXName("fontface");
            faceProp.setNames(foo + "Face");
            this.addProperty(faceProp);
            faceProp.setValue(face);
            if (size != 0) {
                CDXProperty sizeProp = CDXProperty.createPropertyByCDXName("fontsize");
                sizeProp.setNames(foo + "Size");
                this.addProperty(sizeProp);
                sizeProp.setValue(size);
            }
            if (color != 0) {
                CDXProperty colorProp = CDXProperty.createPropertyByCDXName("fontcolor");
                colorProp.setNames(foo + "Color");
                this.addProperty(colorProp);
                colorProp.setValue(color);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("" + e));
        }
    }

    private void setBoundingBox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    void setId(int id) {
        this.id = "" + id;
        this.setAttribute("id", "" + id);
    }

    String getId() {
        if (this.id == null || this.id.trim().equals("")) {
            this.id = this.getAttributeValue("id");
        }
        return this.id;
    }

    private void setPoint2D(CDXPoint2D p) {
        this.p = p;
    }

    CDXPoint2D getPoint2D() {
        String pS;
        if (this.p == null && (pS = this.getAttributeValue("p")) != null) {
            this.processPoint(pS);
        }
        return this.p;
    }

    public void process2CML(CMLElement cmlNode) {
        if (!(this instanceof CDXObject)) {
            LOG.error((Object)("non-CDX object: " + this));
        } else {
            this.processChildren2CML((Node)cmlNode);
        }
    }

    protected void addCDXAttribute(Element to, Element from, String attName) {
        String s = from.getAttributeValue(attName);
        if (s != null && !s.trim().equals("")) {
            CDXObject.setAttribute(to, "cdx:" + attName, s);
        }
    }

    private void processChildren2CML(Node cmlNode) {
        if (cmlNode instanceof Document) {
            this.process2CML((CMLElement)((Document)cmlNode).getRootElement());
        } else if (cmlNode instanceof CMLElement) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Node node = this.getChild(i);
                if (node instanceof CDXObject) {
                    ((CDXObject)this.getChild(i)).process2CML((CMLElement)cmlNode);
                    continue;
                }
                if (node instanceof Text) continue;
                LOG.error((Object)("Unknown node type: " + node.getClass().getName()));
            }
        } else {
            throw new RuntimeException("bad type of node: " + cmlNode);
        }
    }

    void processFontTable() {
        LOG.info((Object)"Ignored fonttable");
    }

    void processColorTable() {
        LOG.info((Object)"Ignored colortable");
    }

    protected void removeAttribute(String attName) {
        Attribute att = this.getAttribute(attName);
        if (att != null) {
            this.removeAttribute(att);
        }
    }

    protected void setAttribute(String attName, String attVal) {
        if (attName != null && attVal != null) {
            try {
                CDXObject.setAttribute(this, attName, attVal);
            }
            catch (IllegalCharacterDataException ice) {
                LOG.debug((Object)("bad characters (" + Integer.toHexString(this.parser.byteCount) + ")in " + attName + " ... " + attVal + " ... " + (Object)((Object)ice)));
            }
        }
    }

    private static void setAttribute(Element elem, String attName, String attVal) {
        try {
            int ipfx = attName.indexOf(":");
            Attribute att = null;
            att = ipfx > 0 ? new Attribute(attName, "http://www.xml-cml/namespaces/cdx", attVal) : new Attribute(attName, attVal);
            elem.addAttribute(att);
        }
        catch (NamespaceConflictException ne) {
            CMLUtil.debug((Element)elem, (String)"CDXOBJECT");
            throw new RuntimeException("bad attribute: " + (Object)((Object)ne) + " ... " + attName);
        }
    }

    public void debug(String msg) {
        CMLUtil.debug((Element)this, (String)msg);
    }

    public String getString() {
        String s = "CDXObject ";
        if (this.codeName != null) {
            s = s + this.codeName.code;
            s = s + "/" + this.codeName.name;
            s = s + "/" + this.codeName.cdxName;
        }
        return s;
    }

    void processMoleculeFragments(CMLElement element) {
        Nodes moleculeFragments = this.query("./fragment[count(*) > count(n[@NodeType])]");
        for (int i = 0; i < moleculeFragments.size(); ++i) {
            CDXObject moleculeFragment = (CDXObject)moleculeFragments.get(i);
            CMLMolecule molecule = new CMLMolecule();
            element.appendChild((Node)molecule);
            ((CDXFragment)moleculeFragment).process2CML(molecule);
            moleculeFragment.copyAttributesTo((CMLElement)molecule);
            this.copyParentIdToMolecule(moleculeFragment, molecule);
            moleculeFragment.detach();
        }
    }

    private void copyParentIdToMolecule(CDXObject moleculeFragment, CMLMolecule molecule) {
        String parentId = ((Element)moleculeFragment.getParent()).getAttributeValue("id");
        molecule.setId(parentId);
    }

    void processFragmentsContainingFragmentNodes(CMLElement element) throws RuntimeException {
        Nodes fragmentFragments = this.query("./fragment[count(*)=1 and count(n) = 1 and n[(@NodeType='Fragment' or @NodeType='AnonymousAlternativeGroup') and count(*)=2 and count(t)=1 and count(fragment)=1]]");
        for (int i = 0; i < fragmentFragments.size(); ++i) {
            CDXObject fragmentFragment = (CDXObject)fragmentFragments.get(i);
            CMLMolecule molecule = new CMLMolecule();
            molecule.setRole("cdx:fragment");
            element.appendChild((Node)molecule);
            this.addLabelToMolecule(fragmentFragment, molecule);
            this.processSubFragment(fragmentFragment, molecule);
            molecule.setId(fragmentFragment.getAttributeValue("id"));
            this.copyParentIdToMolecule(fragmentFragment, molecule);
            fragmentFragment.detach();
        }
    }

    private void addLabelToMolecule(CDXObject fragmentFragment, CMLMolecule molecule) {
        CDXText cdxText = this.getNodeTextGrandChild(fragmentFragment);
        cdxText.addLabelToCMLElement((CMLElement)molecule);
    }

    private CDXText getNodeTextGrandChild(CDXObject fragmentFragment) {
        CDXText cdxText = (CDXText)fragmentFragment.query("./n/t").get(0);
        return cdxText;
    }

    private void processSubFragment(CDXObject fragmentFragment, CMLMolecule molecule) {
        CDXFragment subFragment = (CDXFragment)fragmentFragment.query("./n/fragment").get(0);
        subFragment.process2CML(molecule);
        subFragment.copyAttributesTo((CMLElement)molecule);
    }

    void processFragmentsContainingUnspecfiedNodes(CMLElement cmlElement) throws RuntimeException {
        Nodes labelFragments = this.query("./fragment[count(*)=1 and count(n) = 1 and n[@NodeType='Unspecified' and count(*)=1 and count(t)=1]]");
        for (int i = 0; i < labelFragments.size(); ++i) {
            CDXObject labelFragment = (CDXObject)labelFragments.get(i);
            CDXText cdxText = this.getNodeTextGrandChild(labelFragment);
            cdxText.addLabelToCMLElement(cmlElement);
            labelFragment.detach();
        }
    }

    void processGraphics(CMLElement element) throws RuntimeException {
        Nodes nodes = this.query("./graphic");
        for (int i = 0; i < nodes.size(); ++i) {
            ((CDXGraphic)nodes.get(i)).process2CML(element);
            nodes.get(i).detach();
        }
    }

    void processTexts(CMLElement element) {
        Nodes nodes = this.query("./t");
        for (int i = 0; i < nodes.size(); ++i) {
            CDXText text = (CDXText)nodes.get(i);
            if (text.query("*").size() == 0) {
                text.addLabelToCMLElement(element);
            } else {
                text.process2CML(element);
                LOG.warn((Object)"text child of page is unexpected");
            }
            text.detach();
        }
    }

    void processReactions(CMLElement element) {
        Nodes nodes = this.query("./step");
        for (int i = 0; i < nodes.size(); ++i) {
            CDXObject child = (CDXObject)nodes.get(i);
            CMLReaction reaction = ((CDXReactionStep)child).convertToCMLReaction();
            child.detach();
            element.appendChild((Node)reaction);
        }
    }

    void processLeftOvers(CMLElement element) throws RuntimeException {
        Elements childElements = this.getChildElements();
        boolean curveErrors = false;
        boolean bracketErrors = false;
        for (int i = 0; i < childElements.size(); ++i) {
            if (!(childElements.get(i) instanceof CDXObject)) {
                LOG.error((Object)("Cannot process: " + childElements.get(i)));
                continue;
            }
            CDXObject child = (CDXObject)childElements.get(i);
            if (child instanceof CDXBracketedGroup) {
                if (!bracketErrors) {
                    LOG.error((Object)"Cannot yet deal with bracketed group");
                }
                bracketErrors = true;
                continue;
            }
            if (child instanceof CDXCurve) {
                if (!curveErrors) {
                    LOG.error((Object)"Cannot yet deal with curve");
                }
                curveErrors = true;
                continue;
            }
            if (child instanceof CDXFragment) {
                LOG.error((Object)"******** UNPROCESSED FRAGMENT **********");
                ((CDXFragment)child).process2CML(element);
                continue;
            }
            if (child instanceof CDXReactionScheme) {
                ((CDXReactionScheme)child).process2CML(element);
                continue;
            }
            if (child instanceof CDXArrow) {
                ((CDXArrow)child).process2CML(element);
                continue;
            }
            LOG.error((Object)("******************Unknown or unexpected child of page: " + child.getLocalName()));
        }
    }

    static {
        LOG.setLevel(Level.INFO);
        CODE = 39321;
        NAME = "unknown";
        CDXNAME = "unknown";
    }
}

