/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.chemdraw.components.CDXFragment;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXPoint2D;
import org.xmlcml.cml.chemdraw.components.CDXText;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.molutil.ChemicalElement;

public class CDXNode
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXNode.class);
    public static final int CODE = 32772;
    public static final String NAME = "Node";
    public static final String CDXNAME = "n";
    int DEFAULTELEMENT = 6;
    int element = -999;
    int charge = 0;
    int DEFAULTHYDROGEN;
    int numHydrogens = this.DEFAULTHYDROGEN = -999;

    public CDXNode() {
        super(32772, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXNode(this);
    }

    public CDXNode(CDXNode old) {
        super(old);
    }

    private int getElement() {
        if (this.element < 0) {
            String elementS = this.getAttributeValue("Element");
            this.element = elementS == null || elementS.equals("") ? this.DEFAULTELEMENT : Integer.parseInt(elementS);
        }
        return this.element;
    }

    private int getCharge() {
        String chargeS = this.getAttributeValue("Charge");
        this.charge = chargeS == null || chargeS.equals("") ? 0 : Integer.parseInt(chargeS);
        return this.charge;
    }

    private int getNumHydrogens() {
        String numHydrogensS = this.getAttributeValue("NumHydrogens");
        this.numHydrogens = numHydrogensS == null || numHydrogensS.equals("") ? this.DEFAULTHYDROGEN : Integer.parseInt(numHydrogensS);
        return this.numHydrogens;
    }

    void process2CML(CMLMolecule molecule) {
        CDXPoint2D p2;
        ChemicalElement element;
        int elementNum;
        int charge;
        String atomId = "a" + this.getId();
        CMLAtom atom = molecule.getAtomById(atomId);
        if (atom == null) {
            atom = new CMLAtom(atomId);
            molecule.addAtom(atom);
        }
        if ((charge = this.getCharge()) != 0) {
            atom.setFormalCharge("" + charge);
        }
        if ((elementNum = this.getElement()) < 0) {
            elementNum = this.DEFAULTELEMENT;
        }
        if ((element = ChemicalElement.getElement((int)elementNum)) == null) {
            throw new RuntimeException("Unknown atomic number: " + elementNum);
        }
        atom.setElementType(element.getSymbol());
        int hydrogenCount = this.getNumHydrogens();
        if (hydrogenCount != this.DEFAULTHYDROGEN) {
            atom.setHydrogenCount("" + hydrogenCount);
        }
        if ((p2 = this.getPoint2D()) != null) {
            atom.setX2(p2.getX2());
            atom.setY2(p2.getY2());
            LOG.trace((Object)("COORDS " + atom.getId()));
        }
        this.addCDXAttribute((Element)atom, this, "NodeType");
        Elements childs = this.getChildElements();
        if (childs.size() != 0) {
            if (childs.size() == 1 && childs.get(0) instanceof CDXText) {
                this.processTextChild(atom, (CDXText)childs.get(0));
            } else if (childs.size() == 1) {
                LOG.error((Object)("Unprocessed element: " + childs.get(0).getLocalName()));
            } else if (childs.size() == 2 && childs.get(0) instanceof CDXText && childs.get(1) instanceof CDXFragment) {
                this.processSubFragment(atom, (CDXText)childs.get(0), (CDXFragment)childs.get(1));
            } else if (childs.size() == 2 && childs.get(1) instanceof CDXText && childs.get(0) instanceof CDXFragment) {
                this.processSubFragment(atom, (CDXText)childs.get(1), (CDXFragment)childs.get(0));
            } else {
                for (int i = 0; i < childs.size(); ++i) {
                    CDXObject obj = (CDXObject)childs.get(i);
                    if (obj instanceof CDXFragment) {
                        ((CDXFragment)obj).process2CML(molecule);
                        continue;
                    }
                    if (obj instanceof CDXText) {
                        ((CDXText)obj).process2CML((CMLElement)molecule);
                        continue;
                    }
                    LOG.warn((Object)("*************unusual node child " + obj.getLocalName()));
                }
            }
        }
        this.copyAttributesTo((CMLElement)atom);
    }

    private void processSubFragment(CMLAtom atom, CDXText text, CDXFragment fragment) throws RuntimeException {
        text.addLabelToCMLElement((CMLElement)atom);
        CMLMolecule subMolecule = new CMLMolecule();
        fragment.process2CML(subMolecule);
        atom.appendChild((Node)subMolecule);
    }

    private void processTextChild(CMLAtom atom, CDXText text) throws RuntimeException {
        String eltype;
        String labelText = text.getLabelTextFromTextTempAndSquareBrackets();
        if (!(labelText == null || labelText.trim().equals("") || labelText.equals(eltype = atom.getElementType()) || "H".equals(eltype) && labelText.equals("D"))) {
            if ("GenericNickname".equals(this.getAttributeValue("NodeType"))) {
                text.addLabelToCMLElement((CMLElement)atom);
            } else {
                if (ChemicalElement.getChemicalElement((String)labelText) != null) {
                    CMLUtil.debug((Element)this, (String)"CDXNODE1");
                    throw new RuntimeException("Mismatched elements: " + labelText + "/" + eltype);
                }
                text.addLabelToCMLElement((CMLElement)atom);
            }
        }
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

