/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.components.CDXObject;

public class CDXGroup
extends CDXObject {
    static Logger logger = Logger.getLogger(CDXGroup.class);
    public static final int CODE = 32770;
    public static final String NAME = "Group";
    public static final String CDXNAME = "group";

    public CDXGroup() {
        super(32770, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXGroup(this);
    }

    public CDXGroup(CDXGroup old) {
        super(old);
    }

    @Override
    public String getString() {
        return "[..group..]";
    }

    public void flatten(CDXObject ancestor) {
        Elements childElements = this.getChildElements();
        Attribute groupAttribute = this.createCombinedGroupAttribute();
        for (int j = 0; j < childElements.size(); ++j) {
            Element childElement = childElements.get(j);
            childElement.addAttribute(new Attribute(groupAttribute));
            if (!(childElement instanceof CDXGroup)) {
                childElement.detach();
                ancestor.appendChild((Node)childElement);
                continue;
            }
            ((CDXGroup)childElement).flatten(ancestor);
        }
    }

    private Attribute createCombinedGroupAttribute() {
        Attribute groupAttribute = this.getAttribute(CDXNAME);
        String idValue = this.getAttributeValue("id");
        groupAttribute = groupAttribute == null ? new Attribute(CDXNAME, idValue) : new Attribute(CDXNAME, groupAttribute.getValue() + " " + idValue);
        return groupAttribute;
    }

    private void addCombinedAttribute(Attribute groupAttribute) {
        String attValue = groupAttribute.getValue() + " " + this.getId();
        this.addAttribute(new Attribute(CDXNAME, attValue));
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

