/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.chemdraw.components.CDXArrow;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.element.CMLArray;

public class CDXGraphic
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXGraphic.class);
    public static final int CODE = 32775;
    public static final String NAME = "Graphic";
    public static final String CDXNAME = "graphic";
    private String arrowType = "";
    String lineType = "";
    String graphicType = "";
    static int NDASH;

    public CDXGraphic() {
        super(32775, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXGraphic(this);
    }

    public CDXGraphic(CDXGraphic old) {
        super(old);
    }

    private String getGraphicType() {
        String s = this.getAttributeValue("GraphicType");
        return s == null ? "" : s;
    }

    private String getArrowType() {
        this.arrowType = this.getAttributeValue("ArrowType");
        this.arrowType = this.arrowType == null ? "" : this.arrowType;
        return this.arrowType;
    }

    private String getLineType() {
        String s = this.getAttributeValue("LineType");
        return s == null ? "" : s;
    }

    void createTypes() {
        this.graphicType = this.getGraphicType();
        this.arrowType = this.getArrowType();
        this.lineType = this.getLineType();
    }

    @Override
    public void process2CML(CMLElement element) {
        this.getArrowType();
        if (this.arrowType.equals("FullHead") || this.arrowType.equals("Equilibrium") || this.arrowType.equals("Hollow") || this.arrowType.equals("Retrosynthetic")) {
            CMLArray arrow = CDXArrow.createArrowArray(this);
            element.appendChild((Node)arrow);
        } else {
            LOG.debug((Object)("Unknown arrow: " + this.arrowType));
        }
    }

    static {
        LOG.setLevel(Level.INFO);
        NDASH = 12;
    }
}

