/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Nodes;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.chemdraw.components.CDXBond;
import org.xmlcml.cml.chemdraw.components.CDXGraphic;
import org.xmlcml.cml.chemdraw.components.CDXNode;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXText;
import org.xmlcml.cml.element.AbstractBondStereo;
import org.xmlcml.cml.element.AbstractLabel;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Vector2;

public class CDXFragment
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXFragment.class);
    public static final int CODE = 32771;
    public static final String NAME = "Fragment";
    public static final String CDXNAME = "fragment";
    private static final double SCALE_GROUPS = 0.3;

    public CDXFragment() {
        super(32771, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXFragment(this);
    }

    public CDXFragment(CDXFragment old) {
        super(old);
    }

    void process2CML(CMLMolecule molecule) {
        Elements childElements = this.getChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            CDXObject child = (CDXObject)childElements.get(i);
            if (child instanceof CDXNode) {
                ((CDXNode)child).process2CML(molecule);
                continue;
            }
            if (child instanceof CDXBond) {
                ((CDXBond)child).process2CML(molecule);
                continue;
            }
            if (child instanceof CDXGraphic) {
                LOG.debug((Object)"Skipped graphic");
                ((CDXGraphic)child).process2CML((CMLElement)molecule);
                continue;
            }
            if (child instanceof CDXText) {
                ((CDXText)child).process2CML((CMLElement)molecule);
                continue;
            }
            LOG.error((Object)("Cannot parse fragment child: " + child));
        }
        this.flattenSubGroups(molecule);
    }

    void flattenSubGroups(CMLMolecule molecule) {
        List atomList = molecule.getAtoms();
        for (CMLAtom replacedAtom : atomList) {
            Nodes subMolecules = replacedAtom.query("cml:molecule", CML_XPATH);
            if (subMolecules.size() == 0) continue;
            if (subMolecules.size() > 1) {
                throw new RuntimeException("too many molecule children");
            }
            List parentReplacedAtoms = replacedAtom.getLigandAtoms();
            CMLAtom replacedAtomParent = null;
            if (parentReplacedAtoms.size() == 0) {
                LOG.warn((Object)"too few ligands of replaced atom");
            } else if (parentReplacedAtoms.size() > 1) {
                replacedAtomParent = (CMLAtom)parentReplacedAtoms.get(0);
                LOG.warn((Object)("too many ligands of replaced atom: " + replacedAtom.getId()));
            } else {
                replacedAtomParent = (CMLAtom)parentReplacedAtoms.get(0);
            }
            CMLMolecule subMolecule = (CMLMolecule)subMolecules.get(0);
            Nodes atoms = subMolecule.query("cml:atomArray/cml:atom[@*[local-name()='NodeType' and .='ExternalConnectionPoint']]", CML_XPATH);
            CMLAtom extensionAtom = null;
            if (atoms.size() == 0) {
                LOG.warn((Object)"too few extension points");
            } else if (atoms.size() > 1) {
                LOG.warn((Object)("too many extension points: " + atoms.size()));
            }
            if (atoms.size() <= 0) continue;
            extensionAtom = (CMLAtom)atoms.get(0);
            List extensionLigandAtoms = extensionAtom.getLigandAtoms();
            if (extensionLigandAtoms.size() == 0 || extensionLigandAtoms.size() > 1) {
                throw new RuntimeException("too few/many ligands of extension points");
            }
            CMLAtom replacingAtom = (CMLAtom)extensionLigandAtoms.get(0);
            this.replaceAtomsAndBonds(molecule, replacedAtom, replacedAtomParent, subMolecule, extensionAtom, replacingAtom);
        }
    }

    private void replaceAtomsAndBonds(CMLMolecule molecule, CMLAtom replacedAtom, CMLAtom replacedAtomParent, CMLMolecule subMolecule, CMLAtom extensionAtom, CMLAtom replacingAtom) {
        this.moveLabelFromStaticAtomToGroup(replacedAtom, replacingAtom);
        this.scaleAndMoveGroup(replacedAtomParent, subMolecule, replacingAtom);
        CMLBond replacedBond = this.transferAtomsAndBondsFromGroup(molecule, replacedAtom, replacedAtomParent, subMolecule, extensionAtom, replacingAtom);
        this.createAndAddNewBond(molecule, replacedAtomParent, replacingAtom, replacedBond);
    }

    private void createAndAddNewBond(CMLMolecule molecule, CMLAtom replacedAtomParent, CMLAtom replacingAtom, CMLBond replacedBond) {
        if (replacedBond != null) {
            CMLBondStereo bondStereo = replacedBond.getBondStereo();
            String order = replacedBond.getOrder();
            if (replacedAtomParent != null) {
                CMLBond newBond = new CMLBond();
                newBond.setAtomRefs2(new String[]{replacedAtomParent.getId(), replacingAtom.getId()});
                if (bondStereo != null) {
                    newBond.addBondStereo((AbstractBondStereo)bondStereo);
                }
                newBond.setOrder(order);
                molecule.addBond(newBond);
            }
        }
    }

    private CMLBond transferAtomsAndBondsFromGroup(CMLMolecule molecule, CMLAtom replacedAtom, CMLAtom replacedAtomParent, CMLMolecule subMolecule, CMLAtom extensionAtom, CMLAtom replacingAtom) {
        CMLBond replacedBond = molecule.getBond(replacedAtom, replacedAtomParent);
        CMLBond extensionBond = subMolecule.getBond(extensionAtom, replacingAtom);
        List subMoleculeBonds = subMolecule.getBonds();
        List subMoleculeAtoms = subMolecule.getAtoms();
        for (CMLBond subMoleculeBond : subMoleculeBonds) {
            subMolecule.deleteBond(subMoleculeBond);
        }
        for (CMLAtom subMoleculeAtom : subMoleculeAtoms) {
            subMolecule.deleteAtom(subMoleculeAtom);
        }
        molecule.deleteBond(replacedBond);
        molecule.deleteAtom(replacedAtom);
        for (CMLAtom subMoleculeAtom : subMoleculeAtoms) {
            if (subMoleculeAtom.equals((Object)extensionAtom)) continue;
            molecule.addAtom(subMoleculeAtom);
        }
        for (CMLBond subMoleculeBond : subMoleculeBonds) {
            if (subMoleculeBond.equals((Object)extensionBond)) continue;
            molecule.addBond(subMoleculeBond);
        }
        return replacedBond;
    }

    private void moveLabelFromStaticAtomToGroup(CMLAtom replacedAtom, CMLAtom replacingAtom) {
        CMLLabel label;
        Nodes labelNodes = replacedAtom.query("./cml:label", CMLConstants.CML_XPATH);
        CMLLabel cMLLabel = label = labelNodes.size() >= 1 ? (CMLLabel)labelNodes.get(0) : null;
        if (label != null) {
            label.detach();
            replacingAtom.addLabel((AbstractLabel)label);
        }
    }

    private void scaleAndMoveGroup(CMLAtom replacedAtomParent, CMLMolecule subMolecule, CMLAtom replacingAtom) {
        if (replacedAtomParent != null) {
            Real2 replacedXY2 = replacedAtomParent.getXY2();
            Real2 replacingXY2 = replacingAtom.getXY2();
            Vector2 bondVector = new Vector2(replacedXY2.subtract(replacingXY2));
            bondVector = new Vector2(bondVector.multiplyBy(0.3));
            Real2 newXY2 = replacingXY2.plus((Real2)bondVector);
            subMolecule.multiply2DCoordsBy(0.3);
            Real2 newReplacingXY2 = replacingAtom.getXY2();
            Vector2 translateXY2 = new Vector2(newXY2.subtract(newReplacingXY2));
            subMolecule.translate2D((Real2)translateXY2);
        }
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

