/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.components.CDXUtil;

public class CDXCoordinate
implements CDXConstants {
    static Logger LOG = Logger.getLogger(CDXCoordinate.class);
    int x;
    double xx;

    public CDXCoordinate() {
    }

    public CDXCoordinate(String point) throws IllegalArgumentException {
        try {
            int x0 = Integer.parseInt(point);
            this.init(x0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad coordinate string: " + point);
        }
    }

    public CDXCoordinate(int x) {
        this.init(x);
    }

    private void init(int x) {
        this.x = x;
        this.xx = (double)x / 65536.0;
        this.xx = (double)((int)(10000.0 * this.xx)) / 10000.0;
    }

    String getAttributeValue() {
        return "" + CDXUtil.trimFloat(this.xx);
    }

    public String toString() {
        return "" + CDXUtil.trimFloat(this.xx);
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

