/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLMolecule;

public class CDXBond
extends CDXObject {
    static Logger LOG = Logger.getLogger(CDXBond.class);
    public static final int CODE = 32773;
    public static final String NAME = "Bond";
    public static final String CDXNAME = "b";

    public CDXBond() {
        super(32773, NAME, CDXNAME);
    }

    @Override
    public Element copy() {
        return new CDXBond(this);
    }

    public CDXBond(CDXBond old) {
        super(old);
    }

    private String getDisplay() {
        String s = this.getAttributeValue("Display");
        return s == null ? "" : s;
    }

    protected void process2CML(CMLMolecule molecule) {
        String display = this.getDisplay();
        CMLBond bond = null;
        String b = this.getAttributeValue("B");
        String e = this.getAttributeValue("E");
        if (b == null || e == null) {
            LOG.error((Object)("Bond has no atoms: " + this.getAttributeValue("id")));
            return;
        }
        String atomRef1 = "a" + b;
        String atomRef2 = "a" + e;
        LOG.trace((Object)("bond... (" + atomRef1 + "/" + atomRef2 + ")"));
        String newDisplay = this.newWedgeBondDisplay(display);
        if (!newDisplay.equals(display)) {
            String temp = atomRef1;
            atomRef1 = atomRef2;
            atomRef2 = temp;
            display = newDisplay;
        }
        try {
            CMLAtom atom1 = this.getOrCreateAndAddAtom(molecule, atomRef1);
            CMLAtom atom2 = this.getOrCreateAndAddAtom(molecule, atomRef2);
            if (molecule.getBond(atom1, atom2) != null) {
                LOG.warn((Object)(" duplicate bond: " + atomRef1 + "/" + atomRef2));
            } else if (atomRef1.equals(atomRef2)) {
                CMLUtil.debug((Element)this, (String)"CDXBOND");
                LOG.error((Object)("identical atoms in bond: " + atomRef1));
            } else {
                bond = new CMLBond(atom1, atom2);
                molecule.addBond(bond);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (bond != null) {
            CMLBondStereo bondStereo;
            if (display.equals("WedgedHashBegin") || display.equals("WedgeBegin")) {
                bondStereo = new CMLBondStereo();
                bondStereo.setXMLContent(display.equals("WedgedHashBegin") ? "H" : "W");
                bond.appendChild((Node)bondStereo);
            } else if (display.equals("Hash")) {
                bondStereo = new CMLBondStereo();
                bondStereo.setXMLContent("HASH?");
                bond.appendChild((Node)bondStereo);
            } else if (display.equals("Bold")) {
                bondStereo = new CMLBondStereo();
                bondStereo.setXMLContent("BOLD?");
                bond.appendChild((Node)bondStereo);
            }
            String order = this.getAttributeValue("Order");
            order = CDXBond.transformOrder(order);
            bond.setOrder(order);
            this.addCDXAttribute((Element)bond, this, "EndAttach");
            if (this.query("*").size() > 0) {
                throw new RuntimeException("Unexpected bond children");
            }
            this.copyAttributesTo((CMLElement)bond);
        }
    }

    private static String transformOrder(String order) {
        String oo = "1";
        if (order != null && !order.equals("")) {
            oo = order.equals("1.5") ? "A" : order;
        }
        return oo;
    }

    private CMLAtom getOrCreateAndAddAtom(CMLMolecule molecule, String atomRef) {
        CMLAtom atom = molecule.getAtomById(atomRef);
        if (atom == null) {
            LOG.trace((Object)("bond requires undeclared atom: " + atomRef));
            atom = new CMLAtom(atomRef);
            molecule.addAtom(atom);
        }
        return atom;
    }

    private String newWedgeBondDisplay(String display) {
        String newDisplay = display;
        if (display.equals("WedgedHashEnd")) {
            newDisplay = "WedgedHashBegin";
        } else if (display.equals("WedgeEnd")) {
            newDisplay = "WedgeBegin";
        } else if (display.equals("HollowWedgeEnd")) {
            newDisplay = "HollowWedgeBegin";
        } else if (display.equals("WavyWedgeEnd")) {
            newDisplay = "WavyWedgeBegin";
        } else if (display.equals("Bold")) {
            newDisplay = "Bold";
        }
        return newDisplay;
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

