/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw.components;

import java.util.StringTokenizer;

public class BoundingBox {
    public static final String TAG = "BoundingBox";
    double x0;
    double x1;
    double y0;
    double y1;

    public BoundingBox() {
    }

    public BoundingBox(BoundingBox bbox) {
        this(bbox.x0, bbox.x1, bbox.y0, bbox.y1);
    }

    public BoundingBox(double x0, double x1, double y0, double y1) {
        this.setFloatValue(x0, x1, y0, y1);
    }

    private void setFloatValue(double x0, double x1, double y0, double y1) {
        this.x0 = x0;
        this.x1 = x1;
        this.y0 = y0;
        this.y1 = y1;
    }

    void setFloatValue(String rectS) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(rectS);
        if (st.countTokens() != 4) {
            throw new IllegalArgumentException("Rectangle string must have 4 elements: " + rectS);
        }
        try {
            this.x0 = new Double(st.nextToken());
            this.y0 = new Double(st.nextToken());
            this.x1 = new Double(st.nextToken());
            this.y1 = new Double(st.nextToken());
            this.setFloatValue(this.x0, this.x1, this.y0, this.y1);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad float in rectangle string: " + rectS);
        }
    }

    public String getString() {
        String s = "";
        s = s + "x1 = " + this.x0 + ", ";
        s = s + "x2 = " + this.x1 + ", ";
        s = s + "y1 = " + this.y0 + ", ";
        s = s + "y2 = " + this.y1;
        return s;
    }
}

