/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw;

import java.util.HashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.components.CDXArrow;
import org.xmlcml.cml.chemdraw.components.CDXBond;
import org.xmlcml.cml.chemdraw.components.CDXBracketAttachment;
import org.xmlcml.cml.chemdraw.components.CDXBracketedGroup;
import org.xmlcml.cml.chemdraw.components.CDXColorTable;
import org.xmlcml.cml.chemdraw.components.CDXCurve;
import org.xmlcml.cml.chemdraw.components.CDXFontTable;
import org.xmlcml.cml.chemdraw.components.CDXFragment;
import org.xmlcml.cml.chemdraw.components.CDXGeometry;
import org.xmlcml.cml.chemdraw.components.CDXGraphic;
import org.xmlcml.cml.chemdraw.components.CDXGroup;
import org.xmlcml.cml.chemdraw.components.CDXList;
import org.xmlcml.cml.chemdraw.components.CDXML;
import org.xmlcml.cml.chemdraw.components.CDXNode;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXObjectTag;
import org.xmlcml.cml.chemdraw.components.CDXPage;
import org.xmlcml.cml.chemdraw.components.CDXReactionScheme;
import org.xmlcml.cml.chemdraw.components.CDXReactionStep;
import org.xmlcml.cml.chemdraw.components.CDXText;

public class XMLToCDXMLConverter {
    private static Logger LOG = Logger.getLogger(XMLToCDXMLConverter.class);
    static Map<String, Class<?>> classMap;

    public Element convertToCDXObject(Element cdxml) {
        Element element = this.getCDXObject(cdxml);
        return element;
    }

    private Element getCDXObject(Element oldElement) {
        int i;
        String localName = oldElement.getLocalName();
        Class<?> theClass = classMap.get(localName);
        if (theClass == null) {
            System.err.println("******************Cannot find class for: " + localName);
            return oldElement.copy();
        }
        String className = "";
        Element newElement = null;
        try {
            if (CDXObject.class.isAssignableFrom(theClass)) {
                newElement = (Element)theClass.newInstance();
            } else {
                LOG.debug((Object)("non CDX element " + localName));
                newElement = new Element(localName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create object from: " + localName + " to " + className + " because " + e.getMessage());
        }
        for (i = 0; i < oldElement.getAttributeCount(); ++i) {
            newElement.addAttribute(new Attribute(oldElement.getAttribute(i)));
        }
        for (i = 0; i < oldElement.getChildCount(); ++i) {
            Node node = oldElement.getChild(i);
            if (node instanceof Element) {
                Element child = this.getCDXObject((Element)node);
                newElement.appendChild((Node)child);
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                ProcessingInstruction pi = new ProcessingInstruction((ProcessingInstruction)node);
                newElement.appendChild((Node)pi);
                continue;
            }
            if (node instanceof Comment) {
                Comment comment = new Comment((Comment)node);
                newElement.appendChild((Node)comment);
                continue;
            }
            if (node instanceof Text) {
                Text text = new Text((Text)node);
                newElement.appendChild((Node)text);
                continue;
            }
            throw new RuntimeException("Unsupported XML object: " + node);
        }
        return newElement;
    }

    static {
        LOG.setLevel(Level.INFO);
        classMap = new HashMap();
        String base = new XMLToCDXMLConverter().getClass().getPackage().getName();
        try {
            classMap.put("arrow", CDXArrow.class);
            classMap.put("b", CDXBond.class);
            classMap.put("bracketattachment", CDXBracketAttachment.class);
            classMap.put("bracketedgroup", CDXBracketedGroup.class);
            classMap.put("colortable", CDXColorTable.class);
            classMap.put("curve", CDXCurve.class);
            classMap.put("fonttable", CDXFontTable.class);
            classMap.put("fragment", CDXFragment.class);
            classMap.put("geometry", CDXGeometry.class);
            classMap.put("graphic", CDXGraphic.class);
            classMap.put("group", CDXGroup.class);
            classMap.put("cdxList", CDXList.class);
            classMap.put("CDXML", CDXML.class);
            classMap.put("n", CDXNode.class);
            classMap.put("objecttag", CDXObjectTag.class);
            classMap.put("page", CDXPage.class);
            classMap.put("scheme", CDXReactionScheme.class);
            classMap.put("step", CDXReactionStep.class);
            classMap.put("t", CDXText.class);
            classMap.put("color", Element.class);
            classMap.put("font", Element.class);
            classMap.put("object", Element.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set up classMap in: " + base);
        }
    }
}

