/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw;

import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.chemdraw.CDXConstants;
import org.xmlcml.cml.chemdraw.CDXML2CMLProcessor;
import org.xmlcml.cml.element.AbstractLabel;
import org.xmlcml.cml.element.AbstractMolecule;
import org.xmlcml.cml.element.AbstractProduct;
import org.xmlcml.cml.element.AbstractReactant;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLProduct;
import org.xmlcml.cml.element.CMLProductList;
import org.xmlcml.cml.element.CMLReactant;
import org.xmlcml.cml.element.CMLReactantList;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.euclid.Real2Range;

public class ChemDrawReactionConverter
implements CDXConstants {
    static Logger LOG = Logger.getLogger(ChemDrawReactionConverter.class);
    CMLElement scopeElement = null;
    CMLElement reaction = null;
    CMLProductList productList;
    CMLReactantList reactantList;

    public ChemDrawReactionConverter(CMLReaction reaction, CMLElement scopeElement) {
        this.reaction = reaction;
        LOG.debug((Object)("REACTION " + reaction));
        this.scopeElement = scopeElement;
    }

    public void processAfterParsing() {
        this.addMoleculeRefsToReactants(this.reactantList);
        this.addMoleculeRefsToProducts(this.productList);
        this.processReactionStepArrowsAndText();
    }

    void processReactionStepArrowsAndText() {
        String reactionStepArrows = this.reaction.getAttributeValue("ReactionStepArrows", "http://www.xml-cml/namespaces/cdx");
        if (reactionStepArrows != null) {
            if ((reactionStepArrows = reactionStepArrows.trim()).indexOf(" ") != -1) {
                LOG.warn((Object)"Cannot yet deal with multiple reaction step arrows");
            } else {
                Nodes nodes = this.scopeElement.query("./cml:scalar[@id='" + reactionStepArrows + "']", CML_XPATH);
                if (nodes.size() == 1) {
                    CMLScalar arrow = (CMLScalar)nodes.get(0);
                    Real2Range boundingBox = CDXML2CMLProcessor.getNormalizedBoundingBox((CMLElement)arrow);
                    if (boundingBox == null) {
                        LOG.error((Object)"null boundingBox");
                    } else {
                        Nodes labelNodes = this.scopeElement.query("./cml:label", CML_XPATH);
                        List<CMLLabel> labels = CDXML2CMLProcessor.getVerticalLabels((Element)this.scopeElement, labelNodes, boundingBox, 50.0, -50.0, 6, 9);
                        labels = CDXML2CMLProcessor.sortLabelsByY(labels);
                        for (CMLLabel label : labels) {
                            LOG.debug((Object)("L " + label.getCMLValue()));
                            label.addAttribute(new Attribute("convention", "cml:reaction-components"));
                        }
                    }
                    arrow.detach();
                } else {
                    LOG.error((Object)"Cannot find graphic arrow");
                }
            }
        } else {
            LOG.info((Object)"no reactionStepArrows");
        }
    }

    private void addMoleculeRefsToReactants(CMLReactantList reactantList) throws RuntimeException {
        String reactantS = this.reaction.getAttributeValue("ReactionStepReactants", "http://www.xml-cml/namespaces/cdx");
        if (reactantS == null) {
            throw new RuntimeException("Null reactant String");
        }
        String[] reactantIds = reactantS.split(" ");
        reactantList = new CMLReactantList();
        this.reaction.appendChild((Node)reactantList);
        for (String id : reactantIds) {
            Nodes nodes = this.findNodesWithIds(this.scopeElement, id);
            if (nodes.size() == 0) continue;
            if (nodes.get(0) instanceof CMLMolecule) {
                CMLMolecule refMolecule = new CMLMolecule();
                refMolecule.setRef(id);
                CMLReactant reactant = new CMLReactant();
                reactantList.addReactant((AbstractReactant)reactant);
                reactant.addMolecule((AbstractMolecule)refMolecule);
                this.addRoleAndLabel((CMLMolecule)nodes.get(0), refMolecule);
                continue;
            }
            if (nodes.get(0) instanceof CMLLabel) {
                LOG.error((Object)("Cannot use label as reactant: " + id));
                continue;
            }
            throw new RuntimeException("unexpected reactant: " + id);
        }
    }

    private Nodes findNodesWithIds(CMLElement element, String id) {
        Nodes nodes = element.query("//*[@id='" + id + "']");
        if (nodes.size() == 0) {
            LOG.error((Object)("********Cannot find molecule or label: " + id));
        }
        return nodes;
    }

    private void addRoleAndLabel(CMLMolecule molecule, CMLMolecule refMolecule) throws RuntimeException {
        CMLElements labelList;
        if ("cdx:fragment".equals(molecule.getRole())) {
            refMolecule.setRole("reagent");
        }
        if ((labelList = molecule.getLabelElements()).size() > 0) {
            CMLLabel label = new CMLLabel((CMLLabel)labelList.get(0));
            label.removeAttribute("id");
            refMolecule.addLabel((AbstractLabel)label);
        }
    }

    private void addMoleculeRefsToProducts(CMLProductList productList) throws RuntimeException {
        String productS = this.reaction.getAttributeValue("ReactionStepProducts", "http://www.xml-cml/namespaces/cdx");
        if (productS == null) {
            throw new RuntimeException("Null product String");
        }
        String[] productIds = productS.split(" ");
        productList = new CMLProductList();
        this.reaction.appendChild((Node)productList);
        for (String id : productIds) {
            Nodes nodes = this.findNodesWithIds(this.scopeElement, id);
            if (nodes.size() == 0) continue;
            if (nodes.get(0) instanceof CMLMolecule) {
                CMLMolecule refMolecule = new CMLMolecule();
                refMolecule.setRef(id);
                CMLProduct product = new CMLProduct();
                productList.addProduct((AbstractProduct)product);
                product.addMolecule((AbstractMolecule)refMolecule);
                this.addRoleAndLabel((CMLMolecule)nodes.get(0), refMolecule);
                continue;
            }
            if (nodes.get(0) instanceof CMLLabel) {
                LOG.warn((Object)("Cannot use label as product: " + id));
                continue;
            }
            throw new RuntimeException("unexpected product: " + id);
        }
    }

    protected String getPrefix() {
        return null;
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

