/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.chemdraw.ChemDrawReactionConverter;
import org.xmlcml.cml.chemdraw.XMLToCDXMLConverter;
import org.xmlcml.cml.chemdraw.components.CDXColorTable;
import org.xmlcml.cml.chemdraw.components.CDXFontTable;
import org.xmlcml.cml.chemdraw.components.CDXList;
import org.xmlcml.cml.chemdraw.components.CDXML;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXPage;
import org.xmlcml.cml.chemdraw.components.CDXReactionStep;
import org.xmlcml.cml.chemdraw.components.CDXText;
import org.xmlcml.cml.chemdraw.components.CDXUtil;
import org.xmlcml.cml.element.AbstractBondStereo;
import org.xmlcml.cml.element.AbstractLabel;
import org.xmlcml.cml.element.AbstractMolecule;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLCml;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLMoleculeList;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.tools.AtomSetTool;
import org.xmlcml.cml.tools.GeometryTool;
import org.xmlcml.cml.tools.MoleculeTool;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Util;

public class CDXML2CMLProcessor {
    static final Logger LOG = Logger.getLogger(CDXML2CMLProcessor.class);
    static final double BOND_LENGTH = 2.0;
    private CDXObject rootCDXObject;
    private CDXList cdxList;
    private CDXObject page;
    private CMLCml cmlCml = null;
    private boolean cleanMolecules = true;
    private boolean flatten = true;
    private boolean rescale = true;
    private boolean removeCDXAttributes = true;

    public boolean isRemoveCDXAttributes() {
        return this.removeCDXAttributes;
    }

    public void setRemoveCDXAttributes(boolean removeCDXAttributes) {
        this.removeCDXAttributes = removeCDXAttributes;
    }

    public void convertParsedXMLToCML(Element cdxml) {
        XMLToCDXMLConverter xml2cdxmlConverter = new XMLToCDXMLConverter();
        this.rootCDXObject = (CDXObject)xml2cdxmlConverter.convertToCDXObject(cdxml);
        try {
            if (!(this.rootCDXObject instanceof CDXList)) {
                throw new RuntimeException("expected cdxList as root element");
            }
            this.cdxList = (CDXList)this.rootCDXObject;
            this.cdxList.setChemDrawConverterRecursively(this);
            cdxml = null;
            if (this.cdxList.getChildElements().size() == 0) {
                LOG.warn((Object)"cdxList has no children");
            }
            for (int j = 0; j < this.cdxList.getChildElements().size(); ++j) {
                CDXObject obj = (CDXObject)this.cdxList.getChildElements().get(j);
                if (obj instanceof CDXML) {
                    cdxml = (CDXML)this.cdxList.getChildElements().get(0);
                    continue;
                }
                if ("object".equals(obj.getLocalName())) {
                    LOG.error((Object)"*********** Uninterpreted object in cdxList");
                    continue;
                }
                throw new RuntimeException("unexpected child of cdxList: " + obj.getLocalName());
            }
            if (cdxml == null) {
                LOG.error((Object)"Cannot find CDXML element");
            } else {
                this.convertCDXML(cdxml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)e);
        }
    }

    public CMLElement getCML() {
        return this.cmlCml;
    }

    private void convertCDXML(Element cdxml) {
        int pageCount = 0;
        this.page = null;
        for (int i = 0; i < cdxml.getChildElements().size(); ++i) {
            CDXObject child = (CDXObject)cdxml.getChildElements().get(i);
            if (child instanceof CDXColorTable || child instanceof CDXFontTable) continue;
            if (child instanceof CDXPage) {
                if (pageCount > 0) {
                    throw new RuntimeException("Only one page allowed");
                }
                ++pageCount;
                this.page = (CDXObject)cdxml.getChildElements().get(0);
                continue;
            }
            if (child instanceof CDXML) {
                LOG.error((Object)"**************Cannot process nested CDXML");
                continue;
            }
            if (child.getLocalName().equals("object")) {
                LOG.error((Object)"Unexpected CDXML child 'object'");
                continue;
            }
            throw new RuntimeException("Unexpected CDXML child: " + child.getLocalName());
        }
        if (this.page != null) {
            this.tidyToCML();
        }
    }

    private void tidyToCML() {
        this.cmlCml = new CMLCml();
        this.cmlCml.addNamespaceDeclaration("cdx", "http://www.xml-cml/namespaces/cdx");
        this.expandFontInfo(this.page);
        this.page.process2CML((CMLElement)this.cmlCml);
        CDXML2CMLProcessor.addLabelsToMolecules((CMLElement)this.cmlCml);
        this.addHydrogenAtomsToMolecules();
        this.processReactionsNew();
        this.cleanRedundantHierarchy();
        this.transformRGroups();
        this.addLabelsToAtoms();
        this.removeCDXAttributes = true;
        if (this.removeCDXAttributes) {
            this.removeCDXAttributes();
        }
        if (this.cleanMolecules) {
            this.flattenGroupingElements();
            this.removeAtomsWithChildrenExcludingLabels();
            this.removeAtomsWithoutElementTypeOrCoordinates();
            this.cleanExternalConnectionPoints();
        }
        this.flipAndRescaleMolecules();
        if (LOG.isDebugEnabled()) {
            CMLUtil.debug((Element)this.cmlCml, (String)"==cmlCML==");
        }
        this.ensureXMLIds(this.cmlCml);
        this.groupMultipleMolecules();
        this.removeDeadCDXObjects();
    }

    private void removeDeadCDXObjects() {
        Nodes groups = this.cmlCml.query("//*[local-name()='group' and (.='')]");
        for (int i = 0; i < groups.size(); ++i) {
            groups.get(i).detach();
        }
    }

    private void groupMultipleMolecules() {
        Nodes molecules = this.cmlCml.query("cml:molecule", CMLConstants.CML_XPATH);
        if (molecules.size() > 1) {
            CMLMoleculeList moleculeList = new CMLMoleculeList();
            for (int i = 0; i < molecules.size(); ++i) {
                CMLMolecule molecule = (CMLMolecule)molecules.get(i);
                molecule.detach();
                moleculeList.addMolecule((AbstractMolecule)molecule);
            }
            this.cmlCml.appendChild((Node)moleculeList);
        }
    }

    private void ensureXMLIds(CMLCml cmlCml) {
        Nodes ids = cmlCml.query("//@id");
        for (int i = 0; i < ids.size(); ++i) {
            Attribute idAtt = (Attribute)ids.get(i);
            String value = idAtt.getValue();
            value = CDXUtil.ensureXMLID(value);
            idAtt.setValue(value);
        }
    }

    private void flattenGroupingElement(Nodes nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            CMLElement element = (CMLElement)nodes.get(i);
            this.transferChildrenToParent((Element)element);
            element.detach();
        }
    }

    private void removeAtomsWithChildrenExcludingLabels() {
        if (this.cmlCml != null) {
            Nodes atoms = this.cmlCml.query("//cml:atom/*[not(local-name()='label')]", CMLConstants.CML_XPATH);
            for (int i = 0; i < atoms.size(); ++i) {
                CMLAtom atom = (CMLAtom)atoms.get(i);
                atom.detach();
            }
        }
    }

    private void removeAtomsWithoutElementTypeOrCoordinates() {
        if (this.cmlCml != null) {
            Nodes atoms = this.cmlCml.query("//cml:atom[not(@elementType) or not(@x2) or not(@y2)]", CMLConstants.CML_XPATH);
            for (int i = 0; i < atoms.size(); ++i) {
                atoms.get(i).detach();
            }
        }
    }

    private void flipAndRescaleMolecules() {
        if (this.cmlCml != null) {
            Nodes molecules = this.cmlCml.query("//cml:molecule", CMLConstants.CML_XPATH);
            for (int i = 0; i < molecules.size(); ++i) {
                this.scale((CMLMolecule)molecules.get(i));
            }
        }
    }

    private void scale(CMLMolecule molecule) {
        if (molecule.query(".//cml:molecule", CMLConstants.CML_XPATH).size() == 0) {
            try {
                double bb = MoleculeTool.getAverageBondLength(molecule, CMLElement.CoordinateType.TWOD, false);
                double scale = this.rescale ? 2.0 / bb : 1.0;
                Transform2 transform = new Transform2(new double[]{scale, 0.0, 0.0, 0.0, -scale, 0.0, 0.0, 0.0, 1.0});
                MoleculeTool.transform(molecule, transform);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void processReactions() {
        Nodes reactionNodes = this.cmlCml.query("//cml:reaction", CMLConstants.CML_XPATH);
        for (int i = 0; i < reactionNodes.size(); ++i) {
            CMLReaction reaction = (CMLReaction)reactionNodes.get(i);
            ChemDrawReactionConverter chemDrawReactionConverter = new ChemDrawReactionConverter(reaction, (CMLElement)this.cmlCml);
            chemDrawReactionConverter.processAfterParsing();
        }
        if (LOG.isDebugEnabled()) {
            CMLUtil.debug((Element)this.cmlCml, (String)"cmlCml");
        }
    }

    private void processReactionsNew() {
        Nodes reactionNodes = this.cmlCml.query("//cml:reaction", CMLConstants.CML_XPATH);
        for (int i = 0; i < reactionNodes.size(); ++i) {
            CMLReaction reaction = (CMLReaction)reactionNodes.get(i);
            CDXReactionStep.processReactionStep(reaction);
        }
    }

    private void addHydrogenAtomsToMolecules() {
        Nodes nodes = this.cmlCml.query("//cml:molecule", CMLConstants.CML_XPATH);
        for (int i = 0; i < nodes.size(); ++i) {
            CMLMolecule molecule = (CMLMolecule)nodes.get(i);
            this.addHydrogens(molecule);
        }
    }

    private void addHydrogens(CMLMolecule molecule) {
        MoleculeTool.adjustHydrogenCountsToValency(molecule, CMLMolecule.HydrogenControl.USE_HYDROGEN_COUNT);
        GeometryTool.addCalculatedCoordinatesForHydrogens(molecule, CMLElement.CoordinateType.TWOD, CMLMolecule.HydrogenControl.USE_EXPLICIT_HYDROGENS);
    }

    private void transformRGroups() {
        Nodes atomNodes = this.cmlCml.query("//cml:atom[@elementType='C' and cml:label]", CMLConstants.CML_XPATH);
        for (int i = 0; i < atomNodes.size(); ++i) {
            CMLAtom atom = (CMLAtom)atomNodes.get(i);
            CMLLabel label = (CMLLabel)atom.getLabelElements().get(0);
            String labelS = label.getCMLValue();
            LOG.debug((Object)("LAB... " + labelS));
            if (labelS.equals("R")) {
                atom.setElementType("R");
                label.detach();
                continue;
            }
            if (labelS.equals("C") || labelS.equals("C-") || labelS.equals("C+")) continue;
            atom.setElementType("R");
        }
    }

    private void addLabelsToAtoms() {
        Nodes labelNodes = this.cmlCml.query("/cml:cml/cml:label", CMLConstants.CML_XPATH);
        for (int i = 0; i < labelNodes.size(); ++i) {
            CMLAtom atom;
            int fontSize;
            CMLLabel label = (CMLLabel)labelNodes.get(i);
            String fontSizeS = label.getAttributeValue("size", "http://www.xml-cml/namespaces/cdx");
            if (fontSizeS == null || (fontSize = Integer.parseInt(fontSizeS)) > 5 || (atom = this.getNearestAtom(label)) == null) continue;
            label.detach();
            atom.addLabel((AbstractLabel)label);
        }
    }

    private CMLAtom getNearestAtom(CMLLabel label) {
        CMLAtom closestAtom = null;
        String p = label.getAttributeValue("p", "http://www.xml-cml/namespaces/cdx");
        if (p != null) {
            try {
                double[] dd = Util.splitToDoubleArray((String)p);
                Real2 point = new Real2(dd);
                Nodes moleculeNodes = this.cmlCml.query("//cml:molecule", CMLConstants.CML_XPATH);
                double closestDist = Double.MAX_VALUE;
                for (int i = 0; i < moleculeNodes.size(); ++i) {
                    double dist;
                    CMLMolecule molecule = (CMLMolecule)moleculeNodes.get(i);
                    CMLAtom atom = AtomSetTool.getNearestAtom(molecule, point);
                    if (atom == null || !((dist = atom.getXY2().getDistance(point)) < closestDist)) continue;
                    closestDist = dist;
                    closestAtom = atom;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return closestAtom;
    }

    private void cleanRedundantHierarchy() {
        int i;
        Nodes nodes = this.cmlCml.query("/cml:cml", CMLConstants.CML_XPATH);
        if (nodes.size() != 1) {
            throw new RuntimeException("need exactly one toplevel cml");
        }
        CMLCml cmlCml = (CMLCml)nodes.get(0);
        nodes = cmlCml.query("//cml:moleculeList[count(cml:molecule)=1]", CMLConstants.CML_XPATH);
        this.flattenGroupingElement(nodes);
        nodes = cmlCml.query("//cml:moleculeList[count(cml:molecule)=0]", CMLConstants.CML_XPATH);
        for (i = 0; i < nodes.size(); ++i) {
            nodes.get(i).detach();
        }
        nodes = cmlCml.query("cml:cml[count(cml:list)=1 and count(*)=1]/cml:list", CMLConstants.CML_XPATH);
        this.flattenGroupingElement(nodes);
        nodes = cmlCml.query("//cml:list[count(*)=0]", CMLConstants.CML_XPATH);
        for (i = 0; i < nodes.size(); ++i) {
            nodes.get(i).detach();
        }
        nodes = cmlCml.query("./cml:molecule", CMLConstants.CML_XPATH);
        if (nodes.size() > 1) {
            CMLMoleculeList moleculeList = new CMLMoleculeList();
            cmlCml.appendChild((Node)moleculeList);
            for (int i2 = 0; i2 < nodes.size(); ++i2) {
                nodes.get(i2).detach();
                moleculeList.addMolecule((AbstractMolecule)((CMLMolecule)nodes.get(i2)));
            }
        }
    }

    private void cleanExternalConnectionPoints() {
        if (this.cmlCml != null) {
            int i;
            Nodes molecules = this.cmlCml.query("//cml:molecule", CMLConstants.CML_XPATH);
            if (molecules.size() == 0) {
                return;
            }
            CMLMolecule molecule = (CMLMolecule)molecules.get(0);
            Nodes atoms = this.cmlCml.query("//cml:atom[@*[local-name()='NodeType' and .='ExternalConnectionPoint']]", CMLConstants.CML_XPATH);
            for (i = 0; i < atoms.size(); ++i) {
                atoms.get(i).detach();
            }
            atoms = this.cmlCml.query("//cml:atom[@*[local-name()='NodeType' and .='Fragment']]", CMLConstants.CML_XPATH);
            block3: for (i = 0; i < atoms.size(); ++i) {
                CMLAtom fragment = (CMLAtom)atoms.get(i);
                String fragmentId = fragment.getAttributeValue("id");
                ParentNode atomArray = fragment.getParent();
                int iatom = atomArray.indexOf((Node)fragment);
                CMLAtom nextAtom = null;
                try {
                    nextAtom = (CMLAtom)atomArray.getChild(iatom + 1);
                }
                catch (ArrayIndexOutOfBoundsException aaiobe) {
                    LOG.error((Object)("Cannot find neighboring atom " + iatom));
                    continue;
                }
                List bonds = molecule.getBonds();
                for (CMLBond bond : bonds) {
                    String[] atomRefs2 = bond.getAtomRefs2();
                    int otherAtomNo = -1;
                    if (atomRefs2[0].equals(fragmentId)) {
                        otherAtomNo = 1;
                    } else if (atomRefs2[1].equals(fragmentId)) {
                        otherAtomNo = 0;
                    }
                    if (otherAtomNo < 0) continue;
                    CMLAtom rootAtom = bond.getOtherAtom(fragment);
                    String order = bond.getOrder();
                    CMLBondStereo bondStereo = bond.getBondStereo();
                    molecule.deleteBond(bond);
                    molecule.deleteAtom(fragment);
                    CMLAtom atom0 = rootAtom;
                    CMLAtom atom1 = nextAtom;
                    if (otherAtomNo == 1) {
                        atom1 = rootAtom;
                        atom0 = nextAtom;
                    }
                    bond = new CMLBond(atom0, atom1);
                    bond.setOrder(order);
                    if (bondStereo != null) {
                        bond.addBondStereo((AbstractBondStereo)bondStereo);
                    }
                    molecule.addBond(bond);
                    continue block3;
                }
            }
        }
    }

    private void removeCDXAttributes() {
        if (this.cmlCml != null) {
            Nodes nodes = this.cmlCml.query("//*/@B | //*/@BondCircularOrdering | //*/@BS | //*/@Display | //*/@Display2 | //*/@DoublePosition | //*/@E | //*/@Order | //*/@Z", CMLConstants.CML_XPATH);
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).detach();
            }
        }
    }

    private void flattenGroupingElements() {
        if (this.cmlCml != null) {
            Nodes nodes = this.cmlCml.query("//cml:moleculeList", CMLConstants.CML_XPATH);
            this.flattenGroupingElement(nodes);
            nodes = this.cmlCml.query("//cml:list", CMLConstants.CML_XPATH);
            this.flattenGroupingElement(nodes);
        }
    }

    private void expandFontInfo(CDXObject page) {
        Nodes texts = page.query(".//t[@temp_Text]");
        for (int i = 0; i < texts.size(); ++i) {
            ((CDXText)texts.get(i)).addFontInfoFromTempText();
        }
    }

    public static void addLabelsToMolecules(CMLElement scopeElement) {
        Nodes moleculeListNodes = scopeElement.query("cml:moleculeList", CMLConstants.CML_XPATH);
        if (moleculeListNodes.size() > 0) {
            CMLMoleculeList moleculeList = (CMLMoleculeList)moleculeListNodes.get(0);
            Nodes labelNodes = scopeElement.query("cml:label", CMLConstants.CML_XPATH);
            for (CMLMolecule molecule : moleculeList.getMoleculeElements()) {
                if (molecule.getRef() != null && "" != molecule.getRef()) continue;
                CDXML2CMLProcessor.moveLabelsToMolecules(scopeElement, labelNodes, molecule);
            }
        }
    }

    public static void createMoleculeList(CMLElement element) {
        Nodes molecules = element.query("cml:molecule", CMLConstants.CML_XPATH);
        CMLMoleculeList moleculeList = new CMLMoleculeList();
        element.appendChild((Node)moleculeList);
        for (int i = 0; i < molecules.size(); ++i) {
            CMLMolecule molecule = (CMLMolecule)molecules.get(i);
            molecule.detach();
            moleculeList.addMolecule((AbstractMolecule)molecule);
        }
    }

    static void moveLabelsToMolecules(CMLElement element, Nodes labelNodes, CMLMolecule molecule) {
        if (!"cdx:fragment".equals(molecule.getRole())) {
            Real2Range moleculeBB = CDXML2CMLProcessor.getNormalizedBoundingBox((CMLElement)molecule);
            if (moleculeBB != null) {
                double molYMax = moleculeBB.getYRange().getMax();
                List<CMLLabel> labels = CDXML2CMLProcessor.getVerticalLabels((Element)element, labelNodes, moleculeBB, 100.0, -100.0, 9, 13);
                labels = CDXML2CMLProcessor.sortLabelsByY(labels);
                for (CMLLabel label : labels) {
                    Real2Range labelBB = CDXML2CMLProcessor.getNormalizedBoundingBox((CMLElement)label);
                    double deltaY = labelBB.getYRange().getMin() - molYMax;
                    if (deltaY < -20.0 || deltaY > 30.0) continue;
                    label.detach();
                    molecule.addLabel((AbstractLabel)label);
                }
            } else {
                LOG.debug((Object)"Null bounding box");
            }
        }
    }

    protected static List<CMLLabel> sortLabelsByY(List<CMLLabel> labels) throws NumberFormatException {
        ArrayList<CMLLabel> labelList1 = new ArrayList<CMLLabel>();
        while (labels.size() > 0) {
            double dd = -1.7976931348623157E308;
            CMLLabel label1 = null;
            for (CMLLabel label : labels) {
                String ys = label.getAttributeValue("ydelta", "http://www.xml-cml/namespaces/cdx");
                if (ys != null) {
                    double y = new Double(ys);
                    if (!(y > dd)) continue;
                    dd = y;
                    label1 = label;
                    continue;
                }
                label.debug();
            }
            labelList1.add(label1);
            labels.remove(label1);
        }
        return labelList1;
    }

    protected static List<CMLLabel> getVerticalLabels(Element parent, Nodes labelNodes, Real2Range boundingBox, double topYDelta, double bottomYDelta, int minFont, int maxFont) {
        ArrayList<CMLLabel> labelList = new ArrayList<CMLLabel>();
        if (boundingBox == null) {
            throw new RuntimeException("Null bounding box");
        }
        RealRange targetXRange = boundingBox.getXRange();
        RealRange targetYRange = boundingBox.getYRange();
        for (int i = 0; i < labelNodes.size(); ++i) {
            CMLLabel label = (CMLLabel)labelNodes.get(i);
            int fontSize = CDXML2CMLProcessor.getFontSize(label);
            if (fontSize < minFont || fontSize > maxFont) continue;
            Real2Range labelBoundingBox = CDXML2CMLProcessor.getNormalizedBoundingBox((CMLElement)label);
            if (labelBoundingBox != null) {
                RealRange labelXRange = labelBoundingBox.getXRange();
                RealRange labelYRange = labelBoundingBox.getYRange();
                RealRange commonXRange = labelXRange.intersectionWith(targetXRange);
                RealRange commonYRange = labelYRange.intersectionWith(targetYRange);
                if (commonXRange == null) continue;
                double yAbove = targetYRange.getMin() - labelYRange.getMax();
                double yBelow = targetYRange.getMax() - labelYRange.getMin();
                if (commonYRange != null || yAbove > 0.0 && yAbove < topYDelta) {
                    label.addAttribute(new Attribute("cdx:ydelta", "http://www.xml-cml/namespaces/cdx", "" + yAbove));
                    labelList.add(label);
                    continue;
                }
                if (commonYRange == null && (!(yBelow < 0.0) || !(yBelow > bottomYDelta))) continue;
                label.addAttribute(new Attribute("cdx:ydelta", "http://www.xml-cml/namespaces/cdx", "" + yBelow));
                labelList.add(label);
                continue;
            }
            LOG.warn((Object)("NULL LABEL " + label.getCMLValue()));
        }
        return labelList;
    }

    private static int getFontSize(CMLLabel label) {
        int size;
        String fontS = label.getAttributeValue("size", "http://www.xml-cml/namespaces/cdx");
        int n = size = fontS == null ? -1 : Integer.parseInt(fontS);
        if (fontS == null) {
            label.debug("FONT");
            throw new RuntimeException("all text should have font size");
        }
        return size;
    }

    static Real2Range getNormalizedBoundingBox(CMLElement element) throws EuclidRuntimeException {
        String boundingBoxS = element.getAttributeValue("BoundingBox", "http://www.xml-cml/namespaces/cdx");
        Real2Range r2r = null;
        if (boundingBoxS != null) {
            double[] bb = Util.splitToDoubleArray((String)boundingBoxS, (String)" ");
            r2r = new Real2Range(new RealRange(bb[0], bb[2], true), new RealRange(bb[1], bb[3], true));
        }
        return r2r;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public void setRescale(boolean rescale) {
        this.rescale = rescale;
    }

    public boolean isCleanMolecules() {
        return this.cleanMolecules;
    }

    public void setCleanMolecules(boolean cleanMolecules) {
        this.cleanMolecules = cleanMolecules;
    }

    private void transferChildrenToParent(Element element) {
        int nc = element.getChildCount();
        Element parent = (Element)element.getParent();
        int ii = parent.indexOf((Node)element);
        for (int i = nc - 1; i >= 0; --i) {
            Node child = element.getChild(i);
            parent.insertChild(child, ii);
        }
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

