/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.chemdraw;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.chemdraw.components.CDXObject;
import org.xmlcml.cml.chemdraw.components.CDXParser;
import org.xmlcml.cml.chemdraw.components.ChemdrawRuntimeException;

public class CDX2CDXML {
    static Logger LOG = Logger.getLogger(CDX2CDXML.class);
    private static final int ROWSIZE = 16;
    private static final int BLOCKSIZE = 128;
    private CDXObject parsedObject;
    private CDXParser parser;

    public CDX2CDXML() {
        this.init();
    }

    private void init() {
        this.parser = new CDXParser();
    }

    public void parseCDX(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        this.parseCDX(bytes);
    }

    public CDXParser getParser() {
        return this.parser;
    }

    public void parseCDX(byte[] bytes) {
        LOG.trace((Object)("bytes: " + bytes.length));
        this.parseAllowingForCorruptInput(bytes);
        this.parsedObject = this.parser.getParsedObject();
    }

    private void parseAllowingForCorruptInput(byte[] bytes) {
        boolean finished = false;
        int count = 12;
        while (!finished && count-- > 0) {
            try {
                this.parser.parseCDX(bytes);
                finished = true;
            }
            catch (ChemdrawRuntimeException cre) {
                bytes = this.exciseBlocksUntilNoLongerCorrupt(bytes, cre);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot parse", e);
            }
        }
    }

    private byte[] exciseBlocksUntilNoLongerCorrupt(byte[] bytes, ChemdrawRuntimeException cre) {
        int byteCount = this.parser.getByteCount();
        byteCount = this.roundToBlock(byteCount, 128);
        bytes = CDX2CDXML.exciseBlock(bytes, byteCount, 4);
        System.err.println("Excised block");
        return bytes;
    }

    public CDXObject getCDXMLObject() {
        return this.parsedObject;
    }

    private int roundToBlock(int byteCount, int blocksize) {
        return byteCount / blocksize * blocksize;
    }

    private void debugBytesBothways(String msg, byte[] bytes, int byteCount, int deltaBytes) {
        System.out.println(">>>>>>>>>>" + msg + ">>>>>>>>>>>>>>");
        System.out.println(CDX2CDXML.debugBytesFoward(bytes, byteCount - deltaBytes, deltaBytes));
        System.out.println("====================================");
        System.out.println(CDX2CDXML.debugBytesFoward(bytes, byteCount, deltaBytes));
        System.out.println("<<<<<<<<<<" + msg + "<<<<<<<<<<<<<");
    }

    private static String debugBytesFoward(byte[] bytes, int start, int deltaBytes) {
        StringBuilder sb = new StringBuilder();
        if (start % 16 != 0) {
            throw new RuntimeException("bad start " + start);
        }
        if (deltaBytes % 16 != 0) {
            throw new RuntimeException("bad deltaBytes " + start);
        }
        int nrows = deltaBytes / 16;
        for (int irow = 0; irow < nrows; ++irow) {
            byte[] rowBytes = CDX2CDXML.copyBytes(bytes, start, 16);
            sb.append(CDX2CDXML.toHexString(start) + ":  ");
            sb.append(CDX2CDXML.toString(rowBytes));
            sb.append("\n");
            start += 16;
        }
        return sb.toString();
    }

    private static String toString(byte[] rowByte) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowByte.length; ++i) {
            if (i > 0 && i % 8 == 0) {
                sb.append(" ");
            }
            sb.append(CDX2CDXML.toHexString(rowByte[i]));
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String toHexString(byte b) {
        String s = Integer.toHexString(b);
        StringBuilder sb = new StringBuilder(s);
        if (sb.length() == 8) {
            sb.delete(0, 6);
        } else if (sb.length() == 1) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    private static String toHexString(int i) {
        String s = Integer.toHexString(i);
        StringBuilder sb = new StringBuilder(s);
        if (sb.length() == 8) {
            sb.delete(0, 4);
        } else if (sb.length() == 1) {
            sb.insert(0, "000");
        } else if (sb.length() == 2) {
            sb.insert(0, "00");
        } else if (sb.length() == 3) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    private static byte[] copyBytes(byte[] bytes, int start, int rowsize) {
        byte[] rowBytes = new byte[rowsize];
        for (int i = 0; i < rowsize; ++i) {
            rowBytes[i] = bytes[start + i];
        }
        return rowBytes;
    }

    private static byte[] exciseBlock(byte[] bytes, int byteCount, int blocksToExcise) {
        int leftover = bytes.length % 128;
        if (leftover != 0) {
            throw new RuntimeException("bytes not multiple of blocksize " + bytes.length + " / " + leftover);
        }
        int startBlock = 128 * (byteCount / 128);
        if (bytes.length - startBlock < 128) {
            throw new RuntimeException("Final block error: " + bytes.length + " - " + startBlock + " < " + 128);
        }
        int second = startBlock + blocksToExcise * 128;
        int newLength = bytes.length - blocksToExcise * 128;
        byte[] newBytes = new byte[bytes.length - blocksToExcise * 128];
        System.out.println("start " + startBlock + "/" + bytes.length + "/" + newBytes.length + "/" + newLength);
        System.arraycopy(bytes, 0, newBytes, 0, startBlock);
        System.arraycopy(bytes, second, newBytes, startBlock, bytes.length - second);
        System.out.println("======================================BYTES " + newBytes.length);
        return newBytes;
    }

    private static byte[] exciseBlock(byte[] bytes, int byteCount) {
        int leftover = bytes.length % 128;
        if (leftover != 0) {
            throw new RuntimeException("bytes not multiple of blocksize " + bytes.length + " / " + leftover);
        }
        int startBlock = 128 * (byteCount / 128);
        if (bytes.length - startBlock < 128) {
            throw new RuntimeException("Final block error: " + bytes.length + " - " + startBlock + " < " + 128);
        }
        int second = startBlock + 128;
        byte[] newBytes = new byte[bytes.length - 128];
        System.arraycopy(bytes, 0, newBytes, 0, startBlock);
        System.arraycopy(bytes, second, newBytes, startBlock, bytes.length - second);
        System.out.println("======================================BYTES " + newBytes.length);
        return newBytes;
    }

    static {
        LOG.setLevel(Level.DEBUG);
    }
}

