/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public abstract class UrlLinkID3V2Frame
extends ID3V2Frame {
    protected String m_sURL = null;

    public UrlLinkID3V2Frame() {
    }

    public UrlLinkID3V2Frame(String sURL) throws ID3Exception {
        if (sURL == null) {
            throw new ID3Exception("URL in an URL link ID3 V2 frame cannot be null.");
        }
        this.m_sURL = sURL;
    }

    public UrlLinkID3V2Frame(URL oURL) throws ID3Exception {
        if (oURL == null) {
            throw new ID3Exception("URL in an URL link ID3 V2 frame cannot be null.");
        }
        this.m_sURL = oURL.toExternalForm();
    }

    public UrlLinkID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            byte[] abyUrl = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyUrl);
            this.m_sURL = new String(abyUrl);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sURL.getBytes());
    }
}

