/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class USLTID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sLanguage = null;
    private String m_sContentDescriptor = null;
    private String m_sLyrics = null;

    public USLTID3V2Frame(String sLanguage, String sContentDescriptor, String sLyrics) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sLanguage.length() != 3) {
            throw new ID3Exception("Language string length must be 3.");
        }
        this.m_sLanguage = sLanguage;
        this.m_sContentDescriptor = sContentDescriptor;
        this.m_sLyrics = sLyrics;
        if (this.m_sLyrics == null) {
            this.m_sLyrics = "";
        }
    }

    public USLTID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            byte[] abyLanguage = new byte[3];
            oFrameDataID3DIS.readFully(abyLanguage);
            this.m_sLanguage = new String(abyLanguage);
            this.m_sContentDescriptor = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            byte[] abyLyrics = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyLyrics);
            this.m_sLyrics = new String(abyLyrics, this.m_oTextEncoding.getEncodingString());
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitUSLTID3V2Frame(this);
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    public void setLanguage(String sLanguage) throws ID3Exception {
        String sOrigLanguage = this.m_sLanguage;
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("A three character length language code is required in USLT frame.");
        }
        this.m_sLanguage = sLanguage;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sLanguage = sOrigLanguage;
            throw e;
        }
    }

    public String getLanguage() {
        return this.m_sLanguage;
    }

    public void setContentDescriptor(String sContentDescriptor) throws ID3Exception {
        String sOrigContentDescriptor = this.m_sContentDescriptor;
        if (sContentDescriptor == null) {
            throw new ID3Exception("Content descriptor is required for USLT frame.");
        }
        this.m_sContentDescriptor = sContentDescriptor;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sContentDescriptor = sOrigContentDescriptor;
            throw e;
        }
    }

    public String getContentDescriptor() {
        return this.m_sContentDescriptor;
    }

    public void setLyrics(String sLyrics) {
        if (sLyrics == null) {
            this.m_sLyrics = "";
        }
        this.m_sLyrics = sLyrics;
    }

    public String getLyrics() {
        return this.m_sLyrics;
    }

    protected byte[] getFrameId() {
        return "USLT".getBytes();
    }

    public String toString() {
        return "Unsychronized lyrics: Language=[" + this.m_sLanguage + "], Content descriptor=[" + this.m_sContentDescriptor + "], Lyrics=[" + this.m_sLyrics + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sLanguage.getBytes());
        if (this.m_sContentDescriptor != null) {
            oIDOS.write(this.m_sContentDescriptor.getBytes(this.m_oTextEncoding.getEncodingString()));
        }
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_sLyrics.getBytes(this.m_oTextEncoding.getEncodingString()));
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof USLTID3V2Frame)) {
            return false;
        }
        USLTID3V2Frame oOtherUSLT = (USLTID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherUSLT.m_oTextEncoding) && this.m_sLanguage.equals(oOtherUSLT.m_sLanguage) && this.m_sContentDescriptor.equals(oOtherUSLT.m_sContentDescriptor) && this.m_sLyrics.equals(oOtherUSLT.m_sLyrics);
    }
}

