/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.v2.ID3V2Frame;

abstract class TextInformationID3V2Frame
extends ID3V2Frame {
    protected TextEncoding m_oTextEncoding;
    protected String m_sInformation;

    protected TextInformationID3V2Frame() {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
    }

    protected TextInformationID3V2Frame(TextEncoding oTextEncoding, String sInformation) {
        this.m_oTextEncoding = oTextEncoding;
        this.m_sInformation = sInformation;
    }

    protected TextInformationID3V2Frame(String sInformation) {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sInformation;
    }

    public TextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            byte[] abyInformation = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyInformation);
            this.m_sInformation = new String(abyInformation, this.m_oTextEncoding.getEncodingString());
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sInformation.getBytes(this.m_oTextEncoding.getEncodingString()));
    }
}

