/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TPOSTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iPartNumber;
    private int m_iTotalParts;

    public TPOSTextInformationID3V2Frame(int iPartNumber) throws ID3Exception {
        super(Integer.toString(iPartNumber));
        if (iPartNumber < 0) {
            throw new ID3Exception("Part number cannot be negative.");
        }
        this.m_iPartNumber = iPartNumber;
        this.m_iTotalParts = -1;
    }

    public TPOSTextInformationID3V2Frame(int iPartNumber, int iTotalParts) throws ID3Exception {
        super(Integer.toString(iPartNumber) + "/" + Integer.toString(iTotalParts));
        if (iPartNumber < 0) {
            throw new ID3Exception("Part number cannot be negative.");
        }
        if (iTotalParts < iPartNumber) {
            throw new ID3Exception("Total number of parts must be at least as great as the part number.");
        }
        this.m_iPartNumber = iPartNumber;
        this.m_iTotalParts = iTotalParts;
    }

    public TPOSTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            if (this.m_sInformation.indexOf(47) == -1) {
                this.m_iPartNumber = Integer.parseInt(this.m_sInformation);
                this.m_iTotalParts = -1;
            } else {
                String[] asPart = this.m_sInformation.split("/", 2);
                this.m_iPartNumber = Integer.parseInt(asPart[0]);
                this.m_iTotalParts = Integer.parseInt(asPart[1]);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TPOS part number frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTPOSTextInformationID3V2Frame(this);
    }

    public void setPartNumber(int iPartNumber) throws ID3Exception {
        if (iPartNumber < 0) {
            throw new ID3Exception("Part number cannot be negative.");
        }
        this.m_iPartNumber = iPartNumber;
        this.m_iTotalParts = -1;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = Integer.toString(iPartNumber);
    }

    public void setPartNumberAndTotalParts(int iPartNumber, int iTotalParts) throws ID3Exception {
        if (iPartNumber < 0) {
            throw new ID3Exception("Part number cannot be negative.");
        }
        if (iTotalParts < iPartNumber) {
            throw new ID3Exception("Total number of parts must be at least as great as the part number.");
        }
        this.m_iPartNumber = iPartNumber;
        this.m_iTotalParts = iTotalParts;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = iPartNumber + "/" + iTotalParts;
    }

    public int getPartNumber() {
        return this.m_iPartNumber;
    }

    public int getTotalParts() {
        return this.m_iTotalParts;
    }

    protected byte[] getFrameId() {
        return "TPOS".getBytes();
    }

    public String toString() {
        return "Part of a set: [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TPOSTextInformationID3V2Frame)) {
            return false;
        }
        TPOSTextInformationID3V2Frame oOtherTPOS = (TPOSTextInformationID3V2Frame)oOther;
        return this.m_iPartNumber == oOtherTPOS.m_iPartNumber && this.m_iTotalParts == oOtherTPOS.m_iTotalParts && this.m_oTextEncoding.equals(oOtherTPOS.m_oTextEncoding) && this.m_sInformation.equals(oOtherTPOS.m_sInformation);
    }
}

