/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.text.DecimalFormat;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TORYTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iOriginalReleaseYear;

    public TORYTextInformationID3V2Frame(int iOriginalReleaseYear) throws ID3Exception {
        super(TORYTextInformationID3V2Frame.getYearString(iOriginalReleaseYear));
        if (iOriginalReleaseYear < 0 || iOriginalReleaseYear > 9999) {
            throw new ID3Exception("Year in TORY tag must be between 0 and 9999.");
        }
        this.m_iOriginalReleaseYear = iOriginalReleaseYear;
    }

    public TORYTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_iOriginalReleaseYear = Integer.parseInt(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TORY original copyright year frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTORYTextInformationID3V2Frame(this);
    }

    public void setOriginalReleaseYear(int iOriginalReleaseYear) throws ID3Exception {
        if (iOriginalReleaseYear < 0 || iOriginalReleaseYear > 9999) {
            throw new ID3Exception("Year in TORY tag must be between 0 and 9999.");
        }
        this.m_iOriginalReleaseYear = iOriginalReleaseYear;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = TORYTextInformationID3V2Frame.getYearString(iOriginalReleaseYear);
    }

    public int getOriginalReleaseYear() {
        return this.m_iOriginalReleaseYear;
    }

    protected byte[] getFrameId() {
        return "TORY".getBytes();
    }

    public String toString() {
        return "Original release year: [" + this.m_sInformation + "]";
    }

    private static String getYearString(int iYear) {
        DecimalFormat oNF = new DecimalFormat("0000");
        return oNF.format(iYear);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TORYTextInformationID3V2Frame)) {
            return false;
        }
        TORYTextInformationID3V2Frame oOtherTORY = (TORYTextInformationID3V2Frame)oOther;
        return this.m_iOriginalReleaseYear == oOtherTORY.m_iOriginalReleaseYear && this.m_oTextEncoding.equals(oOtherTORY.m_oTextEncoding) && this.m_sInformation.equals(oOtherTORY.m_sInformation);
    }
}

