/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TCOMTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private String[] m_asComposer = null;

    public TCOMTextInformationID3V2Frame(String sComposer) {
        super(sComposer);
        this.m_asComposer = this.getComposers(sComposer);
    }

    public TCOMTextInformationID3V2Frame(String[] asComposer) {
        super("");
        StringBuffer sbComposers = new StringBuffer();
        for (int i = 0; i < asComposer.length; ++i) {
            sbComposers.append(asComposer[i] + "/");
        }
        sbComposers.deleteCharAt(sbComposers.length() - 1);
        this.m_sInformation = sbComposers.toString();
        this.m_asComposer = this.getComposers(this.m_sInformation);
    }

    public TCOMTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        this.m_asComposer = this.getComposers(this.m_sInformation);
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTCOMTextInformationID3V2Frame(this);
    }

    protected byte[] getFrameId() {
        return "TCOM".getBytes();
    }

    public String toString() {
        return "Composer(s): [" + this.m_sInformation + "]";
    }

    public void setComposer(String sComposer) {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sComposer;
        this.m_asComposer = this.getComposers(sComposer);
    }

    public void setComposers(String[] asComposer) {
        StringBuffer sbComposers = new StringBuffer();
        for (int i = 0; i < asComposer.length; ++i) {
            sbComposers.append(asComposer[i] + "/");
        }
        sbComposers.deleteCharAt(sbComposers.length() - 1);
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sbComposers.toString();
        this.m_asComposer = this.getComposers(this.m_sInformation);
    }

    public String[] getComposers() {
        return this.m_asComposer;
    }

    private String[] getComposers(String sValue) {
        String[] asComposer = sValue.split("/");
        return asComposer;
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TCOMTextInformationID3V2Frame)) {
            return false;
        }
        TCOMTextInformationID3V2Frame oOtherTCOM = (TCOMTextInformationID3V2Frame)oOther;
        return this.m_sInformation.equals(oOtherTCOM.m_sInformation) && this.m_oTextEncoding.equals(oOtherTCOM.m_oTextEncoding) && Arrays.equals(this.m_asComposer, oOtherTCOM.m_asComposer);
    }
}

